/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;

class SPage {
    static final int MIN_PERSISTENT_SIZE = 16;
    private static AtomicInteger counter = new AtomicInteger();
    STree stree;
    protected SPage next;
    protected SPage prev;
    protected BatchManager.ManagedBatch managedBatch;
    protected TupleBatch values;
    protected ArrayList<SPage> children;

    SPage(STree stree, boolean leaf) {
        this.stree = stree;
        this.values = new TupleBatch(counter.getAndIncrement(), new ArrayList(stree.pageSize / 4));
        if (!leaf) {
            this.children = new ArrayList(stree.pageSize / 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SearchResult search(SPage page, List k, LinkedList<SearchResult> parent) throws TeiidComponentException {
        TupleBatch previousValues = null;
        while (true) {
            int flippedIndex;
            int index;
            TupleBatch values;
            block12: {
                values = page.getValues();
                index = Collections.binarySearch(values.getTuples(), k, page.stree.comparator);
                flippedIndex = -index - 1;
                if (previousValues != null) {
                    if (flippedIndex == 0) {
                        return new SearchResult(-previousValues.getTuples().size() - 1, page.prev, previousValues);
                    }
                    if (parent != null && index != 0) {
                        page.stree.updateLock.lock();
                        try {
                            index = Collections.binarySearch(values.getTuples(), k, page.stree.comparator);
                            if (index == 0) break block12;
                            SPage childPage = page;
                            List oldKey = null;
                            List newKey = page.stree.extractKey(values.getTuples().get(0));
                            Iterator<SearchResult> desc = parent.descendingIterator();
                            while (desc.hasNext()) {
                                SearchResult sr = desc.next();
                                int parentIndex = Math.max(0, -sr.index - 2);
                                if (oldKey == null) {
                                    oldKey = sr.values.getTuples().set(parentIndex, newKey);
                                } else {
                                    if (page.stree.comparator.compare(oldKey, sr.values.getTuples().get(parentIndex)) != 0) break;
                                    sr.values.getTuples().set(parentIndex, newKey);
                                }
                                sr.page.children.set(parentIndex, childPage);
                                sr.page.setValues(sr.values);
                                childPage = sr.page;
                            }
                        }
                        finally {
                            page.stree.updateLock.unlock();
                        }
                    }
                }
            }
            if (flippedIndex != values.getTuples().size() || page.next == null) {
                return new SearchResult(index, page, values);
            }
            previousValues = values;
            page = page.next;
        }
    }

    protected void setValues(TupleBatch values) throws TeiidComponentException {
        if (this.managedBatch != null) {
            this.managedBatch.remove();
        }
        if (values.getTuples().size() < 16) {
            this.values = values;
            return;
        }
        this.values = null;
        if (this.children != null) {
            values.setDataTypes(this.stree.keytypes);
        } else {
            values.setDataTypes(this.stree.types);
        }
        this.managedBatch = this.children != null ? this.stree.keyManager.createManagedBatch(values, true) : this.stree.leafManager.createManagedBatch(values, this.stree.preferMemory);
    }

    protected void remove() {
        if (this.managedBatch != null) {
            this.managedBatch.remove();
            this.managedBatch = null;
        }
        this.values = null;
        this.children = null;
    }

    protected TupleBatch getValues() throws TeiidComponentException {
        if (this.values != null) {
            return this.values;
        }
        if (this.managedBatch == null) {
            throw new AssertionError((Object)"Batch removed");
        }
        if (this.children != null) {
            return this.managedBatch.getBatch(true, this.stree.keytypes);
        }
        return this.managedBatch.getBatch(true, this.stree.types);
    }

    static void merge(LinkedList<SearchResult> places, TupleBatch nextValues, SPage current, TupleBatch currentValues) throws TeiidComponentException {
        SearchResult parent = places.peekLast();
        if (parent != null) {
            SPage.correctParents(parent.page, nextValues.getTuples().get(0), current.next, current);
        }
        currentValues.getTuples().addAll(nextValues.getTuples());
        if (current.children != null) {
            current.children.addAll(current.next.children);
        }
        current.next.remove();
        current.next = current.next.next;
        if (current.next != null) {
            current.next.prev = current;
        }
        current.setValues(currentValues);
    }

    static void correctParents(SPage parent, List key, SPage page, SPage nextPage) throws TeiidComponentException {
        SearchResult location = SPage.search(parent, key, null);
        while (location.index == -1 && location.page.prev != null) {
            parent = location.page.prev;
            location = SPage.search(parent, key, null);
        }
        parent = location.page;
        int index = location.index;
        if (index < 0) {
            index = -index - 1;
        }
        while (parent != null) {
            while (index < parent.children.size()) {
                if (parent.children.get(index) != page) {
                    return;
                }
                parent.children.set(index++, nextPage);
            }
            index = 0;
            parent = parent.next;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        try {
            TupleBatch tb = this.getValues();
            result.append(tb.getBeginRow());
            if (this.children == null) {
                if (tb.getTuples().size() <= 1) {
                    result.append(tb.getTuples());
                } else {
                    result.append("[").append(tb.getTuples().get(0)).append(" . ").append(tb.getTuples().size()).append(" . ").append(tb.getTuples().get(tb.getTuples().size() - 1)).append("]");
                }
            } else {
                result.append("[");
                for (int i = 0; i < this.children.size(); ++i) {
                    result.append(tb.getTuples().get(i)).append("->").append(this.children.get(i).getValues().getBeginRow());
                    if (i >= this.children.size() - 1) continue;
                    result.append(", ");
                }
                result.append("]");
            }
        }
        catch (Throwable e) {
            result.append("Removed");
        }
        return result.toString();
    }

    static class SearchResult {
        int index;
        SPage page;
        TupleBatch values;

        public SearchResult(int index, SPage page, TupleBatch values) {
            this.index = index;
            this.page = page;
            this.values = values;
        }
    }
}

