/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionForm;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.util.CommandContext;

public class FunctionTree {
    private static final Integer DESCRIPTOR_KEY = new Integer(-1);
    private Map<String, Set<String>> categories = new HashMap<String, Set<String>>();
    private Map<String, List<FunctionMethod>> functionsByName = new HashMap<String, List<FunctionMethod>>();
    private Set<FunctionMethod> allFunctions = new HashSet<FunctionMethod>();
    private Map treeRoot = new HashMap();
    private boolean validateClass;

    public FunctionTree(String name, FunctionMetadataSource source) {
        this(name, source, false);
    }

    public FunctionTree(String name, FunctionMetadataSource source, boolean validateClass) {
        this.validateClass = validateClass;
        Collection<FunctionMethod> functions = source.getFunctionMethods();
        for (FunctionMethod method : functions) {
            if (!this.containsIndistinguishableFunction(method)) {
                this.addFunction(name, source, method);
                continue;
            }
            if ("SYS".equalsIgnoreCase(name)) continue;
            LogManager.logWarning((String)"org.teiid.PLANNER.FUNCTION_TREE", (String)QueryPlugin.Util.getString("ERR.015.001.0046", new Object[]{method}));
        }
    }

    private boolean containsIndistinguishableFunction(FunctionMethod method) {
        return this.allFunctions.contains(method);
    }

    Collection<String> getCategories() {
        return this.categories.keySet();
    }

    Collection<FunctionForm> getFunctionForms(String category) {
        HashSet<FunctionForm> functionForms = new HashSet<FunctionForm>();
        Set<String> functions = this.categories.get(category.toUpperCase());
        if (functions != null) {
            for (String functionName : functions) {
                for (FunctionMethod functionMethod : this.functionsByName.get(functionName)) {
                    functionForms.add(new FunctionForm(functionMethod));
                }
            }
        }
        return functionForms;
    }

    FunctionForm findFunctionForm(String name, int args) {
        List<FunctionMethod> results = this.findFunctionMethods(name, args);
        if (results.size() > 0) {
            return new FunctionForm(results.get(0));
        }
        return null;
    }

    List<FunctionMethod> findFunctionMethods(String name, int args) {
        ArrayList<FunctionMethod> allMatches = new ArrayList<FunctionMethod>();
        List<FunctionMethod> methods = this.functionsByName.get(name.toUpperCase());
        if (methods == null || methods.size() == 0) {
            return allMatches;
        }
        for (FunctionMethod functionMethod : methods) {
            if (functionMethod.getInputParameterCount() != args && (!functionMethod.isVarArgs() || args < functionMethod.getInputParameterCount() - 1)) continue;
            allMatches.add(functionMethod);
        }
        return allMatches;
    }

    public FunctionDescriptor addFunction(String schema, FunctionMetadataSource source, FunctionMethod method) {
        Set<String> functions;
        String categoryKey = method.getCategory();
        if (categoryKey == null) {
            method.setCategory("Miscellaneous");
            categoryKey = "Miscellaneous";
        }
        if ((functions = this.categories.get(categoryKey = categoryKey.toUpperCase())) == null) {
            functions = new HashSet<String>();
            this.categories.put(categoryKey, functions);
        }
        String methodName = schema + '.' + method.getName();
        List inputParams = method.getInputParameters();
        LinkedList inputTypes = new LinkedList();
        if (inputParams != null) {
            for (int i = 0; i < inputParams.size(); ++i) {
                String typeName = ((FunctionParameter)inputParams.get(i)).getType();
                inputTypes.add(DataTypeManager.getDataTypeClass((String)typeName));
            }
        }
        Class[] types = inputTypes.toArray(new Class[inputTypes.size()]);
        if (method.isVarArgs()) {
            inputTypes.set(inputTypes.size() - 1, Array.newInstance((Class)inputTypes.get(inputTypes.size() - 1), 0).getClass());
        }
        FunctionDescriptor descriptor = this.createFunctionDescriptor(source, method, inputTypes, types);
        descriptor.setSchema(schema);
        int index = -1;
        while (true) {
            String nameKey = methodName.toUpperCase();
            functions.add(nameKey);
            List<FunctionMethod> knownMethods = this.functionsByName.get(nameKey);
            if (knownMethods == null) {
                knownMethods = new ArrayList<FunctionMethod>();
                this.functionsByName.put(nameKey, knownMethods);
            }
            knownMethods.add(method);
            HashMap<Object, Cloneable> node = this.treeRoot;
            Object[] path = this.buildPath(methodName, types);
            for (int pathIndex = 0; pathIndex < path.length; ++pathIndex) {
                Object pathPart = path[pathIndex];
                HashMap<Object, Cloneable> children = (HashMap<Object, Cloneable>)node.get(pathPart);
                if (children == null) {
                    children = new HashMap<Object, Cloneable>();
                    node.put(pathPart, children);
                }
                if (method.isVarArgs() && pathIndex == path.length - 1) {
                    node.put(DESCRIPTOR_KEY, descriptor);
                }
                node = children;
            }
            if (method.isVarArgs()) {
                node.put(types[types.length - 1], node);
            }
            node.put(DESCRIPTOR_KEY, descriptor);
            index = methodName.indexOf(46, index + 1);
            if (index == -1) break;
            methodName = methodName.substring(index + 1);
        }
        this.allFunctions.add(method);
        return descriptor;
    }

    private FunctionDescriptor createFunctionDescriptor(FunctionMetadataSource source, FunctionMethod method, List<Class<?>> inputTypes, Class<?>[] types) {
        FunctionParameter outputParam = method.getOutputParameter();
        Class outputType = null;
        if (outputParam != null) {
            outputType = DataTypeManager.getDataTypeClass((String)outputParam.getType());
        }
        Method invocationMethod = null;
        boolean requiresContext = false;
        if (this.validateClass && (method.getPushdown() == FunctionMethod.PushDown.CAN_PUSHDOWN || method.getPushdown() == FunctionMethod.PushDown.CANNOT_PUSHDOWN)) {
            try {
                Class methodClass = source.getInvocationClass(method.getInvocationClass());
                ReflectionHelper helper = new ReflectionHelper(methodClass);
                try {
                    invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                }
                catch (NoSuchMethodException e) {
                    inputTypes.add(0, CommandContext.class);
                    invocationMethod = helper.findBestMethodWithSignature(method.getInvocationMethod(), inputTypes);
                    requiresContext = true;
                }
            }
            catch (ClassNotFoundException e) {
                throw new TeiidRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.no_class", new Object[]{method.getName(), method.getInvocationClass()}));
            }
            catch (NoSuchMethodException e) {
                throw new TeiidRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.no_method", new Object[]{method, method.getInvocationClass(), method.getInvocationMethod()}));
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((Throwable)e, "ERR.015.001.0047", QueryPlugin.Util.getString("ERR.015.001.0047", new Object[]{method, method.getInvocationClass(), method.getInvocationMethod()}));
            }
            if (invocationMethod != null) {
                Class<?> methodReturn = invocationMethod.getReturnType();
                if (methodReturn.equals(Void.TYPE)) {
                    throw new TeiidRuntimeException("ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.not_void", new Object[]{method.getName(), invocationMethod}));
                }
                int modifiers = invocationMethod.getModifiers();
                if (!Modifier.isPublic(modifiers)) {
                    throw new TeiidRuntimeException("ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.not_public", new Object[]{method.getName(), invocationMethod}));
                }
                if (!Modifier.isStatic(modifiers)) {
                    throw new TeiidRuntimeException("ERR.015.001.0047", QueryPlugin.Util.getString("FunctionTree.not_static", new Object[]{method.getName(), invocationMethod}));
                }
            }
        } else {
            inputTypes.add(0, CommandContext.class);
        }
        return new FunctionDescriptor(method, types, outputType, invocationMethod, requiresContext);
    }

    FunctionDescriptor getFunction(String name, Class<?>[] argTypes) {
        Object[] path = this.buildPath(name, argTypes);
        Map node = this.treeRoot;
        for (int i = 0; i < path.length; ++i) {
            if ((node = (Map)node.get(path[i])) != null) continue;
            return null;
        }
        if (node.containsKey(DESCRIPTOR_KEY)) {
            return (FunctionDescriptor)node.get(DESCRIPTOR_KEY);
        }
        return null;
    }

    private Object[] buildPath(String name, Class<?>[] argTypes) {
        Object[] path = new Object[argTypes.length + 1];
        path[0] = name.toUpperCase();
        System.arraycopy(argTypes, 0, path, 1, argTypes.length);
        return path;
    }
}

