/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.TransformationMetadata;

public class CompositeMetadataStore
extends MetadataStore {
    public CompositeMetadataStore(MetadataStore metadataStore) {
        this.addMetadataStore(metadataStore);
    }

    public CompositeMetadataStore(List<MetadataStore> metadataStores) {
        for (MetadataStore metadataStore : metadataStores) {
            this.addMetadataStore(metadataStore);
        }
    }

    public void addMetadataStore(MetadataStore metadataStore) {
        this.schemas.putAll(metadataStore.getSchemas());
        this.datatypes.addAll(metadataStore.getDatatypes());
    }

    public Schema getSchema(String fullName) throws QueryMetadataException {
        Schema result = (Schema)this.getSchemas().get(fullName);
        if (result == null) {
            throw new QueryMetadataException(fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public Table findGroup(String fullName) throws QueryMetadataException {
        int index = fullName.indexOf(TransformationMetadata.DELIMITER_STRING);
        if (index == -1) {
            throw new QueryMetadataException(fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        String schema = fullName.substring(0, index);
        Table result = (Table)this.getSchema(schema).getTables().get(fullName.substring(index + 1));
        if (result == null) {
            throw new QueryMetadataException(fullName + TransformationMetadata.NOT_EXISTS_MESSAGE);
        }
        return result;
    }

    public Collection<Table> getGroupsForPartialName(String partialGroupName) {
        LinkedList<Table> result = new LinkedList<Table>();
        for (Schema schema : this.getSchemas().values()) {
            for (Table t : schema.getTables().values()) {
                String name = t.getName();
                if (!this.matchesPartialName(partialGroupName, name, schema)) continue;
                result.add(t);
            }
        }
        return result;
    }

    protected boolean matchesPartialName(String partialGroupName, String name, Schema schema) {
        if (!StringUtil.endsWithIgnoreCase((String)name, (String)partialGroupName)) {
            return false;
        }
        int schemaMatch = partialGroupName.length() - name.length();
        return !(schemaMatch > 0 ? schemaMatch != schema.getName().length() + 1 || !StringUtil.startsWithIgnoreCase((String)partialGroupName, (String)schema.getName()) || partialGroupName.charAt(schemaMatch + 1) != '.' : schemaMatch < 0 && name.charAt(-schemaMatch - 1) != '.');
    }

    public Collection<Procedure> getStoredProcedure(String name) throws TeiidComponentException, QueryMetadataException {
        String schema;
        Procedure proc;
        LinkedList<Procedure> result = new LinkedList<Procedure>();
        int index = name.indexOf(TransformationMetadata.DELIMITER_STRING);
        if (index > -1 && (proc = (Procedure)this.getSchema(schema = name.substring(0, index)).getProcedures().get(name.substring(index + 1))) != null) {
            result.add(proc);
            return result;
        }
        for (Schema schema2 : this.getSchemas().values()) {
            for (Procedure p : schema2.getProcedures().values()) {
                if (!this.matchesPartialName(name, p.getName(), schema2)) continue;
                result.add(p);
            }
        }
        return result;
    }

    public Collection<Table> getXMLTempGroups(Table tableRecord) {
        ArrayList<Table> results = new ArrayList<Table>();
        String namePrefix = tableRecord.getName() + TransformationMetadata.DELIMITER_STRING;
        for (Table table : ((Schema)tableRecord.getParent()).getTables().values()) {
            if (table.getTableType() != Table.Type.XmlStagingTable || !table.getName().startsWith(namePrefix)) continue;
            results.add(table);
        }
        return results;
    }
}

