/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleAssignOutputElements
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(plan, 8);
        if (projectNode == null) {
            return plan;
        }
        List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        this.assignOutputElements(plan, projectCols, metadata, capFinder, rules, analysisRecord, context);
        return plan;
    }

    private void assignOutputElements(PlanNode root, List<SingleElementSymbol> outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        int nodeType = root.getType();
        root.setProperty(NodeConstants.Info.OUTPUT_COLS, outputElements);
        if (root.getChildCount() == 0) {
            return;
        }
        switch (nodeType) {
            case 1: {
                Command command = FrameUtil.getNonQueryCommand(root);
                if (command instanceof StoredProcedure) {
                    root.setProperty(NodeConstants.Info.OUTPUT_COLS, command.getProjectedSymbols());
                }
            }
            case 2: 
            case 32: 
            case 1024: {
                if (root.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
                    OrderBy elements = (OrderBy)root.getProperty(NodeConstants.Info.SORT_ORDER);
                    outputElements = new ArrayList<SingleElementSymbol>(outputElements);
                    boolean hasUnrelated = false;
                    for (OrderByItem item : elements.getOrderByItems()) {
                        if (item.getExpressionPosition() != -1) continue;
                        int index = outputElements.indexOf(item.getSymbol());
                        if (index != -1) {
                            item.setExpressionPosition(index);
                            continue;
                        }
                        hasUnrelated = true;
                        outputElements.add(item.getSymbol());
                    }
                    if (!hasUnrelated) {
                        root.setProperty(NodeConstants.Info.UNRELATED_SORT, false);
                    }
                }
                this.assignOutputElements(root.getLastChild(), outputElements, metadata, capFinder, rules, analysisRecord, context);
                break;
            }
            case 64: {
                outputElements = RuleAssignOutputElements.determineSourceOutput(root, outputElements, metadata, capFinder);
                root.setProperty(NodeConstants.Info.OUTPUT_COLS, outputElements);
                List<SingleElementSymbol> childElements = RuleAssignOutputElements.filterVirtualElements(root, outputElements, metadata);
                this.assignOutputElements(root.getFirstChild(), childElements, metadata, capFinder, rules, analysisRecord, context);
                break;
            }
            case 256: {
                for (PlanNode childNode : root.getChildren()) {
                    PlanNode projectNode = NodeEditor.findNodePreOrder(childNode, 8);
                    List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                    this.assignOutputElements(childNode, projectCols, metadata, capFinder, rules, analysisRecord, context);
                }
                break;
            }
            default: {
                if (root.getType() == 8) {
                    Set<WindowFunction> windowFunctions;
                    GroupSymbol intoGroup = (GroupSymbol)root.getProperty(NodeConstants.Info.INTO_GROUP);
                    if (intoGroup != null) {
                        PlanNode intoRoot = NodeEditor.findNodePreOrder(root, 64);
                        this.execute(intoRoot.getFirstChild(), metadata, capFinder, rules, analysisRecord, context);
                        return;
                    }
                    List<SingleElementSymbol> projectCols = outputElements;
                    boolean modifiedProject = false;
                    PlanNode sortNode = NodeEditor.findParent(root, 32, 64);
                    if (sortNode != null && sortNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
                        if (rules.contains(RuleConstants.ASSIGN_OUTPUT_ELEMENTS)) {
                            OrderBy elements = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
                            projectCols = new ArrayList<SingleElementSymbol>(projectCols);
                            for (OrderByItem item : elements.getOrderByItems()) {
                                if (item.getExpressionPosition() != -1) continue;
                                projectCols.remove(item.getSymbol());
                            }
                        } else {
                            modifiedProject = true;
                        }
                    }
                    root.setProperty(NodeConstants.Info.PROJECT_COLS, projectCols);
                    if (modifiedProject) {
                        root.getGroups().clear();
                        root.addGroups(GroupsUsedByElementsVisitor.getGroups(projectCols));
                        root.addGroups(GroupsUsedByElementsVisitor.getGroups(root.getCorrelatedReferenceElements()));
                    }
                    if (root.hasBooleanProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS) && (windowFunctions = RuleAssignOutputElements.getWindowFunctions(projectCols)).isEmpty()) {
                        root.setProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS, false);
                    }
                }
                List<SingleElementSymbol> requiredInput = this.collectRequiredInputSymbols(root);
                if (root.getType() == 128 && root.hasBooleanProperty(NodeConstants.Info.IS_OPTIONAL) && NodeEditor.findParent(root, 1) == null) {
                    PlanNode old = root;
                    PlanNode next = root.getFirstChild();
                    NodeEditor.removeChildNode(root.getParent(), root);
                    SymbolMap symbolMap = (SymbolMap)old.getProperty(NodeConstants.Info.SYMBOL_MAP);
                    if (!symbolMap.asMap().isEmpty()) {
                        FrameUtil.convertFrame(next.getParent(), symbolMap.asMap().keySet().iterator().next().getGroupSymbol(), null, symbolMap.asMap(), metadata);
                    }
                    PlanNode parent = next.getParent();
                    while (parent.getParent() != null && parent.getParent().getType() != 64) {
                        parent = parent.getParent();
                    }
                    if (!old.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) {
                        PlanNode project = NodeEditor.findNodePreOrder(parent, 8);
                        project.removeAllChildren();
                    } else {
                        PlanNode limit = NodeFactory.getNewNode(1024);
                        limit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, new Constant(1));
                        if (!rules.contains(RuleConstants.PUSH_LIMIT)) {
                            rules.push(RuleConstants.PUSH_LIMIT);
                        }
                        parent.getFirstChild().addAsParent(limit);
                    }
                    this.execute(parent, metadata, capFinder, rules, analysisRecord, context);
                    return;
                }
                if (root.getChildCount() == 1) {
                    this.assignOutputElements(root.getLastChild(), requiredInput, metadata, capFinder, rules, analysisRecord, context);
                    break;
                }
                for (PlanNode childNode : root.getChildren()) {
                    Set<GroupSymbol> filterGroups = FrameUtil.findJoinSourceNode(childNode).getGroups();
                    List<SingleElementSymbol> filteredElements = this.filterElements(requiredInput, filterGroups);
                    this.assignOutputElements(childNode, filteredElements, metadata, capFinder, rules, analysisRecord, context);
                }
            }
        }
    }

    public static Set<WindowFunction> getWindowFunctions(List<SingleElementSymbol> projectCols) {
        LinkedHashSet<WindowFunction> windowFunctions = new LinkedHashSet<WindowFunction>();
        for (SingleElementSymbol singleElementSymbol : projectCols) {
            AggregateSymbolCollectorVisitor.getAggregates(singleElementSymbol, null, null, null, windowFunctions, null);
        }
        return windowFunctions;
    }

    private List<SingleElementSymbol> filterElements(Collection<? extends SingleElementSymbol> requiredInput, Set<GroupSymbol> filterGroups) {
        ArrayList<SingleElementSymbol> filteredElements = new ArrayList<SingleElementSymbol>();
        for (SingleElementSymbol singleElementSymbol : requiredInput) {
            if (!filterGroups.containsAll(GroupsUsedByElementsVisitor.getGroups(singleElementSymbol))) continue;
            filteredElements.add(singleElementSymbol);
        }
        return filteredElements;
    }

    static List<? extends SingleElementSymbol> determineSourceOutput(PlanNode root, List<SingleElementSymbol> outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        PlanNode virtualRoot = root.getLastChild();
        if (RuleAssignOutputElements.hasDupRemoval(virtualRoot)) {
            SymbolMap symbolMap = (SymbolMap)root.getProperty(NodeConstants.Info.SYMBOL_MAP);
            return symbolMap.getKeys();
        }
        PlanNode limit = NodeEditor.findNodePreOrder(root, 1024, 8);
        if (limit == null) {
            return outputElements;
        }
        PlanNode sort = NodeEditor.findNodePreOrder(limit, 32, 8);
        if (sort == null) {
            return outputElements;
        }
        PlanNode access = NodeEditor.findParent(sort, 1);
        if (sort.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) || access != null && capFinder != null && CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, RuleRaiseAccess.getModelIDFromAccess(access, metadata), metadata, capFinder)) {
            return outputElements;
        }
        OrderBy sortOrder = (OrderBy)sort.getProperty(NodeConstants.Info.SORT_ORDER);
        List<SingleElementSymbol> topCols = FrameUtil.findTopCols(sort);
        SymbolMap symbolMap = (SymbolMap)root.getProperty(NodeConstants.Info.SYMBOL_MAP);
        List<ElementSymbol> symbolOrder = symbolMap.getKeys();
        for (OrderByItem item : sortOrder.getOrderByItems()) {
            ElementSymbol symbol;
            SingleElementSymbol expr = item.getSymbol();
            int index = topCols.indexOf(expr);
            if (index < 0 || outputElements.contains(symbol = symbolOrder.get(index))) continue;
            outputElements.add(symbol);
        }
        return outputElements;
    }

    static List<SingleElementSymbol> filterVirtualElements(PlanNode sourceNode, List<SingleElementSymbol> outputColumns, QueryMetadataInterface metadata) {
        PlanNode virtualRoot = sourceNode.getLastChild();
        List<PlanNode> allProjects = NodeEditor.findAllNodes(virtualRoot, 8, 8);
        int[] filteredIndex = new int[outputColumns.size()];
        Arrays.fill(filteredIndex, -1);
        SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        List<ElementSymbol> originalOrder = symbolMap.getKeys();
        boolean updateGroups = outputColumns.size() != originalOrder.size();
        boolean[] seenIndex = new boolean[outputColumns.size()];
        for (int i = 0; i < outputColumns.size(); ++i) {
            Expression expr = outputColumns.get(i);
            filteredIndex[i] = originalOrder.indexOf(expr);
            if (updateGroups) continue;
            seenIndex[filteredIndex[i]] = true;
        }
        if (!updateGroups) {
            for (boolean b : seenIndex) {
                if (b) continue;
                updateGroups = true;
                break;
            }
        }
        List newCols = null;
        for (int i = allProjects.size() - 1; i >= 0; --i) {
            PlanNode projectNode = allProjects.get(i);
            List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
            newCols = RelationalNode.projectTuple(filteredIndex, projectCols);
            projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, newCols);
            if (!updateGroups) continue;
            projectNode.getGroups().clear();
            projectNode.addGroups(GroupsUsedByElementsVisitor.getGroups(newCols));
            projectNode.addGroups(GroupsUsedByElementsVisitor.getGroups(projectNode.getCorrelatedReferenceElements()));
        }
        if (!updateGroups) {
            for (int i : filteredIndex) {
                if (i == filteredIndex[i]) continue;
                updateGroups = true;
                break;
            }
        }
        if (updateGroups) {
            SymbolMap newMap = new SymbolMap();
            List<Expression> originalExpressionOrder = symbolMap.getValues();
            for (int i = 0; i < filteredIndex.length; ++i) {
                newMap.addMapping(originalOrder.get(filteredIndex[i]), originalExpressionOrder.get(filteredIndex[i]));
            }
            PlanNode sortNode = NodeEditor.findNodePreOrder(sourceNode, 32, 8);
            if (sortNode != null) {
                OrderBy elements = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
                for (OrderByItem item : elements.getOrderByItems()) {
                    if (item.getExpressionPosition() == -1) continue;
                    item.setExpressionPosition(-1);
                    for (int i = 0; i < filteredIndex.length; ++i) {
                        if (item.getExpressionPosition() != filteredIndex[i]) continue;
                        item.setExpressionPosition(i);
                        break;
                    }
                    if (item.getExpressionPosition() != -1) continue;
                    sortNode.setProperty(NodeConstants.Info.UNRELATED_SORT, true);
                }
            }
            sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, newMap);
        }
        return newCols;
    }

    static boolean hasDupRemoval(PlanNode node) {
        List<PlanNode> nodes = NodeEditor.findAllNodes(node, 258, 10);
        for (PlanNode planNode : nodes) {
            if (planNode.getType() != 2 && (planNode.getType() != 256 || !Boolean.FALSE.equals(planNode.getProperty(NodeConstants.Info.USE_ALL)))) continue;
            return true;
        }
        return false;
    }

    private List<SingleElementSymbol> collectRequiredInputSymbols(PlanNode node) {
        LinkedHashSet<SingleElementSymbol> requiredSymbols = new LinkedHashSet<SingleElementSymbol>();
        HashSet<SingleElementSymbol> createdSymbols = new HashSet<SingleElementSymbol>();
        List outputCols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        switch (node.getType()) {
            case 8: {
                List projectCols = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (SingleElementSymbol ss : projectCols) {
                    if (ss instanceof AliasSymbol) {
                        createdSymbols.add(ss);
                        ss = ((AliasSymbol)ss).getSymbol();
                    }
                    if (ss instanceof WindowFunction || ss instanceof ExpressionSymbol && !(ss instanceof AggregateSymbol)) {
                        createdSymbols.add(ss);
                    }
                    ElementCollectorVisitor.getElements((LanguageObject)ss, requiredSymbols);
                }
                break;
            }
            case 16: {
                Criteria selectCriteria = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                ElementCollectorVisitor.getElements((LanguageObject)selectCriteria, requiredSymbols);
                break;
            }
            case 4: {
                List crits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null) break;
                for (Criteria joinCriteria : crits) {
                    ElementCollectorVisitor.getElements((LanguageObject)joinCriteria, requiredSymbols);
                }
                break;
            }
            case 128: {
                List groupCols = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                if (groupCols != null) {
                    for (Expression expression : groupCols) {
                        ElementCollectorVisitor.getElements((LanguageObject)expression, requiredSymbols);
                    }
                }
                SymbolMap symbolMap = (SymbolMap)node.getProperty(NodeConstants.Info.SYMBOL_MAP);
                HashSet<ElementSymbol> usedAggregates = new HashSet<ElementSymbol>();
                for (SingleElementSymbol singleElementSymbol : outputCols) {
                    Expression condition;
                    OrderBy orderBy;
                    if (!(singleElementSymbol instanceof ElementSymbol)) continue;
                    createdSymbols.add(singleElementSymbol);
                    Expression ex = symbolMap.getMappedExpression((ElementSymbol)singleElementSymbol);
                    if (!(ex instanceof AggregateSymbol)) continue;
                    AggregateSymbol agg = (AggregateSymbol)ex;
                    Expression aggExpr = agg.getExpression();
                    if (aggExpr != null) {
                        ElementCollectorVisitor.getElements((LanguageObject)aggExpr, requiredSymbols);
                    }
                    if ((orderBy = agg.getOrderBy()) != null) {
                        ElementCollectorVisitor.getElements((LanguageObject)orderBy, requiredSymbols);
                    }
                    if ((condition = agg.getCondition()) != null) {
                        ElementCollectorVisitor.getElements((LanguageObject)condition, requiredSymbols);
                    }
                    usedAggregates.add((ElementSymbol)singleElementSymbol);
                }
                for (Map.Entry entry : new ArrayList<Map.Entry<ElementSymbol, Expression>>(symbolMap.asMap().entrySet())) {
                    if (!(entry.getValue() instanceof AggregateSymbol) || usedAggregates.contains(entry.getKey())) continue;
                    symbolMap.asUpdatableMap().remove(entry.getKey());
                }
                if (!requiredSymbols.isEmpty() || !usedAggregates.isEmpty()) break;
                node.setProperty(NodeConstants.Info.IS_OPTIONAL, true);
            }
        }
        for (SymbolMap refs : node.getAllReferences()) {
            for (Expression expr : refs.asMap().values()) {
                ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbols);
            }
        }
        for (SingleElementSymbol currentOutputSymbol : outputCols) {
            if (createdSymbols.contains(currentOutputSymbol)) continue;
            requiredSymbols.add(currentOutputSymbol);
        }
        if (node.getType() == 8) {
            HashSet<Expression> expressions = new HashSet<Expression>();
            Iterator iterator = requiredSymbols.iterator();
            while (iterator.hasNext()) {
                SingleElementSymbol ses = (SingleElementSymbol)iterator.next();
                if (expressions.add(SymbolMap.getExpression(ses))) continue;
                iterator.remove();
            }
        }
        return new ArrayList<SingleElementSymbol>(requiredSymbols);
    }

    public String toString() {
        return "AssignOutputElements";
    }
}

