/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleChooseDependent
implements OptimizerRule {
    private static AtomicInteger ID = new AtomicInteger();
    public static final int DEFAULT_INDEPENDENT_CARDINALITY = 10;

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<CandidateJoin> matches = this.findCandidate(plan, metadata, analysisRecord);
        boolean pushCriteria = false;
        for (CandidateJoin entry : matches) {
            PlanNode joinNode = entry.joinNode;
            PlanNode sourceNode = entry.leftCandidate ? joinNode.getFirstChild() : joinNode.getLastChild();
            PlanNode siblingNode = entry.leftCandidate ? joinNode.getLastChild() : joinNode.getFirstChild();
            boolean bothCandidates = entry.leftCandidate && entry.rightCandidate;
            PlanNode chosenNode = this.chooseDepWithoutCosting(sourceNode, bothCandidates ? siblingNode : null, analysisRecord);
            if (chosenNode != null) {
                pushCriteria |= this.markDependent(chosenNode, joinNode, metadata, null);
                continue;
            }
            NewCalculateCostUtil.DependentCostAnalysis dca = NewCalculateCostUtil.computeCostForDepJoin(joinNode, !entry.leftCandidate, metadata, capFinder, context);
            PlanNode dependentNode = sourceNode;
            if (bothCandidates && dca.expectedCardinality == null) {
                dca = NewCalculateCostUtil.computeCostForDepJoin(joinNode, true, metadata, capFinder, context);
                if (dca.expectedCardinality != null) {
                    dependentNode = siblingNode;
                }
            }
            if (dca.expectedCardinality != null) {
                pushCriteria |= this.markDependent(dependentNode, joinNode, metadata, dca);
                continue;
            }
            float sourceCost = NewCalculateCostUtil.computeCostForTree(sourceNode, metadata);
            float siblingCost = NewCalculateCostUtil.computeCostForTree(siblingNode, metadata);
            if (bothCandidates && sourceCost != -1.0f && sourceCost < 10.0f && (sourceCost < siblingCost || siblingCost == -1.0f)) {
                pushCriteria |= this.markDependent(siblingNode, joinNode, metadata, null);
                continue;
            }
            if (siblingCost == -1.0f || !(siblingCost < 10.0f)) continue;
            pushCriteria |= this.markDependent(sourceNode, joinNode, metadata, null);
        }
        if (pushCriteria) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        return plan;
    }

    List<CandidateJoin> findCandidate(PlanNode root, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) {
        ArrayList<CandidateJoin> candidates = new ArrayList<CandidateJoin>();
        for (PlanNode joinNode : NodeEditor.findAllNodes(root, 4, 1)) {
            CandidateJoin candidate = null;
            Iterator<PlanNode> j = joinNode.getChildren().iterator();
            while (j.hasNext()) {
                PlanNode child = j.next();
                if ((child = FrameUtil.findJoinSourceNode(child)).hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP) || !this.isValidJoin(joinNode, child, analysisRecord)) continue;
                if (candidate == null) {
                    candidate = new CandidateJoin();
                    candidate.joinNode = joinNode;
                    candidates.add(candidate);
                }
                if (j.hasNext()) {
                    candidate.leftCandidate = true;
                    continue;
                }
                candidate.rightCandidate = true;
            }
        }
        return candidates;
    }

    boolean isValidJoin(PlanNode joinNode, PlanNode sourceNode, AnalysisRecord analysisRecord) {
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals(JoinType.JOIN_CROSS) || jtype.equals(JoinType.JOIN_FULL_OUTER)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join is CROSS or FULL OUTER: " + sourceNode.nodeToString());
            }
            return false;
        }
        if (!joinNode.getExportedCorrelatedReferences().isEmpty()) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join has a correlated nested table: " + sourceNode.nodeToString());
            }
            return false;
        }
        List jcrit = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        if (jcrit == null || jcrit.size() == 0) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join has no join criteria: " + sourceNode.nodeToString());
            }
            return false;
        }
        if (joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) == null) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as parent join has no equality expressions: " + sourceNode.nodeToString());
            }
            return false;
        }
        if (jtype.isOuter() && JoinUtil.getInnerSideJoinNodes(joinNode)[0] != sourceNode) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Rejecting dependent access node as it is on outer side of a join: " + sourceNode.nodeToString());
            }
            return false;
        }
        return true;
    }

    PlanNode chooseDepWithoutCosting(PlanNode rootNode1, PlanNode rootNode2, AnalysisRecord analysisRecord) {
        PlanNode sourceNode1 = FrameUtil.findJoinSourceNode(rootNode1);
        PlanNode sourceNode2 = null;
        if (rootNode2 != null) {
            sourceNode2 = FrameUtil.findJoinSourceNode(rootNode2);
        }
        if (sourceNode1.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                if (analysisRecord.recordDebug()) {
                    analysisRecord.println("Neither access node can be made dependent because both have unsatisfied access patterns: " + sourceNode1.nodeToString() + "\n" + sourceNode2.toString());
                }
                return null;
            }
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent to satisfy access pattern: " + sourceNode2.nodeToString());
            }
            return rootNode2;
        }
        if (sourceNode1.hasBooleanProperty(NodeConstants.Info.MAKE_DEP)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent due to hint: " + sourceNode1.nodeToString());
            }
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty(NodeConstants.Info.MAKE_DEP)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent due to hint: " + sourceNode2.nodeToString());
            }
            return rootNode2;
        }
        if (sourceNode1.hasBooleanProperty(NodeConstants.Info.MAKE_IND) && sourceNode2 != null) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent due to hint: " + sourceNode2.nodeToString());
            }
            return rootNode2;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty(NodeConstants.Info.MAKE_IND)) {
            if (analysisRecord.recordDebug()) {
                analysisRecord.println("Making access node dependent due to hint: " + sourceNode1.nodeToString());
            }
            return rootNode1;
        }
        return null;
    }

    boolean markDependent(PlanNode sourceNode, PlanNode joinNode, QueryMetadataInterface metadata, NewCalculateCostUtil.DependentCostAnalysis dca) throws QueryMetadataException, TeiidComponentException {
        boolean isLeft = joinNode.getFirstChild() == sourceNode;
        List independentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
        List dependentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
        if (independentExpressions == null || independentExpressions.isEmpty()) {
            return false;
        }
        String id = "$dsc/id" + ID.getAndIncrement();
        joinNode.setProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE, id);
        List<PlanNode> crits = this.getDependentCriteriaNodes(id, independentExpressions, dependentExpressions, isLeft ? joinNode.getLastChild() : joinNode.getFirstChild(), metadata, dca);
        PlanNode newRoot = sourceNode;
        for (PlanNode crit : crits) {
            newRoot.addAsParent(crit);
            newRoot = crit;
        }
        if (isLeft) {
            JoinUtil.swapJoinChildren(joinNode);
        }
        return true;
    }

    private List<PlanNode> getDependentCriteriaNodes(String id, List independentExpressions, List dependentExpressions, PlanNode indNode, QueryMetadataInterface metadata, NewCalculateCostUtil.DependentCostAnalysis dca) throws QueryMetadataException, TeiidComponentException {
        LinkedList<PlanNode> result = new LinkedList<PlanNode>();
        Float cardinality = null;
        for (int i = 0; i < dependentExpressions.size(); ++i) {
            Expression depExpr = (Expression)dependentExpressions.get(i);
            Expression indepExpr = (Expression)independentExpressions.get(i);
            DependentSetCriteria crit = new DependentSetCriteria(SymbolMap.getExpression(depExpr), id);
            float ndv = -1.0f;
            if (dca != null && dca.expectedNdv[i] != null) {
                if (dca.expectedNdv[i].floatValue() > 4.0f * dca.maxNdv[i].floatValue()) continue;
                ndv = dca.expectedNdv[i].floatValue();
                crit.setMaxNdv(dca.maxNdv[i].floatValue());
            } else {
                Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements((LanguageObject)indepExpr, true);
                if (cardinality == null) {
                    cardinality = Float.valueOf(NewCalculateCostUtil.computeCostForTree(indNode, metadata));
                }
                ndv = NewCalculateCostUtil.getNDVEstimate(indNode, metadata, cardinality.floatValue(), elems, true);
            }
            crit.setNdv(ndv);
            crit.setValueExpression(indepExpr);
            PlanNode selectNode = RelationalPlanner.createSelectNode(crit, false);
            selectNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
            result.add(selectNode);
        }
        return result;
    }

    public String toString() {
        return "ChooseDependent";
    }

    private static class CandidateJoin {
        PlanNode joinNode;
        boolean leftCandidate;
        boolean rightCandidate;

        private CandidateJoin() {
        }
    }
}

