/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleAssignOutputElements;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.FunctionCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleMergeVirtual
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean beforeDecomposeJoin = rules.contains(RuleConstants.DECOMPOSE_JOIN);
        for (PlanNode sourceNode : NodeEditor.findAllNodes(plan, 64)) {
            if (sourceNode.getChildCount() <= 0) continue;
            plan = RuleMergeVirtual.doMerge(sourceNode, plan, beforeDecomposeJoin, metadata);
        }
        return plan;
    }

    static PlanNode doMerge(PlanNode frame, PlanNode root, boolean beforeDecomposeJoin, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        GroupSymbol virtualGroup = frame.getGroups().iterator().next();
        if (virtualGroup.isProcedure()) {
            return root;
        }
        SymbolMap references = (SymbolMap)frame.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
        if (references != null) {
            return root;
        }
        PlanNode parentProject = NodeEditor.findParent(frame, 8);
        if (parentProject.getProperty(NodeConstants.Info.INTO_GROUP) != null) {
            return root;
        }
        if (!FrameUtil.canConvertAccessPatterns(frame)) {
            return root;
        }
        PlanNode projectNode = frame.getFirstChild();
        if (FrameUtil.isProcedure(projectNode)) {
            return root;
        }
        SymbolMap symbolMap = (SymbolMap)frame.getProperty(NodeConstants.Info.SYMBOL_MAP);
        PlanNode sortNode = NodeEditor.findParent(parentProject, 32, 64);
        if (sortNode != null && sortNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
            OrderBy sortOrder = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
            boolean unrelated = false;
            for (OrderByItem item : sortOrder.getOrderByItems()) {
                if (!item.isUnrelated()) continue;
                Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)item.getSymbol(), true);
                for (ElementSymbol elementSymbol : elements) {
                    if (!virtualGroup.equals(elementSymbol.getGroupSymbol())) continue;
                    unrelated = true;
                }
            }
            if (unrelated && NodeEditor.findNodePreOrder(frame, 2, 8) != null || NodeEditor.findNodePreOrder(frame, 256, 64) != null || NodeEditor.findNodePreOrder(frame, 128, 64) != null) {
                return root;
            }
        }
        if (projectNode.getType() != 8 || NodeEditor.findNodePreOrder(frame.getFirstChild(), 128, 68) != null || NodeEditor.findAllNodes(frame.getFirstChild(), 64, 64).isEmpty()) {
            PlanNode parentSource = NodeEditor.findParent(parentProject, 64);
            if (beforeDecomposeJoin && parentSource != null && parentSource.hasProperty(NodeConstants.Info.PARTITION_INFO) && !NodeEditor.findAllNodes(frame.getFirstChild(), 256, 64).isEmpty()) {
                return root;
            }
            return RuleMergeVirtual.checkForSimpleProjection(frame, root, parentProject, metadata);
        }
        PlanNode parentJoin = NodeEditor.findParent(frame, 4, 64);
        if (!RuleMergeVirtual.checkJoinCriteria(frame, virtualGroup, parentJoin)) {
            return root;
        }
        if (!RuleMergeVirtual.checkProjectedSymbols(projectNode, virtualGroup, parentJoin, metadata)) {
            return root;
        }
        FrameUtil.convertFrame(frame, virtualGroup, FrameUtil.findJoinSourceNode(projectNode).getGroups(), symbolMap.asMap(), metadata);
        PlanNode parentBottom = frame.getParent();
        RuleMergeVirtual.prepareFrame(frame);
        NodeEditor.removeChildNode(parentBottom, frame);
        NodeEditor.removeChildNode(parentBottom, projectNode);
        return root;
    }

    private static void prepareFrame(PlanNode frame) {
        PlanNode newRoot = FrameUtil.findJoinSourceNode(frame.getFirstChild());
        if (newRoot != null) {
            Collection ap = (Collection)frame.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
            if (ap != null) {
                Collection newAp = (Collection)newRoot.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
                if (newAp == null) {
                    newRoot.setProperty(NodeConstants.Info.ACCESS_PATTERNS, ap);
                } else {
                    newAp.addAll(ap);
                }
            }
            RulePlaceAccess.copyDependentHints(frame, newRoot);
        }
    }

    private static PlanNode checkForSimpleProjection(PlanNode frame, PlanNode root, PlanNode parentProject, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        PlanNode nodeToCheck;
        for (nodeToCheck = parentProject.getFirstChild(); nodeToCheck != frame; nodeToCheck = nodeToCheck.getFirstChild()) {
            if (nodeToCheck.getType() == 16 && nodeToCheck.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) continue;
            return root;
        }
        if (frame.getFirstChild().getType() == 1024 && NodeEditor.findParent(parentProject, 34, 320) != null) {
            return root;
        }
        List<? extends SingleElementSymbol> requiredElements = RuleAssignOutputElements.determineSourceOutput(frame, new ArrayList<SingleElementSymbol>(), metadata, null);
        List selectSymbols = (List)parentProject.getProperty(NodeConstants.Info.PROJECT_COLS);
        LinkedHashSet<ElementSymbol> symbols = new LinkedHashSet<ElementSymbol>();
        for (SingleElementSymbol symbol : selectSymbols) {
            Expression expr = SymbolMap.getExpression(symbol);
            if (!(expr instanceof ElementSymbol)) {
                return root;
            }
            requiredElements.remove(expr);
            if (symbols.add((ElementSymbol)expr)) continue;
            return root;
        }
        if (!requiredElements.isEmpty()) {
            return root;
        }
        RuleAssignOutputElements.filterVirtualElements(frame, new ArrayList<SingleElementSymbol>(symbols), metadata);
        for (nodeToCheck = parentProject.getFirstChild(); nodeToCheck != frame; nodeToCheck = nodeToCheck.getFirstChild()) {
            PlanNode current = nodeToCheck;
            NodeEditor.removeChildNode(current.getParent(), current);
        }
        if (NodeEditor.findParent(parentProject, 2, 64) != null) {
            PlanNode setOp;
            PlanNode lowerDup = NodeEditor.findNodePreOrder(frame.getFirstChild(), 2, 8);
            if (lowerDup != null) {
                NodeEditor.removeChildNode(lowerDup.getParent(), lowerDup);
            }
            if ((setOp = NodeEditor.findNodePreOrder(frame.getFirstChild(), 256, 64)) != null) {
                setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.FALSE);
                if (parentProject.getParent().getParent() != null) {
                    NodeEditor.removeChildNode(parentProject.getParent().getParent(), parentProject.getParent());
                } else {
                    parentProject.removeFromParent();
                    root = parentProject;
                }
            }
        }
        RuleMergeVirtual.correctOrderBy(frame, selectSymbols, parentProject);
        PlanNode parentSource = NodeEditor.findParent(frame, 64);
        PlanNode parentSetOp = NodeEditor.findParent(parentProject, 256, 64);
        if (parentSetOp == null || NodeEditor.findNodePreOrder(parentSetOp, 8) == parentProject) {
            if (parentSource != null) {
                FrameUtil.correctSymbolMap(((SymbolMap)frame.getProperty(NodeConstants.Info.SYMBOL_MAP)).asMap(), parentSource);
            }
            if (parentSetOp != null) {
                RuleMergeVirtual.correctOrderBy(frame, selectSymbols, parentSetOp);
            }
        }
        RuleMergeVirtual.prepareFrame(frame);
        NodeEditor.removeChildNode(parentProject, frame);
        if (parentProject.getParent() == null) {
            root = parentProject.getFirstChild();
            parentProject.removeChild(root);
            return root;
        }
        NodeEditor.removeChildNode(parentProject.getParent(), parentProject);
        return root;
    }

    private static void correctOrderBy(PlanNode frame, List<SingleElementSymbol> selectSymbols, PlanNode startNode) {
        PlanNode sort = NodeEditor.findParent(startNode, 32, 320);
        if (sort != null) {
            List childProject = (List)NodeEditor.findNodePreOrder(frame, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
            OrderBy elements = (OrderBy)sort.getProperty(NodeConstants.Info.SORT_ORDER);
            for (OrderByItem item : elements.getOrderByItems()) {
                item.setSymbol((SingleElementSymbol)childProject.get(selectSymbols.indexOf(item.getSymbol())));
            }
            sort.getGroups().clear();
            sort.addGroups(GroupsUsedByElementsVisitor.getGroups(elements));
        }
    }

    private static boolean checkProjectedSymbols(PlanNode projectNode, GroupSymbol virtualGroup, PlanNode parentJoin, QueryMetadataInterface metadata) {
        if (projectNode.hasBooleanProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS)) {
            return false;
        }
        List selectSymbols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        for (PlanNode sourceNode : NodeEditor.findAllNodes(projectNode, 64, 64)) {
            groups.addAll(sourceNode.getGroups());
        }
        boolean checkForNullDependent = false;
        if (parentJoin != null) {
            PlanNode joinToTest = parentJoin;
            while (joinToTest != null) {
                JoinType joinType = (JoinType)joinToTest.getProperty(NodeConstants.Info.JOIN_TYPE);
                if (joinType == JoinType.JOIN_FULL_OUTER) {
                    checkForNullDependent = true;
                    break;
                }
                if (joinType == JoinType.JOIN_LEFT_OUTER && FrameUtil.findJoinSourceNode(joinToTest.getLastChild()).getGroups().contains(virtualGroup)) {
                    checkForNullDependent = true;
                    break;
                }
                joinToTest = NodeEditor.findParent(joinToTest.getParent(), 4, 64);
            }
        }
        for (int i = 0; i < selectSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)selectSymbols.get(i);
            List<SubqueryContainer> scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(symbol);
            if (!scalarSubqueries.isEmpty()) {
                return false;
            }
            if (checkForNullDependent && JoinUtil.isNullDependent(metadata, groups, SymbolMap.getExpression(symbol))) {
                return false;
            }
            if (!FunctionCollectorVisitor.isNonDeterministic(symbol)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkJoinCriteria(PlanNode frame, GroupSymbol virtualGroup, PlanNode parentJoin) {
        if (parentJoin != null) {
            List<PlanNode> selectNodes = NodeEditor.findAllNodes(frame.getFirstChild(), 16, 64);
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(virtualGroup);
            for (PlanNode selectNode : selectNodes) {
                JoinType jt;
                if (selectNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM) || (jt = JoinUtil.getJoinTypePreventingCriteriaOptimization(parentJoin, groups)) == null || jt != JoinType.JOIN_FULL_OUTER && selectNode.getGroups().size() != 0) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "MergeVirtual";
    }
}

