/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.TempTable;

public class TempTableStore {
    private ConcurrentHashMap<String, MatTableInfo> matTables = new ConcurrentHashMap();
    private TempMetadataStore tempMetadataStore = new TempMetadataStore(new ConcurrentHashMap<String, TempMetadataID>());
    private Map<String, TempTable> groupToTupleSourceID = new ConcurrentHashMap<String, TempTable>();
    private String sessionID;
    private TempTableStore parentTempTableStore;

    public TempTableStore(String sessionID) {
        this.sessionID = sessionID;
    }

    public MatTableInfo getMatTableInfo(String tableName) {
        MatTableInfo newInfo = new MatTableInfo();
        MatTableInfo info = this.matTables.putIfAbsent(tableName, newInfo);
        if (info == null) {
            info = newInfo;
        }
        return info;
    }

    public void setParentTempTableStore(TempTableStore parentTempTableStore) {
        this.parentTempTableStore = parentTempTableStore;
    }

    public boolean hasTempTable(String tempTableName) {
        return this.groupToTupleSourceID.containsKey(tempTableName);
    }

    TempTable addTempTable(String tempTableName, Create create, BufferManager buffer, boolean add) {
        List<ElementSymbol> columns = create.getColumnSymbols();
        TempMetadataID id = this.tempMetadataStore.getTempGroupID(tempTableName);
        if (id == null) {
            id = this.tempMetadataStore.addTempGroup(tempTableName, columns, false, true);
            TempTableResolver.addAdditionalMetadata(create, id);
        }
        columns = new ArrayList<ElementSymbol>(create.getColumnSymbols());
        if (!create.getPrimaryKey().isEmpty()) {
            List<ElementSymbol> primaryKey = create.getPrimaryKey();
            columns.removeAll(primaryKey);
            columns.addAll(0, primaryKey);
        }
        TempTable tempTable = new TempTable(id, buffer, columns, create.getPrimaryKey().size(), this.sessionID);
        if (add) {
            this.groupToTupleSourceID.put(tempTableName, tempTable);
        }
        return tempTable;
    }

    void swapTempTable(String tempTableName, TempTable tempTable) {
        this.groupToTupleSourceID.put(tempTableName, tempTable);
    }

    public void removeTempTableByName(String tempTableName) {
        this.tempMetadataStore.removeTempGroup(tempTableName);
        TempTable table = this.groupToTupleSourceID.remove(tempTableName);
        if (table != null) {
            table.remove();
        }
    }

    public TempMetadataStore getMetadataStore() {
        return this.tempMetadataStore;
    }

    public void removeTempTables() {
        for (String name : this.groupToTupleSourceID.keySet()) {
            this.removeTempTableByName(name);
        }
    }

    public void setUpdatable(String name, boolean updatable) {
        TempTable table = this.groupToTupleSourceID.get(name);
        if (table != null) {
            table.setUpdatable(updatable);
        }
    }

    TempTable getOrCreateTempTable(String tempTableID, Command command, BufferManager buffer, boolean delegate) throws QueryProcessingException {
        Insert insert;
        GroupSymbol group;
        TempTable tsID = this.groupToTupleSourceID.get(tempTableID);
        if (tsID != null) {
            return tsID;
        }
        if (delegate && this.parentTempTableStore != null && (tsID = this.parentTempTableStore.groupToTupleSourceID.get(tempTableID)) != null) {
            return tsID;
        }
        List<ElementSymbol> columns = null;
        if (command instanceof Insert && (group = (insert = (Insert)command).getGroup()).isImplicitTempGroupSymbol()) {
            columns = insert.getVariables();
        }
        if (columns == null) {
            throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableStore.table_doesnt_exist_error", new Object[]{tempTableID}));
        }
        Create create = new Create();
        create.setTable(new GroupSymbol(tempTableID));
        create.setElementSymbolsAsColumns(columns);
        return this.addTempTable(tempTableID, create, buffer, true);
    }

    public Set<String> getAllTempTables() {
        return new HashSet<String>(this.groupToTupleSourceID.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempMetadataID getGlobalTempTableMetadataId(Object viewId, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, QueryResolverException, QueryValidatorException {
        String matViewName = metadata.getFullName(viewId);
        String matTableName = "#MAT_" + matViewName.toUpperCase();
        GroupSymbol group = new GroupSymbol(matViewName);
        group.setMetadataID(viewId);
        TempMetadataID id = this.tempMetadataStore.getTempGroupID(matTableName);
        if (id == null) {
            Object object = viewId;
            synchronized (object) {
                id = this.tempMetadataStore.getTempGroupID(matTableName);
                if (id == null) {
                    id = this.tempMetadataStore.addTempGroup(matTableName, ResolverUtil.resolveElementsInGroup(group, metadata), false, true);
                    id.setQueryNode(metadata.getVirtualPlan(viewId));
                    id.setCardinality(metadata.getCardinality(viewId));
                    id.setOriginalMetadataID(viewId);
                    Object pk = metadata.getPrimaryKey(viewId);
                    if (pk != null) {
                        ArrayList<TempMetadataID> primaryKey = TempTableStore.resolveIndex(metadata, id, pk);
                        id.setPrimaryKey(primaryKey);
                    }
                    Collection keys = metadata.getUniqueKeysInGroup(viewId);
                    for (Object key : keys) {
                        id.addUniqueKey(TempTableStore.resolveIndex(metadata, id, key));
                    }
                    Collection indexes = metadata.getIndexesInGroup(viewId);
                    for (Object index : indexes) {
                        id.addIndex(TempTableStore.resolveIndex(metadata, id, index));
                    }
                }
            }
        }
        this.updateCacheHint(viewId, metadata, group, id);
        return id;
    }

    private void updateCacheHint(Object viewId, QueryMetadataInterface metadata, GroupSymbol group, TempMetadataID id) throws TeiidComponentException, QueryMetadataException, QueryResolverException, QueryValidatorException {
        Command c = QueryResolver.resolveView(group, metadata.getVirtualPlan(viewId), "SELECT", metadata).getCommand();
        CacheHint hint = c.getCacheHint();
        id.setCacheHint(hint);
    }

    static ArrayList<TempMetadataID> resolveIndex(QueryMetadataInterface metadata, TempMetadataID id, Object pk) throws TeiidComponentException, QueryMetadataException {
        List cols = metadata.getElementIDsInKey(pk);
        ArrayList<TempMetadataID> primaryKey = new ArrayList<TempMetadataID>(cols.size());
        for (Object coldId : cols) {
            int pos = metadata.getPosition(coldId) - 1;
            primaryKey.add(id.getElements().get(pos));
        }
        return primaryKey;
    }

    public static class MatTableInfo {
        private long updateTime = -1L;
        private MatState state = MatState.NEEDS_LOADING;
        private long ttl = -1L;
        private boolean valid;

        synchronized boolean shouldLoad() throws TeiidComponentException {
            block7: while (true) {
                switch (this.state) {
                    case NEEDS_LOADING: 
                    case FAILED_LOAD: {
                        this.setState(MatState.LOADING);
                        return true;
                    }
                    case LOADING: {
                        if (this.valid) {
                            return false;
                        }
                        try {
                            this.wait();
                            continue block7;
                        }
                        catch (InterruptedException e) {
                            throw new TeiidComponentException((Throwable)e);
                        }
                    }
                    case LOADED: {
                        if (this.ttl >= 0L && System.currentTimeMillis() - this.updateTime - this.ttl > 0L) {
                            this.setState(MatState.LOADING);
                            return true;
                        }
                        return false;
                    }
                }
            }
        }

        public synchronized MatState setState(MatState state, Boolean valid, Long timestamp) {
            MatState oldState = this.state;
            LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object[])new Object[]{this, "setting matState to", state, valid, timestamp, "old values", oldState, this.valid});
            if (valid != null) {
                this.valid = valid;
            }
            this.setState(state);
            if (timestamp != null) {
                this.updateTime = timestamp;
            }
            this.notifyAll();
            return oldState;
        }

        private void setState(MatState state) {
            this.state = state;
            this.updateTime = System.currentTimeMillis();
        }

        public synchronized void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public synchronized long getUpdateTime() {
            return this.updateTime;
        }

        public synchronized MatState getState() {
            return this.state;
        }

        public synchronized boolean isValid() {
            return this.valid;
        }

        public synchronized long getTtl() {
            return this.ttl;
        }
    }

    public static enum MatState {
        NEEDS_LOADING,
        LOADING,
        FAILED_LOAD,
        LOADED;

    }
}

