/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.dqp.internal.datamgr.CapabilitiesConverter;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.CachedFinder;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class TestConnectorCapabilitiesFinder {
    @Test
    public void testFind() throws Exception {
        String modelName = "model";
        String functionName = "fakeFunction";
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setFunctionSupport("fakeFunction", true);
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add(modelName);
        VDBMetaData vdb = (VDBMetaData)Mockito.mock(VDBMetaData.class);
        ModelMetaData model = (ModelMetaData)Mockito.mock(ModelMetaData.class);
        Mockito.stub((Object)vdb.getModel(modelName)).toReturn((Object)model);
        Mockito.stub((Object)model.getSourceNames()).toReturn(bindings);
        BasicSourceCapabilities basicSourceCapabilities = new BasicSourceCapabilities();
        basicSourceCapabilities.setFunctionSupport(functionName, true);
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        ConnectorManager cm = (ConnectorManager)Mockito.mock(ConnectorManager.class);
        Mockito.stub((Object)cm.getCapabilities()).toReturn((Object)basicSourceCapabilities);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)cm);
        CachedFinder finder = new CachedFinder(repo, vdb);
        SourceCapabilities actual = finder.findCapabilities(modelName);
        Assert.assertEquals((String)"Did not get expected capabilities", (Object)true, (Object)actual.supportsFunction(functionName));
    }

    @Test
    public void testPushdownFunctionSupport() throws Exception {
        ExecutionFactory<Object, Object> ef = new ExecutionFactory<Object, Object>(){

            public void start() throws TranslatorException {
                super.start();
                this.addPushDownFunction("ns", "func", "string", new String[]{"string"});
            }
        };
        ef.start();
        BasicSourceCapabilities bsc = CapabilitiesConverter.convertCapabilities((ExecutionFactory)ef, (Object)"conn");
        Assert.assertTrue((String)"Did not get expected capabilities", (boolean)bsc.supportsFunction("ns.func"));
    }
}

