/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobType;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestDQPCore {
    private DQPCore core;
    private DQPConfiguration config;
    private AutoGenDataService agds;

    @Before
    public void setUp() throws Exception {
        this.agds = new AutoGenDataService();
        DQPWorkContext context = RealMetadataFactory.buildWorkContext(RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.exampleBQTCached().getMetadataStore(), "bqt", new FunctionTree[0]));
        context.getVDB().getModel("BQT3").setVisible(Boolean.valueOf(false));
        context.getVDB().getModel("VQT").setVisible(Boolean.valueOf(false));
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        context.getVDB().addAttchment(ConnectorManagerRepository.class, (Object)repo);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)this.agds);
        this.core = new DQPCore();
        this.core.setBufferService(new BufferService(){

            public BufferManager getBufferManager() {
                return BufferManagerFactory.createBufferManager();
            }
        });
        this.core.setCacheFactory((CacheFactory)new DefaultCacheFactory());
        this.core.setTransactionService((TransactionService)new FakeTransactionService());
        this.config = new DQPConfiguration();
        this.config.setMaxActivePlans(1);
        this.config.setUserRequestSourceConcurrency(2);
        this.config.setResultsetCacheConfig(new CacheConfiguration());
        this.core.start(this.config);
        this.core.getPrepPlanCache().setModTime(1L);
        this.core.getRsCache().setModTime(1L);
    }

    @After
    public void tearDown() throws Exception {
        DQPWorkContext.setWorkContext((DQPWorkContext)new DQPWorkContext());
        this.core.stop();
    }

    public RequestMessage exampleRequestMessage(String sql) {
        RequestMessage msg = new RequestMessage(sql);
        msg.setCursorType(1004);
        msg.setFetchSize(10);
        msg.setPartialResults(false);
        msg.setExecutionId(100L);
        return msg;
    }

    @Test
    public void testConfigurationSets() {
        Assert.assertEquals((long)1L, (long)this.core.getMaxActivePlans());
        Assert.assertEquals((long)2L, (long)this.core.getUserRequestSourceConcurrency());
    }

    @Test
    public void testRequest1() throws Exception {
        this.helpExecute("SELECT IntKey FROM BQT1.SmallA", "a");
    }

    @Test
    public void testUser1() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() = 'logon'";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser2() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() LIKE 'logon'";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser3() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() IN ('logon3') AND StringKey LIKE '1'";
        String userName = "logon3";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser4() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE 'logon4' = user() AND StringKey = '1'";
        String userName = "logon4";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser5() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() IS NULL ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser6() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() = 'logon33' ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser7() throws Exception {
        String sql = "UPDATE BQT1.SmallA SET IntKey = 2 WHERE user() = 'logon' AND StringKey = '1' ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser8() throws Exception {
        String sql = "SELECT user(), StringKey FROM BQT1.SmallA WHERE IntKey = 1 ";
        String userName = "logon";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testUser9() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.SmallA WHERE user() = StringKey AND StringKey = '1' ";
        String userName = "1";
        this.helpExecute(sql, userName);
    }

    @Test
    public void testEnvSessionId() throws Exception {
        String sql = "SELECT env('sessionid') as SessionID";
        String userName = "1";
        ResultsMessage rm = this.helpExecute(sql, userName);
        Assert.assertEquals((Object)"1", rm.getResults()[0].get(0));
    }

    @Test
    public void testEnvSessionIdMixedCase() throws Exception {
        String sql = "SELECT env('sEsSIonId') as SessionID";
        String userName = "1";
        ResultsMessage rm = this.helpExecute(sql, userName);
        Assert.assertEquals((Object)"1", rm.getResults()[0].get(0));
    }

    @Test
    public void testTxnAutoWrap() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        this.helpExecute(sql, "a", 1, true);
    }

    @Test
    public void testViewVisibility() throws Exception {
        String sql = "SELECT * FROM VQT.SmallA_2589g";
        this.helpExecute(sql, "a");
    }

    @Test
    public void testLimitCompensation() throws Exception {
        String sql = "SELECT * FROM VQT.SmallA_2589g LIMIT 1, 1";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        this.agds.setCaps((SourceCapabilities)caps);
        ResultsMessage rm = this.helpExecute(sql, "a");
        Assert.assertTrue((rm.getResults().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitCompensation1() throws Exception {
        String sql = "SELECT * FROM VQT.SmallA_2589g LIMIT 1, 1";
        ResultsMessage rm = this.helpExecute(sql, "a");
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
    }

    @Test
    public void testPlanningException() throws Exception {
        String sql = "SELECT IntKey FROM BQT1.BadIdea ";
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        try {
            message.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof QueryResolverException));
        }
    }

    @Ignore(value="visibility no longer ristricts access")
    @Test
    public void testLookupVisibility() throws Exception {
        this.helpTestVisibilityFails("select lookup('bqt3.smalla', 'intkey', 'stringkey', '?')");
    }

    @Test
    public void testCancel() throws Exception {
        Assert.assertFalse((boolean)this.core.cancelRequest(1L));
    }

    @Test
    public void testBufferLimit() throws Exception {
        String sql = "SELECT A.IntKey FROM BQT1.SmallA as A, BQT1.SmallA as B";
        String userName = "1";
        String sessionid = "1";
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setCursorType(1003);
        DQPWorkContext.getWorkContext().getSession().setSessionId(sessionid);
        DQPWorkContext.getWorkContext().getSession().setUserName(userName);
        ((BufferManagerImpl)this.core.getBufferManager()).setProcessorBatchSize(2);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        ResultsMessage rm = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)((Object)rm.getException()));
        Assert.assertEquals((long)2L, (long)rm.getResults().length);
        RequestWorkItem item = this.core.getRequestWorkItem(DQPWorkContext.getWorkContext().getRequestID(reqMsg.getExecutionId()));
        message = this.core.processCursorRequest(reqMsg.getExecutionId(), 3, 2);
        rm = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)((Object)rm.getException()));
        Assert.assertEquals((long)2L, (long)rm.getResults().length);
        for (int i = 0; i < 10 && item.getThreadState() != AbstractWorkItem.ThreadState.IDLE; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)AbstractWorkItem.ThreadState.IDLE, (Object)item.getThreadState());
        Assert.assertTrue((item.resultsBuffer.getManagedRowCount() <= 46 ? 1 : 0) != 0);
        for (int j = 0; j < 48; ++j) {
            item = this.core.getRequestWorkItem(DQPWorkContext.getWorkContext().getRequestID(reqMsg.getExecutionId()));
            message = this.core.processCursorRequest(reqMsg.getExecutionId(), j * 2 + 5, 2);
            rm = (ResultsMessage)message.get(5000L, TimeUnit.MILLISECONDS);
            Assert.assertNull((Object)((Object)rm.getException()));
            Assert.assertEquals((long)2L, (long)rm.getResults().length);
        }
    }

    @Test
    public void testBufferReuse() throws Exception {
        String sql = "SELECT A.IntKey FROM BQT1.SmallA as A, BQT1.SmallA as B ORDER BY A.IntKey";
        String userName = "1";
        String sessionid = "1";
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setCursorType(1003);
        DQPWorkContext.getWorkContext().getSession().setSessionId(sessionid);
        DQPWorkContext.getWorkContext().getSession().setUserName(userName);
        ((BufferManagerImpl)this.core.getBufferManager()).setProcessorBatchSize(2);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        ResultsMessage rm = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)((Object)rm.getException()));
        Assert.assertEquals((long)2L, (long)rm.getResults().length);
        RequestWorkItem item = this.core.getRequestWorkItem(DQPWorkContext.getWorkContext().getRequestID(reqMsg.getExecutionId()));
        Assert.assertEquals((long)100L, (long)item.resultsBuffer.getRowCount());
    }

    @Test
    public void testSourceConcurrency() throws Exception {
        this.agds.setSleep(100);
        StringBuffer sql = new StringBuffer();
        int branches = 20;
        for (int i = 0; i < branches; ++i) {
            if (i > 0) {
                sql.append(" union all ");
            }
            sql.append("select intkey || " + i + " from bqt1.smalla");
        }
        sql.append(" limit 2");
        this.helpExecute(sql.toString(), "a");
        Assert.assertTrue((this.agds.getExecuteCount().get() <= 6 ? 1 : 0) != 0);
        this.core.setUserRequestSourceConcurrency(20);
        this.agds.getExecuteCount().set(0);
        this.helpExecute(sql.toString(), "a");
        Assert.assertTrue((this.agds.getExecuteCount().get() <= 20 ? 1 : 0) != 0);
        Assert.assertTrue((this.agds.getExecuteCount().get() > 10 ? 1 : 0) != 0);
        this.core.setUserRequestSourceConcurrency(1);
        this.agds.getExecuteCount().set(0);
        this.helpExecute(sql.toString(), "a");
        Assert.assertEquals((long)1L, (long)this.agds.getExecuteCount().get());
    }

    @Test
    public void testUsingFinalBuffer() throws Exception {
        String sql = "select intkey from bqt1.smalla union select 1";
        ((BufferManagerImpl)this.core.getBufferManager()).setProcessorBatchSize(2);
        this.agds.sleep = 500;
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        ResultsMessage rm = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)((Object)rm.getException()));
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
        message = this.core.processCursorRequest(reqMsg.getExecutionId(), 3, 2);
        rm = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)((Object)rm.getException()));
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
        message = this.core.processCursorRequest(reqMsg.getExecutionId(), 3, 2);
        rm = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)((Object)rm.getException()));
        Assert.assertEquals((long)0L, (long)rm.getResults().length);
    }

    @Test
    public void testPreparedPlanInvalidation() throws Exception {
        String sql = "insert into #temp select * FROM vqt.SmallB";
        String userName = "1";
        int sessionid = 1;
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        ResultsMessage rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
        sql = "select * from #temp";
        reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setStatementType(RequestMessage.StatementType.PREPARED);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)10L, (long)rm.getResults().length);
        sql = "select * from #temp";
        reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setStatementType(RequestMessage.StatementType.PREPARED);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)10L, (long)rm.getResults().length);
        Assert.assertEquals((long)1L, (long)this.core.getPrepPlanCache().getCacheHitCount());
        Thread.sleep(100L);
        sql = "delete from #temp where a12345 = '11'";
        reqMsg = this.exampleRequestMessage(sql);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
        sql = "select * from #temp";
        reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setStatementType(RequestMessage.StatementType.PREPARED);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)10L, (long)rm.getResults().length);
        Assert.assertEquals((long)2L, (long)this.core.getPrepPlanCache().getCacheHitCount());
        sql = "delete from #temp";
        reqMsg = this.exampleRequestMessage(sql);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
        sql = "select * from #temp";
        reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setStatementType(RequestMessage.StatementType.PREPARED);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)0L, (long)rm.getResults().length);
        Assert.assertEquals((long)2L, (long)this.core.getPrepPlanCache().getCacheHitCount());
    }

    @Test
    public void testRsCacheInvalidation() throws Exception {
        String sql = "select * FROM vqt.SmallB";
        String userName = "1";
        int sessionid = 1;
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setUseResultSetCache(true);
        ResultsMessage rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)10L, (long)rm.getResults().length);
        sql = "select * FROM vqt.SmallB";
        reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setUseResultSetCache(true);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)10L, (long)rm.getResults().length);
        Assert.assertEquals((long)1L, (long)this.core.getRsCache().getCacheHitCount());
        Thread.sleep(100L);
        sql = "delete from bqt1.smalla";
        reqMsg = this.exampleRequestMessage(sql);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)1L, (long)rm.getResults().length);
        sql = "select * FROM vqt.SmallB";
        reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setUseResultSetCache(true);
        rm = this.execute(userName, sessionid, reqMsg);
        Assert.assertEquals((long)10L, (long)rm.getResults().length);
        Assert.assertEquals((long)1L, (long)this.core.getRsCache().getCacheHitCount());
    }

    @Test
    public void testLobConcurrency() throws Exception {
        RequestMessage reqMsg = this.exampleRequestMessage("select to_bytes(stringkey, 'utf-8') FROM BQT1.SmallA");
        reqMsg.setTxnAutoWrapMode("OFF");
        this.agds.setSleep(100);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        final LobThread t = new LobThread(reqMsg);
        t.start();
        message.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<ResultsMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(ResultsFuture<ResultsMessage> future) {
                try {
                    BlobType bt;
                    t.bt = bt = (BlobType)((ResultsMessage)future.get()).getResults()[0].get(0);
                    t.workContext = DQPWorkContext.getWorkContext();
                    LobThread lobThread = t;
                    synchronized (lobThread) {
                        t.notify();
                    }
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        message.get();
        t.join();
        Assert.assertNotNull((Object)((LobChunk)t.chunkFuture.get()).getBytes());
    }

    public void helpTestVisibilityFails(String sql) throws Exception {
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        reqMsg.setTxnAutoWrapMode("OFF");
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        ResultsMessage results = (ResultsMessage)message.get(5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"[QueryValidatorException]Group does not exist: BQT3.SmallA", (Object)results.getException().toString());
    }

    private ResultsMessage helpExecute(String sql, String userName) throws Exception {
        return this.helpExecute(sql, userName, 1, false);
    }

    private ResultsMessage helpExecute(String sql, String userName, int sessionid, boolean txnAutoWrap) throws Exception {
        RequestMessage reqMsg = this.exampleRequestMessage(sql);
        if (txnAutoWrap) {
            reqMsg.setTxnAutoWrapMode("ON");
        }
        ResultsMessage results = this.execute(userName, sessionid, reqMsg);
        this.core.terminateSession(String.valueOf(sessionid));
        Assert.assertNull((Object)this.core.getClientState(String.valueOf(sessionid), false));
        if (results.getException() != null) {
            throw results.getException();
        }
        return results;
    }

    private ResultsMessage execute(String userName, int sessionid, RequestMessage reqMsg) throws InterruptedException, ExecutionException, TimeoutException {
        DQPWorkContext.getWorkContext().getSession().setSessionId(String.valueOf(sessionid));
        DQPWorkContext.getWorkContext().getSession().setUserName(userName);
        ResultsFuture message = this.core.executeRequest(reqMsg.getExecutionId(), reqMsg);
        Assert.assertNotNull((Object)this.core.getClientState(String.valueOf(sessionid), false));
        ResultsMessage results = (ResultsMessage)message.get(500000L, TimeUnit.MILLISECONDS);
        return results;
    }

    private final class LobThread
    extends Thread {
        BlobType bt;
        private final RequestMessage reqMsg;
        volatile ResultsFuture<LobChunk> chunkFuture;
        protected DQPWorkContext workContext;

        private LobThread(RequestMessage reqMsg) {
            this.reqMsg = reqMsg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LobThread lobThread = this;
            synchronized (lobThread) {
                while (this.workContext == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.workContext.runInContext(new Runnable(){

                @Override
                public void run() {
                    try {
                        LobThread.this.chunkFuture = TestDQPCore.this.core.requestNextLobChunk(1, LobThread.this.reqMsg.getExecutionId(), LobThread.this.bt.getReferenceStreamId());
                    }
                    catch (TeiidProcessingException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

