/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestMultiSourceMetadataWrapper
extends TestCase {
    public void testMultiSourcePseudoElement() throws Exception {
        HashSet<String> multiSourceModels = new HashSet<String>();
        multiSourceModels.add("BQT1");
        MultiSourceMetadataWrapper wrapper = new MultiSourceMetadataWrapper((QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), multiSourceModels);
        Object groupID = wrapper.getGroupID("BQT1.SmallA");
        List elements = wrapper.getElementIDsInGroupID(groupID);
        TestMultiSourceMetadataWrapper.assertEquals((int)18, (int)elements.size());
        Object instanceElementID = elements.get(elements.size() - 1);
        TestMultiSourceMetadataWrapper.assertTrue((boolean)(instanceElementID instanceof MultiSourceElement));
        String fullName = wrapper.getFullName(instanceElementID);
        TestMultiSourceMetadataWrapper.assertEquals((String)"BQT1.SmallA.SOURCE_NAME", (String)fullName);
        TestMultiSourceMetadataWrapper.assertEquals(instanceElementID, (Object)wrapper.getElementID(fullName));
        TestMultiSourceMetadataWrapper.assertEquals((Object)groupID, (Object)wrapper.getGroupIDForElementID(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals(null, (Object)wrapper.getMaximumValue(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals(null, (Object)wrapper.getMinimumValue(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((Object)wrapper.getModelID(groupID), (Object)wrapper.getModelID(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals(null, (Object)wrapper.getDefaultValue(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((int)255, (int)wrapper.getElementLength(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((String)"string", (String)wrapper.getElementType(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((Object)new Properties(), (Object)wrapper.getExtensionProperties(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals(null, (String)wrapper.getNameInSource(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals(null, (String)wrapper.getNativeType(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((int)18, (int)wrapper.getPosition(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((int)0, (int)wrapper.getPrecision(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((int)0, (int)wrapper.getScale(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((int)0, (int)wrapper.getRadix(instanceElementID));
        TestMultiSourceMetadataWrapper.assertEquals((String)"SOURCE_NAME", (String)SingleElementSymbol.getShortName((String)fullName));
        TestMultiSourceMetadataWrapper.assertEquals((String)fullName, (String)(wrapper.getFullName(groupID) + "." + "SOURCE_NAME"));
    }
}

