/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;

public class TestMappingChoiceNode
extends TestCase {
    public void testChoice() {
        MappingChoiceNode choice = new MappingChoiceNode();
        TestMappingChoiceNode.assertFalse((boolean)choice.throwExceptionOnDefault());
        choice = new MappingChoiceNode(true);
        TestMappingChoiceNode.assertTrue((boolean)choice.throwExceptionOnDefault());
    }

    public void testAddWrongChoice() {
        MappingChoiceNode choice = new MappingChoiceNode();
        try {
            choice.addAllNode(new MappingAllNode());
            TestMappingChoiceNode.fail((String)"must have failed to add");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            choice.addSequenceNode(new MappingSequenceNode());
            TestMappingChoiceNode.fail((String)"must have failed to add");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            choice.addChildElement(new MappingElement("foo"));
            TestMappingChoiceNode.fail((String)"must have failed to add");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            choice.addChoiceNode(new MappingChoiceNode());
            TestMappingChoiceNode.fail((String)"must have failed to add");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testAddCriteria() {
        MappingChoiceNode choice = new MappingChoiceNode();
        choice.addCriteriaNode(new MappingCriteriaNode("chooseme > ?", false));
        MappingCriteriaNode c2 = new MappingCriteriaNode();
        choice.addCriteriaNode(c2);
        TestMappingChoiceNode.assertTrue((choice.getDefaultNode() == c2 ? 1 : 0) != 0);
    }

    public void testWithoutCriteria() {
        MappingChoiceNode choice = new MappingChoiceNode();
        try {
            choice.addCriteriaNode(new MappingCriteriaNode().setAsDefault(false));
            TestMappingChoiceNode.fail((String)"must have failed to add");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

