/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import junit.framework.TestCase;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestRuleRemoveSorts
extends TestCase {
    public void testRemovedOrderByFromQueryTransform() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 FROM vm1.g14", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    public void testRemovedOrderByFromQueryTransform2() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e, e2 FROM vm1.g8", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e1, e2 FROM pm1.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    public void testRemovedOrderByFromQueryTransform3() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e, e2 FROM vm1.g16", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e1, e2 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    public void testRemovedOrderByFromQueryTransform4() {
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT e1, e2 FROM vm1.g13", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT DISTINCT pm3.g1.e1, pm3.g1.e2, pm3.g1.e3, pm3.g1.e4 FROM pm3.g1"});
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    public void testOrderByWithLimit() throws Exception {
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from (SELECT e1, e2 FROM pm1.g1 order by e1 limit 10) x", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT g_0.e1 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }
}

