/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestWindowFunctions {
    @Test
    public void testViewNotRemoved() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ELEMENTARY_OLAP, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("SELECT y FROM (select row_number() over (order by e1) as y from pm1.g1) as x where x.y = 10", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT v_0.c_0 FROM (SELECT ROW_NUMBER() OVER (ORDER BY g_0.e1) AS c_0 FROM pm1.g1 AS g_0) AS v_0 WHERE v_0.c_0 = 10"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testWindowFunctionPushdown() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ELEMENTARY_OLAP, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.WINDOW_FUNCTION_ORDER_BY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e1) over (order by e1) as y from pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT MAX(g_0.e1) OVER (ORDER BY g_0.e1) FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testWindowFunctionPushdown1() throws Exception {
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ELEMENTARY_OLAP, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        ProcessorPlan plan = TestOptimizer.helpPlan("select max(e1) over (order by e1) as y from pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
    }

    @Test
    public void testRanking() throws Exception {
        String sql = "select e1, row_number() over (order by e1), rank() over (order by e1), dense_rank() over (order by e1 nulls last) from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", 2, 2, 1), Arrays.asList(null, 1, 1, 4), Arrays.asList("a", 3, 2, 1), Arrays.asList("c", 6, 6, 3), Arrays.asList("b", 5, 5, 2), Arrays.asList("a", 4, 2, 1)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPartitionedMax() throws Exception {
        String sql = "select e2, max(e1) over (partition by e2) as y from pm1.g1";
        List[] expected = new List[]{Arrays.asList(0, "a"), Arrays.asList(1, "c"), Arrays.asList(3, "a"), Arrays.asList(1, "c"), Arrays.asList(2, "b"), Arrays.asList(0, "a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUnrelatedWindowFunctionOrderBy() throws Exception {
        String sql = "select e2, e1 from pm1.g1 order by count(e1) over (partition by e3), e2";
        List[] expected = new List[]{Arrays.asList(1, "c"), Arrays.asList(3, "a"), Arrays.asList(0, "a"), Arrays.asList(0, "a"), Arrays.asList(1, null), Arrays.asList(2, "b")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testWindowFunctionOrderBy() throws Exception {
        String sql = "select e2, e1, count(e1) over (partition by e3) as c from pm1.g1 order by c, e2";
        List[] expected = new List[]{Arrays.asList(1, "c", 2), Arrays.asList(3, "a", 2), Arrays.asList(0, "a", 3), Arrays.asList(0, "a", 3), Arrays.asList(1, null, 3), Arrays.asList(2, "b", 3)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCountDuplicates() throws Exception {
        String sql = "select e1, count(e1) over (order by e1) as c from pm1.g1 order by e1";
        List[] expected = new List[]{Arrays.asList("a", 2), Arrays.asList("a", 2), Arrays.asList("b", 3)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b")});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testEmptyOver() throws Exception {
        String sql = "select e1, max(e1) over () as c from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", "c"), Arrays.asList(null, "c"), Arrays.asList("a", "c"), Arrays.asList("c", "c"), Arrays.asList("b", "c"), Arrays.asList("a", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testRowNumberMedian() throws Exception {
        String sql = "select e1, r, c from (select e1, row_number() over (order by e1) as r, count(*) over () c from pm1.g1) x where r = ceiling(c/2)";
        List[] expected = new List[]{Arrays.asList("a", 3, 6)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPartitionedRowNumber() throws Exception {
        String sql = "select e1, e3, row_number() over (partition by e3 order by e1) as r from pm1.g1 order by r limit 2";
        List[] expected = new List[]{Arrays.asList(null, Boolean.FALSE, 1), Arrays.asList("a", Boolean.TRUE, 1)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

