/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.symbol.Constant;

public class TestConstant
extends TestCase {
    public TestConstant(String name) {
        super(name);
    }

    public static final Constant sample1() {
        String s = "the string";
        return new Constant((Object)s);
    }

    public static final Constant sample2() {
        Integer i = new Integer(5);
        return new Constant((Object)i);
    }

    public void testString() {
        String s = "the string";
        Constant c = new Constant((Object)s);
        TestConstant.assertEquals((String)"Value is incorrect: ", (Object)s, (Object)c.getValue());
        TestConstant.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.STRING, (Object)c.getType());
        TestConstant.assertEquals((String)"Should be non-null: ", (boolean)false, (boolean)c.isNull());
        TestConstant.assertEquals((String)"Is not resolved: ", (boolean)true, (boolean)c.isResolved());
        TestConstant.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant((Object)s);
        TestConstant.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        TestConstant.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
    }

    public void testInteger() {
        Integer i = new Integer(5);
        Constant c = new Constant((Object)i);
        TestConstant.assertEquals((String)"Value is incorrect: ", (Object)i, (Object)c.getValue());
        TestConstant.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)c.getType());
        TestConstant.assertEquals((String)"Should be non-null: ", (boolean)false, (boolean)c.isNull());
        TestConstant.assertEquals((String)"Is not resolved: ", (boolean)true, (boolean)c.isResolved());
        TestConstant.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant((Object)i);
        TestConstant.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        TestConstant.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
    }

    public void testNoTypeNull() {
        Constant c = new Constant(null);
        TestConstant.assertEquals((String)"Value is incorrect: ", null, (Object)c.getValue());
        TestConstant.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.NULL, (Object)c.getType());
        TestConstant.assertEquals((String)"Should be null: ", (boolean)true, (boolean)c.isNull());
        TestConstant.assertEquals((String)"Is not resolved: ", (boolean)true, (boolean)c.isResolved());
        TestConstant.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant(null);
        TestConstant.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        TestConstant.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
    }

    public void testTypedNull() {
        Constant c = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
        TestConstant.assertEquals((String)"Value is incorrect: ", null, (Object)c.getValue());
        TestConstant.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.STRING, (Object)c.getType());
        TestConstant.assertEquals((String)"Should be null: ", (boolean)true, (boolean)c.isNull());
        TestConstant.assertEquals((String)"Is not resolved: ", (boolean)true, (boolean)c.isResolved());
        TestConstant.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
        TestConstant.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        TestConstant.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
        Constant c3 = new Constant(null);
        TestConstant.assertEquals((String)"Typed null not equal to non-typed null: ", (Object)c, (Object)c3);
    }

    public void testClone() {
        StringBuffer value = new StringBuffer("x");
        Constant c1 = new Constant((Object)value, DataTypeManager.DefaultDataClasses.OBJECT);
        Constant copy = (Constant)c1.clone();
        TestConstant.assertEquals((String)"Cloned object not equal to original: ", (Object)c1, (Object)copy);
        value.append("y");
        TestConstant.assertTrue((String)"Original object has not changed, but should have", (boolean)((StringBuffer)c1.getValue()).toString().equals("xy"));
        TestConstant.assertTrue((String)"Cloned object has not changed, but should have", (boolean)((StringBuffer)copy.getValue()).toString().equals("xy"));
    }

    public void testSelfEquivalence() {
        Constant s1 = TestConstant.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        Constant s1 = TestConstant.sample1();
        Constant s1a = TestConstant.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        Constant s1 = TestConstant.sample1();
        Constant s2 = TestConstant.sample2();
        int equals = -1;
        try {
            UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }
}

