/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net.socket;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.ServerConnection;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.Message;
import org.teiid.net.socket.ServerDiscovery;
import org.teiid.net.socket.SingleInstanceCommunicationException;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.net.socket.SocketServerInstance;
import org.teiid.net.socket.SocketServerInstanceFactory;
import org.teiid.net.socket.UrlServerDiscovery;

public class TestSocketServerConnection {
    @Test
    public void testSocketServerConnection_PropertiesClientHost() throws Throwable {
        Properties p = new Properties();
        SocketServerConnectionFactory.updateConnectionProperties((Properties)p);
        Assert.assertTrue((boolean)p.containsKey("clientHostName"));
        Assert.assertTrue((boolean)p.containsKey("clientIpAddress"));
    }

    @Test
    public void testLogonFailsWithMultipleHosts() throws Exception {
        Properties p = new Properties();
        SocketServerInstanceFactory instanceFactory = (SocketServerInstanceFactory)Mockito.mock(SocketServerInstanceFactory.class);
        Mockito.stub((Object)instanceFactory.getServerInstance((HostInfo)Mockito.anyObject())).toThrow((Throwable)new SingleInstanceCommunicationException());
        UrlServerDiscovery discovery = new UrlServerDiscovery(new TeiidURL("mm://host1:1,host2:2"));
        try {
            new SocketServerConnection(instanceFactory, false, (ServerDiscovery)discovery, p);
            Assert.fail((String)"exception expected");
        }
        catch (CommunicationException e) {
            Assert.assertEquals((Object)"No valid host available. Attempted connections to: [host1:1, host2:2]", (Object)e.getMessage());
        }
    }

    @Test
    public void testLogon() throws Exception {
        SocketServerConnection connection = this.createConnection(null);
        Assert.assertEquals((Object)String.valueOf(1), (Object)connection.getLogonResult().getSessionID());
    }

    @Test
    public void testChangeUser() throws Exception {
        Properties p = new Properties();
        SocketServerConnection connection = this.createConnection(null, p);
        Assert.assertEquals((Object)"fooUser", (Object)connection.getLogonResult().getUserName());
        p.setProperty("user", "newUser");
        connection.authenticate();
        Assert.assertEquals((Object)"newUser", (Object)connection.getLogonResult().getUserName());
    }

    @Test
    public void testRetry() throws Exception {
        SocketServerConnection connection = this.createConnection((Throwable)new SingleInstanceCommunicationException());
        connection.setFailOver(true);
        connection.setFailOverPingInterval(50);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        Thread.sleep(70L);
        logon.ping();
    }

    @Test(expected=CommunicationException.class)
    public void testImmediateFail() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        logon.ping();
    }

    @Test(expected=CommunicationException.class)
    public void testImmediateFail1() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        connection.setFailOver(true);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        logon.ping();
    }

    private SocketServerConnection createConnection(Throwable throwException) throws CommunicationException, ConnectionException {
        return this.createConnection(throwException, new Properties());
    }

    private SocketServerConnection createConnection(Throwable throwException, Properties p) throws CommunicationException, ConnectionException {
        return this.createConnection(throwException, new HostInfo("0.0.0.2", 1), p);
    }

    private SocketServerConnection createConnection(final Throwable t, final HostInfo hostInfo, Properties p) throws CommunicationException, ConnectionException {
        UrlServerDiscovery discovery = new UrlServerDiscovery(new TeiidURL(hostInfo.getHostName(), hostInfo.getPortNumber(), false));
        SocketServerInstanceFactory instanceFactory = new SocketServerInstanceFactory(){
            FakeILogon logon;
            {
                this.logon = new FakeILogon(t);
            }

            public SocketServerInstance getServerInstance(HostInfo info) throws CommunicationException, IOException {
                SocketServerInstance instance = (SocketServerInstance)Mockito.mock(SocketServerInstance.class);
                Mockito.stub((Object)instance.getCryptor()).toReturn((Object)new NullCryptor());
                Mockito.stub((Object)instance.getHostInfo()).toReturn((Object)hostInfo);
                Mockito.stub((Object)instance.getService(ILogon.class)).toReturn((Object)this.logon);
                Mockito.stub((Object)instance.getServerVersion()).toReturn((Object)"7.3");
                if (t != null) {
                    try {
                        ((SocketServerInstance)Mockito.doAnswer((Answer)new Answer<Void>(){

                            public Void answer(InvocationOnMock invocation) throws Throwable {
                                if (logon.t == null) {
                                    return null;
                                }
                                throw logon.t;
                            }
                        }).when((Object)instance)).send((Message)Mockito.anyObject(), (ResultsReceiver)Mockito.anyObject(), (Serializable)Mockito.anyObject());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Mockito.stub((Object)instance.isOpen()).toReturn((Object)true);
                return instance;
            }

            public void connected(SocketServerInstance instance, SessionToken session) {
            }

            public void disconnected(SocketServerInstance instance, SessionToken session) {
            }
        };
        SocketServerConnection connection = new SocketServerConnection(instanceFactory, false, (ServerDiscovery)discovery, p);
        return connection;
    }

    @Test
    public void testIsSameInstance() throws Exception {
        SocketServerConnection conn = this.createConnection(null, new HostInfo("0.0.0.0", 1), new Properties());
        SocketServerConnection conn1 = this.createConnection(null, new HostInfo("0.0.0.1", 1), new Properties());
        Assert.assertFalse((boolean)conn.isSameInstance((ServerConnection)conn1));
        Assert.assertTrue((boolean)conn.isSameInstance((ServerConnection)conn));
    }

    private static final class FakeILogon
    implements ILogon {
        Throwable t;

        public FakeILogon(Throwable t) {
            this.t = t;
        }

        public void assertIdentity(SessionToken sessionId) throws InvalidSessionException, TeiidComponentException {
        }

        public ResultsFuture<?> logoff() throws InvalidSessionException {
            return null;
        }

        public LogonResult logon(Properties connectionProperties) throws LogonException, TeiidComponentException {
            return new LogonResult(new SessionToken(1L, connectionProperties.getProperty("user", "fooUser")), "foo", 1, "fake");
        }

        public ResultsFuture<?> ping() throws TeiidComponentException, CommunicationException {
            if (this.t != null) {
                if (this.t instanceof CommunicationException) {
                    CommunicationException ce = (CommunicationException)this.t;
                    this.t = null;
                    throw ce;
                }
                TeiidComponentException e = new TeiidComponentException(this.t);
                this.t = null;
                throw e;
            }
            return ResultsFuture.NULL_FUTURE;
        }

        public ResultsFuture<?> ping(Collection<String> sessions) throws TeiidComponentException, CommunicationException {
            return this.ping();
        }
    }
}

