/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLWarning;
import java.util.List;
import org.teiid.client.SourceWarning;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.PartialResultsWarning;
import org.teiid.jdbc.TeiidSQLException;

class WarningUtil {
    private WarningUtil() {
    }

    static SQLWarning createWarning(Throwable ex) {
        SourceWarning exception;
        if (ex instanceof SourceWarning && (exception = (SourceWarning)((Object)ex)).isPartialResultsError()) {
            PartialResultsWarning warning = new PartialResultsWarning(JDBCPlugin.Util.getString("WarningUtil.Failures_occurred"));
            warning.addConnectorFailure(exception.getConnectorBindingName(), TeiidSQLException.create((Throwable)((Object)exception)));
            return warning;
        }
        return new SQLWarning(ex);
    }

    static SQLWarning convertWarnings(List<Exception> exceptions) {
        if (exceptions == null || exceptions.size() == 0) {
            return null;
        }
        SQLWarning warning = null;
        for (Exception ex : exceptions) {
            SQLWarning newWarning = WarningUtil.createWarning(ex);
            if (warning == null) {
                warning = newWarning;
                continue;
            }
            warning.setNextWarning(newWarning);
        }
        return warning;
    }
}

