/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.process.BaseQueryTest;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.RequestID;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;

public class TestXMLTypeTranslations
extends BaseQueryTest {
    private static final boolean DEBUG = false;

    public TestXMLTypeTranslations(String name) {
        super(name);
    }

    public void testXSDTranslations() throws Exception {
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities bsc = new BasicSourceCapabilities();
        bsc.setFunctionSupport("convert", true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        bsc.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        finder.addCapabilities("sample", (SourceCapabilities)bsc);
        TransformationMetadata metadata = TestXMLTypeTranslations.createMetadata(UnitTestUtil.getTestDataPath() + "/test.vdb");
        String sql = "select * from testdocument.testDocument";
        HardcodedDataManager dataMgr = new HardcodedDataManager();
        HashSet<String> models = new HashSet<String>();
        models.add("sample");
        dataMgr.setValidModels(models);
        Timestamp ts = new Timestamp(-2106305630000L);
        ts.setNanos(3000000);
        dataMgr.addData("SELECT g_0.\"timestamp\", g_0.\"double\", g_0.\"float\", convert(g_0.\"double\", biginteger), convert(g_0.\"date\", timestamp) FROM sample.RUNTIMEVALUE AS g_0", new List[]{Arrays.asList(ts, new Double(Double.NEGATIVE_INFINITY), new Float(Float.POSITIVE_INFINITY), new BigInteger("100"), ts)});
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><XSDTypesNS:test xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:XSDTypesNS=\"http://www.metamatrix.com/XMLSchema/DataSets/XSDTypes\"><book><datetime>1903-04-04T11:06:10.006Z</datetime><double>-INF</double><float>INF</float><gday>---100</gday><gmonth>--100</gmonth><gmonthday>--04-04</gmonthday><gyear>0100</gyear><gyearmonth>1903-04Z</gyearmonth><string>1</string></book></XSDTypesNS:test>")};
        this.doProcess((QueryMetadataInterface)metadata, sql, (CapabilitiesFinder)finder, (ProcessorDataManager)dataMgr, expected, false);
    }

    public void testGetXmlSchemas() throws Exception {
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        finder.addCapabilities("sample", (SourceCapabilities)new BasicSourceCapabilities());
        TransformationMetadata metadata = TestXMLTypeTranslations.createMetadata(UnitTestUtil.getTestDataPath() + "/test.vdb");
        String sql = "call getXMLSchemas('testdocument.testDocument')";
        DQPCore core = (DQPCore)Mockito.mock(DQPCore.class);
        RequestWorkItem rwi = (RequestWorkItem)Mockito.mock(RequestWorkItem.class);
        DQPWorkContext workContext = new DQPWorkContext();
        VDBMetaData vdb = new VDBMetaData();
        vdb.addAttchment(TransformationMetadata.class, (Object)metadata);
        workContext.getSession().setVdb(vdb);
        Mockito.stub((Object)rwi.getDqpWorkContext()).toReturn((Object)workContext);
        Mockito.stub((Object)core.getRequestWorkItem((RequestID)Mockito.anyObject())).toReturn((Object)rwi);
        DataTierManagerImpl dataMgr = new DataTierManagerImpl(core, null, true);
        this.doProcess((QueryMetadataInterface)metadata, sql, (CapabilitiesFinder)finder, (ProcessorDataManager)dataMgr, new List[]{Arrays.asList(new String(ObjectConverterUtil.convertToByteArray((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"test-schema.xsd")))))}, false);
    }
}

