/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.jdbc.JDBCPlugin;

public class RequestMessage
implements Externalizable {
    public static final int DEFAULT_FETCH_SIZE = 2048;
    public static final String TXN_WRAP_OFF = "OFF";
    public static final String TXN_WRAP_ON = "ON";
    public static final String TXN_WRAP_DETECT = "DETECT";
    private String[] commands;
    private boolean isBatchedUpdate;
    private int fetchSize = 2048;
    private int cursorType;
    private boolean partialResultsFlag;
    private StatementType statementType = StatementType.STATEMENT;
    private List<?> parameterValues;
    private boolean validationMode;
    private String txnAutoWrapMode;
    private String XMLFormat;
    private String styleSheet;
    private ResultsMode resultsMode = ResultsMode.EITHER;
    private boolean useResultSetCache;
    private boolean ansiQuotedIdentifiers = true;
    private ShowPlan showPlan = ShowPlan.OFF;
    private int rowLimit;
    private Serializable executionPayload;
    private long executionId;
    private int transactionIsolation;
    private boolean noExec;
    private transient boolean sync;

    public RequestMessage() {
    }

    public RequestMessage(String command) {
        this();
        this.setCommands(command);
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean supportsPartialResults() {
        return this.partialResultsFlag;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPartialResults(boolean partial) {
        this.partialResultsFlag = partial;
    }

    public boolean isPreparedStatement() {
        return this.statementType == StatementType.PREPARED;
    }

    public boolean isCallableStatement() {
        return this.statementType == StatementType.CALLABLE;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public List<?> getParameterValues() {
        if (this.parameterValues == null) {
            return Collections.EMPTY_LIST;
        }
        return this.parameterValues;
    }

    public void setParameterValues(List<?> values) {
        this.parameterValues = values;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    public boolean getValidationMode() {
        return this.validationMode;
    }

    public String getXMLFormat() {
        return this.XMLFormat;
    }

    public void setValidationMode(boolean validationMode) {
        this.validationMode = validationMode;
    }

    public void setXMLFormat(String xMLFormat) {
        this.XMLFormat = xMLFormat;
    }

    public String getTxnAutoWrapMode() {
        if (this.txnAutoWrapMode == null) {
            return TXN_WRAP_DETECT;
        }
        return this.txnAutoWrapMode;
    }

    public void setTxnAutoWrapMode(String txnAutoWrapMode) throws TeiidProcessingException {
        if (!(txnAutoWrapMode == null || (txnAutoWrapMode = txnAutoWrapMode.toUpperCase()).equals(TXN_WRAP_OFF) || txnAutoWrapMode.equals(TXN_WRAP_ON) || txnAutoWrapMode.equals(TXN_WRAP_DETECT))) {
            throw new TeiidProcessingException(JDBCPlugin.Util.getString("RequestMessage.invalid_txnAutoWrap", new Object[]{txnAutoWrapMode}));
        }
        this.txnAutoWrapMode = txnAutoWrapMode;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public boolean useResultSetCache() {
        return this.useResultSetCache;
    }

    public void setUseResultSetCache(boolean useResultSetCacse) {
        this.useResultSetCache = useResultSetCacse;
    }

    public String getCommandString() {
        if (this.commands.length == 1) {
            return this.commands[0];
        }
        return Arrays.deepToString(this.commands);
    }

    public boolean isAnsiQuotedIdentifiers() {
        return this.ansiQuotedIdentifiers;
    }

    public void setAnsiQuotedIdentifiers(boolean ansiQuotedIdentifiers) {
        this.ansiQuotedIdentifiers = ansiQuotedIdentifiers;
    }

    public ShowPlan getShowPlan() {
        return this.showPlan;
    }

    public void setShowPlan(ShowPlan showPlan) {
        this.showPlan = showPlan;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public void setCommands(String ... batchedCommands) {
        this.commands = batchedCommands;
    }

    public void setExecutionPayload(Serializable executionPayload) {
        this.executionPayload = executionPayload;
    }

    public Serializable getExecutionPayload() {
        return this.executionPayload;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public void setBatchedUpdate(boolean isBatchedUpdate) {
        this.isBatchedUpdate = isBatchedUpdate;
    }

    public boolean isBatchedUpdate() {
        return this.isBatchedUpdate;
    }

    public ResultsMode getResultsMode() {
        return this.resultsMode;
    }

    public void setResultsMode(ResultsMode resultsMode) {
        this.resultsMode = resultsMode;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public boolean isNoExec() {
        return this.noExec;
    }

    public void setNoExec(boolean noExec) {
        this.noExec = noExec;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.commands = ExternalizeUtil.readStringArray((ObjectInput)in);
        this.isBatchedUpdate = in.readBoolean();
        this.fetchSize = in.readInt();
        this.cursorType = in.readInt();
        this.partialResultsFlag = in.readBoolean();
        this.statementType = StatementType.values()[in.readByte()];
        this.parameterValues = ExternalizeUtil.readList((ObjectInput)in);
        this.validationMode = in.readBoolean();
        this.txnAutoWrapMode = (String)in.readObject();
        this.XMLFormat = (String)in.readObject();
        this.styleSheet = (String)in.readObject();
        this.resultsMode = ResultsMode.values()[in.readByte()];
        this.useResultSetCache = in.readBoolean();
        this.ansiQuotedIdentifiers = in.readBoolean();
        this.showPlan = ShowPlan.values()[in.readByte()];
        this.rowLimit = in.readInt();
        this.executionPayload = (Serializable)in.readObject();
        this.executionId = in.readLong();
        this.transactionIsolation = in.readInt();
        this.noExec = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeArray((ObjectOutput)out, (Object[])this.commands);
        out.writeBoolean(this.isBatchedUpdate);
        out.writeInt(this.fetchSize);
        out.writeInt(this.cursorType);
        out.writeBoolean(this.partialResultsFlag);
        out.writeByte(this.statementType.ordinal());
        ExternalizeUtil.writeList((ObjectOutput)out, this.parameterValues);
        out.writeBoolean(this.validationMode);
        out.writeObject(this.txnAutoWrapMode);
        out.writeObject(this.XMLFormat);
        out.writeObject(this.styleSheet);
        out.writeByte(this.resultsMode.ordinal());
        out.writeBoolean(this.useResultSetCache);
        out.writeBoolean(this.ansiQuotedIdentifiers);
        out.writeByte(this.showPlan.ordinal());
        out.writeInt(this.rowLimit);
        out.writeObject(this.executionPayload);
        out.writeLong(this.executionId);
        out.writeInt(this.transactionIsolation);
        out.writeBoolean(this.noExec);
    }

    public static enum ShowPlan {
        ON,
        DEBUG,
        OFF;

    }

    public static enum ResultsMode {
        RESULTSET,
        UPDATECOUNT,
        EITHER;

    }

    public static enum StatementType {
        PREPARED,
        CALLABLE,
        STATEMENT;

    }
}

