/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.util.ResultsFuture;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.StatementImpl;

public class NonBlockingRowProcessor
implements ResultsFuture.CompletionListener<Boolean> {
    private static Logger logger = Logger.getLogger(NonBlockingRowProcessor.class.getName());
    private StatementImpl stmt;
    private StatementCallback callback;

    public NonBlockingRowProcessor(StatementImpl stmt, StatementCallback callback) {
        this.stmt = stmt;
        this.callback = callback;
    }

    @Override
    public void onCompletion(ResultsFuture<Boolean> future) {
        try {
            boolean hasResultSet = future.get();
            if (!hasResultSet) {
                this.callback.onComplete(this.stmt);
                return;
            }
            final ResultSetImpl resultSet = this.stmt.getResultSet();
            Runnable rowProcessor = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block5: while (true) {
                        try {
                            ResultsFuture<Boolean> hasNext;
                            do {
                                ResultsFuture<Boolean> resultsFuture = hasNext = resultSet.submitNext();
                                synchronized (resultsFuture) {
                                    if (!hasNext.isDone()) {
                                        hasNext.addCompletionListener(new ResultsFuture.CompletionListener<Boolean>(){

                                            @Override
                                            public void onCompletion(ResultsFuture<Boolean> f) {
                                                if (NonBlockingRowProcessor.this.processRow(f)) {
                                                    this.run();
                                                }
                                            }
                                        });
                                        break block5;
                                    }
                                }
                            } while (NonBlockingRowProcessor.this.processRow(hasNext));
                        }
                        catch (Exception e) {
                            NonBlockingRowProcessor.this.onException(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            rowProcessor.run();
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    boolean processRow(ResultsFuture<Boolean> hasNext) {
        try {
            if (!hasNext.get().booleanValue()) {
                this.callback.onComplete(this.stmt);
                return false;
            }
            this.callback.onRow(this.stmt, this.stmt.getResultSet());
            return true;
        }
        catch (Exception e) {
            this.onException(e);
            return false;
        }
    }

    private void onException(Exception e) {
        try {
            this.callback.onException(this.stmt, e);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Unhandled exception from StatementCallback", e);
        }
    }
}

