/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.InlineViewCase;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestInlineView {
    public static FakeCapabilitiesFinder getInliveViewCapabilitiesFinder() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setFunctionSupport("concat", true);
        caps.setFunctionSupport("convert", true);
        caps.setFunctionSupport("case", true);
        caps.setFunctionSupport("+", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        return capFinder;
    }

    @Test
    public void testANSIJoinInlineView() throws Exception {
        this.runTest(TestInlineView.createANSIJoinInlineView());
    }

    @Test
    public void testInlineView() throws Exception {
        this.runTest(TestInlineView.createInlineView());
    }

    @Test
    public void testInlineViewWithDistinctAndOrderBy() throws Exception {
        this.runTest(TestInlineView.createInlineViewWithDistinctAndOrderBy());
    }

    @Test
    public void testInlineViewOfVirtual() throws Exception {
        this.runTest(TestInlineView.createInlineViewOfVirtual());
    }

    @Test
    public void testInlineViewWithOuterOrderAndGroup() throws Exception {
        this.runTest(TestInlineView.createInlineViewWithOuterOrderAndGroup());
    }

    @Test
    public void testInlineViewsInUnions() throws Exception {
        this.runTest(TestInlineView.crateInlineViewsInUnions());
    }

    @Test
    public void testUnionInInlineView() throws Exception {
        this.runTest(TestInlineView.createUnionInInlineView());
    }

    public static InlineViewCase createANSIJoinInlineView() throws Exception {
        String userQuery = "select q1.a from (select count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey) q1 left outer join bqt1.smallb on q1.a = bqt1.smallb.intkey where q1.intkey = 1";
        String optimizedQuery = "SELECT v_0.c_0 FROM (SELECT COUNT(g_0.intkey) AS c_0 FROM bqt1.smalla AS g_0 WHERE g_0.intkey = 1 GROUP BY g_0.intkey) AS v_0 LEFT OUTER JOIN bqt1.smallb AS g_1 ON v_0.c_0 = g_1.intkey";
        ArrayList<List<Integer>> expectedResults = new ArrayList<List<Integer>>();
        expectedResults.add(Arrays.asList(1));
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("db2");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testANSIJoinInlineView", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    public static InlineViewCase createInlineView() throws Exception {
        String userQuery = "select bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa from (select count(bqt1.smalla.intkey) as aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey) bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb, bqt1.smallb where bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.intkey = 1 and bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb.aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa = bqt1.smallb.intkey";
        String optimizedQuery = "SELECT v_0.c_0 FROM (SELECT COUNT(g_0.intkey) AS c_0 FROM bqt1.smalla AS g_0 WHERE g_0.intkey = 1 GROUP BY g_0.intkey) AS v_0, bqt1.smallb AS g_1 WHERE v_0.c_0 = g_1.intkey";
        ArrayList<List<Integer>> expectedResults = new ArrayList<List<Integer>>();
        expectedResults.add(Arrays.asList(1));
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("db2");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testInlineView", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    public static InlineViewCase createInlineViewWithDistinctAndOrderBy() throws Exception {
        String userQuery = "select Q1.a from (select distinct count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey order by bqt1.smalla.intkey) q1 inner join bqt1.smallb as q2 on q1.intkey = q2.intkey where q1.a = 1 and q1.a + q1.intkey = 2";
        String optimizedQuery = "SELECT v_0.c_1 FROM (SELECT g_0.intkey AS c_0, COUNT(g_0.intkey) AS c_1 FROM bqt1.smalla AS g_0 GROUP BY g_0.intkey HAVING (COUNT(g_0.intkey) = 1) AND ((COUNT(g_0.intkey) + g_0.intkey) = 2)) AS v_0, bqt1.smallb AS g_1 WHERE v_0.c_0 = g_1.intkey";
        ArrayList<List<Integer>> expectedResults = new ArrayList<List<Integer>>();
        expectedResults.add(Arrays.asList(1));
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("db2");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testInlineViewWithDistinctAndOrderBy", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    public static InlineViewCase createInlineViewOfVirtual() throws Exception {
        String userQuery = "select q1.A from (select count(intkey) as a, intkey, stringkey from vqt.smalla group by intkey, stringkey) q1 inner join vqt.smallb as q2 on q1.intkey = q2.a12345 where q1.a = 2";
        String optimizedQuery = "SELECT v_0.c_1 FROM (SELECT g_0.IntKey AS c_0, COUNT(g_0.IntKey) AS c_1 FROM BQT1.SmallA AS g_0 GROUP BY g_0.IntKey, g_0.StringKey HAVING COUNT(g_0.IntKey) = 2) AS v_0, BQT1.SmallA AS g_1 WHERE v_0.c_0 = Concat(g_1.StringKey, g_1.StringNum)";
        ArrayList expectedResults = new ArrayList();
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("db2");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testInlineViewOfVirtual", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    public static InlineViewCase createInlineViewWithOuterOrderAndGroup() throws Exception {
        String userQuery = "select count(Q1.a) b from (select distinct count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey order by bqt1.smalla.intkey) q1 inner join bqt1.smallb as q2 on q1.intkey = q2.intkey where q1.a = 1 and q1.a + q1.intkey = 2 group by Q1.a order by b";
        String optimizedQuery = "SELECT COUNT(v_0.c_1) AS c_0 FROM (SELECT g_0.intkey AS c_0, COUNT(g_0.intkey) AS c_1 FROM bqt1.smalla AS g_0 GROUP BY g_0.intkey HAVING (COUNT(g_0.intkey) = 1) AND ((COUNT(g_0.intkey) + g_0.intkey) = 2)) AS v_0, bqt1.smallb AS g_1 WHERE v_0.c_0 = g_1.intkey GROUP BY v_0.c_1 ORDER BY c_0";
        ArrayList<List<Integer>> expectedResults = new ArrayList<List<Integer>>();
        expectedResults.add(Arrays.asList(1));
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("db2");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testInlineViewWithOuterOrderAndGroup", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    public static InlineViewCase crateInlineViewsInUnions() throws Exception {
        String userQuery = "select q1.a from (select count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey) q1 left outer join bqt1.smallb on q1.a = bqt1.smallb.intkey where q1.intkey = 1 union all (select count(Q1.a) b from (select distinct count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey order by bqt1.smalla.intkey) q1 inner join bqt1.smallb as q2 on q1.intkey = q2.intkey where q1.a = 1 and q1.a + q1.intkey = 2 group by Q1.a order by b)";
        String optimizedQuery = "SELECT v_1.c_0 FROM (SELECT COUNT(g_2.intkey) AS c_0 FROM bqt1.smalla AS g_2 WHERE g_2.intkey = 1 GROUP BY g_2.intkey) AS v_1 LEFT OUTER JOIN bqt1.smallb AS g_3 ON v_1.c_0 = g_3.intkey UNION ALL SELECT COUNT(v_0.c_1) AS c_0 FROM (SELECT g_0.IntKey AS c_0, COUNT(g_0.IntKey) AS c_1 FROM bqt1.smalla AS g_0 GROUP BY g_0.IntKey HAVING (COUNT(g_0.IntKey) = 1) AND ((COUNT(g_0.IntKey) + g_0.IntKey) = 2)) AS v_0, bqt1.smallb AS g_1 WHERE v_0.c_0 = g_1.intkey GROUP BY v_0.c_1";
        ArrayList<List<Integer>> expectedResults = new ArrayList<List<Integer>>();
        expectedResults.add(Arrays.asList(1));
        expectedResults.add(Arrays.asList(2));
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("db2");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testInlineViewsInUnions", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    public static InlineViewCase createUnionInInlineView() throws Exception {
        String userQuery = "select t1.intkey from (select case when q1.a=1 then 2 else 1 end as a from (select count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey) q1 left outer join bqt1.smallb on q1.a = bqt1.smallb.intkey where q1.intkey = 1 union all (select count(Q1.a) b from (select distinct count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey order by bqt1.smalla.intkey) q1 inner join bqt1.smallb as q2 on q1.intkey = q2.intkey where q1.a = 1 and q1.a + q1.intkey = 2 group by Q1.a order by b)) as q3, bqt1.smallb as t1 where q3.a = t1.intkey order by t1.intkey";
        String optimizedQuery = "SELECT g_4.intkey AS c_0 FROM (SELECT CASE WHEN v_1.c_0 = 1 THEN 2 ELSE 1 END AS c_0 FROM (SELECT COUNT(g_2.intkey) AS c_0 FROM bqt1.smalla AS g_2 WHERE g_2.intkey = 1 GROUP BY g_2.intkey) AS v_1 LEFT OUTER JOIN bqt1.smallb AS g_3 ON v_1.c_0 = g_3.intkey UNION ALL SELECT COUNT(v_0.c_1) AS c_0 FROM (SELECT g_0.IntKey AS c_0, COUNT(g_0.IntKey) AS c_1 FROM bqt1.smalla AS g_0 GROUP BY g_0.IntKey HAVING (COUNT(g_0.IntKey) = 1) AND ((COUNT(g_0.IntKey) + g_0.IntKey) = 2)) AS v_0, bqt1.smallb AS g_1 WHERE v_0.c_0 = g_1.intkey GROUP BY v_0.c_1) AS v_2, bqt1.smallb AS g_4 WHERE v_2.c_0 = g_4.intkey ORDER BY c_0";
        ArrayList<List<Integer>> expectedResults = new ArrayList<List<Integer>>();
        expectedResults.add(Arrays.asList(1));
        expectedResults.add(Arrays.asList(2));
        HashSet<String> sourceQueries = new HashSet<String>();
        sourceQueries.add("oracle");
        sourceQueries.add("sybase");
        sourceQueries.add("sqlserver");
        sourceQueries.add("mysql");
        sourceQueries.add("postgres");
        return new InlineViewCase("testUnionInInlineView", userQuery, optimizedQuery, sourceQueries, expectedResults);
    }

    protected void runTest(InlineViewCase testCase) throws Exception {
        FakeCapabilitiesFinder capFinder = TestInlineView.getInliveViewCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(testCase.userQuery, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{testCase.optimizedQuery}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testAliasCreationWithInlineView() {
        FakeCapabilitiesFinder capFinder = TestInlineView.getInliveViewCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("select a, b from (select distinct count(intNum) a, count(stringKey), bqt1.smalla.intkey as b from bqt1.smalla group by bqt1.smalla.intkey) q1 order by q1.a", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT COUNT(g_0.intNum) AS c_0, g_0.intkey AS c_1 FROM bqt1.smalla AS g_0 GROUP BY g_0.intkey ORDER BY c_0"}, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testAliasPreservationWithInlineView() {
        FakeCapabilitiesFinder capFinder = TestInlineView.getInliveViewCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("select q1.a + 1, q1.b from (select count(bqt1.smalla.intNum) as a, bqt1.smalla.intkey as b from bqt1.smalla group by bqt1.smalla.intNum, bqt1.smalla.intkey order by b) q1 where q1.a = 1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT (q1.a + 1), q1.b FROM (SELECT COUNT(bqt1.smalla.intNum) AS a, bqt1.smalla.intkey AS b FROM bqt1.smalla GROUP BY bqt1.smalla.intNum, bqt1.smalla.intkey HAVING COUNT(bqt1.smalla.intNum) = 1) AS q1"}, true);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
    }

    @Test
    public void testCrossSourceInlineView() throws Exception {
        FakeCapabilitiesFinder capFinder = TestInlineView.getInliveViewCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan("select * from (select count(bqt1.smalla.intkey) as a, bqt1.smalla.intkey from bqt1.smalla group by bqt1.smalla.intkey) q1 inner join (select count(bqt2.smallb.intkey) as a, bqt2.smallb.intkey from bqt2.smallb group by bqt2.smallb.intkey) as q2 on q1.intkey = q2.intkey where q1.a = 1", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT v_0.c_0, v_0.c_1 FROM (SELECT g_0.intkey AS c_0, COUNT(g_0.intkey) AS c_1 FROM bqt2.smallb AS g_0 GROUP BY g_0.intkey) AS v_0 ORDER BY c_0", "SELECT v_0.c_0, v_0.c_1 FROM (SELECT g_0.intkey AS c_0, COUNT(g_0.intkey) AS c_1 FROM bqt1.smalla AS g_0 GROUP BY g_0.intkey HAVING COUNT(g_0.intkey) = 1) AS v_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0});
    }
}

