/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import junit.framework.TestCase;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestRulePlaceAccess
extends TestCase {
    private static final QueryMetadataInterface METADATA = RealMetadataFactory.example1Cached();

    public TestRulePlaceAccess(String name) {
        super(name);
    }

    public void testAddAccessPatterns2() throws Exception {
        Query query = new Query();
        From from = new From();
        GroupSymbol group = new GroupSymbol("pm4.g2");
        from.addGroup(group);
        query.setFrom(from);
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        query.setSelect(select);
        group.setMetadataID(METADATA.getGroupID("pm4.g2"));
        PlanNode n1 = NodeFactory.getNewNode((int)1);
        n1.setProperty(NodeConstants.Info.ATOMIC_REQUEST, (Object)query);
        n1.addGroup(group);
        RulePlaceAccess.addAccessPatternsProperty((PlanNode)n1, (QueryMetadataInterface)METADATA);
        Collection accessPatterns = (Collection)n1.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
        TestRulePlaceAccess.assertNotNull((Object)accessPatterns);
        TestRulePlaceAccess.assertTrue((String)("Expected two access patterns, got " + accessPatterns.size()), (accessPatterns.size() == 2 ? 1 : 0) != 0);
    }
}

