/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import junit.framework.TestCase;
import org.teiid.query.parser.TestParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;

public class TestSetQueryParsing
extends TestCase {
    public void testUnion() {
        SetQuery setQuery = this.exampleSetQuery(SetQuery.Operation.UNION);
        TestParser.helpTest("SELECT a FROM g UNION select b from h", "SELECT a FROM g UNION SELECT b FROM h", (Command)setQuery);
    }

    public void testExcept() {
        SetQuery setQuery = this.exampleSetQuery(SetQuery.Operation.EXCEPT);
        TestParser.helpTest("SELECT a FROM g except select b from h", "SELECT a FROM g EXCEPT SELECT b FROM h", (Command)setQuery);
    }

    public void testIntersect() {
        SetQuery setQuery = this.exampleSetQuery(SetQuery.Operation.INTERSECT);
        TestParser.helpTest("SELECT a FROM g intersect select b from h", "SELECT a FROM g INTERSECT SELECT b FROM h", (Command)setQuery);
    }

    public void testIntersectPresedence() {
        SetQuery setQuery = new SetQuery(SetQuery.Operation.INTERSECT, false, (QueryCommand)this.createTestQuery("t2"), (QueryCommand)this.createTestQuery("t3"));
        setQuery = new SetQuery(SetQuery.Operation.EXCEPT, false, (QueryCommand)this.createTestQuery("t1"), (QueryCommand)setQuery);
        TestParser.helpTest("select * from t1 EXCEPT select * from t2 INTERSECT select * from t3", "SELECT * FROM t1 EXCEPT (SELECT * FROM t2 INTERSECT SELECT * FROM t3)", (Command)setQuery);
    }

    private Query createTestQuery(String group) {
        GroupSymbol g = new GroupSymbol(group);
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((SelectSymbol)new MultipleElementSymbol());
        Query query1 = new Query();
        query1.setSelect(select);
        query1.setFrom(from);
        return query1;
    }

    private SetQuery exampleSetQuery(SetQuery.Operation op) {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("a"));
        Query query1 = new Query();
        query1.setSelect(select);
        query1.setFrom(from);
        g = new GroupSymbol("h");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        Query query2 = new Query();
        query2.setSelect(select);
        query2.setFrom(from);
        SetQuery setQuery = new SetQuery(op);
        setQuery.setAll(false);
        setQuery.setLeftQuery((QueryCommand)query1);
        setQuery.setRightQuery((QueryCommand)query2);
        return setQuery;
    }

    public void testUnionAll() {
        GroupSymbol g = new GroupSymbol("g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("a"));
        Query query1 = new Query();
        query1.setSelect(select);
        query1.setFrom(from);
        g = new GroupSymbol("h");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        Query query2 = new Query();
        query2.setSelect(select);
        query2.setFrom(from);
        SetQuery setQuery = new SetQuery(SetQuery.Operation.UNION);
        setQuery.setAll(true);
        setQuery.setLeftQuery((QueryCommand)query1);
        setQuery.setRightQuery((QueryCommand)query2);
        TestParser.helpTest("SELECT a FROM g UNION ALL select b from h", "SELECT a FROM g UNION ALL SELECT b FROM h", (Command)setQuery);
    }

    public void testTwoUnions() {
        SetQuery setQuery = new SetQuery(SetQuery.Operation.UNION);
        setQuery.setAll(false);
        GroupSymbol g = new GroupSymbol("g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery.setLeftQuery((QueryCommand)query);
        g = new GroupSymbol("g2");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c2"));
        query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery.setRightQuery((QueryCommand)query);
        g = new GroupSymbol("g3");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c3"));
        query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)setQuery, (QueryCommand)query);
        TestParser.helpTest("select c1 from g1 union select c2 from g2 union select c3 from g3", "SELECT c1 FROM g1 UNION SELECT c2 FROM g2 UNION SELECT c3 FROM g3", (Command)setQuery);
    }

    public void testThreeUnions() {
        SetQuery setQuery = new SetQuery(SetQuery.Operation.UNION);
        setQuery.setAll(false);
        GroupSymbol g = new GroupSymbol("g1");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c1"));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery.setLeftQuery((QueryCommand)query);
        g = new GroupSymbol("g2");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c2"));
        query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery.setRightQuery((QueryCommand)query);
        g = new GroupSymbol("g3");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c3"));
        query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery = new SetQuery(SetQuery.Operation.UNION, true, (QueryCommand)setQuery, (QueryCommand)query);
        g = new GroupSymbol("g4");
        from = new From();
        from.addGroup(g);
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("c4"));
        query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        setQuery = new SetQuery(SetQuery.Operation.UNION, false, (QueryCommand)setQuery, (QueryCommand)query);
        TestParser.helpTest("select c1 from g1 union select c2 from g2 union all select c3 from g3 union select c4 from g4", "SELECT c1 FROM g1 UNION SELECT c2 FROM g2 UNION ALL SELECT c3 FROM g3 UNION SELECT c4 FROM g4", (Command)setQuery);
    }

    public void testUnionWithLimit() {
        SetQuery setQuery = this.exampleSetQuery(SetQuery.Operation.UNION);
        setQuery.setLimit(new Limit(null, (Expression)new Constant((Object)1)));
        TestParser.helpTest("SELECT a FROM g UNION select b from h LIMIT 1", "SELECT a FROM g UNION SELECT b FROM h LIMIT 1", (Command)setQuery);
    }
}

