/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.query.processor.BatchedUpdatePlan;
import org.teiid.query.processor.FakeProcessorPlan;

public class TestBatchedUpdatePlan
extends TestCase {
    public TestBatchedUpdatePlan(String name) {
        super(name);
    }

    private void helpTestNextBatch(int[] commandsPerPlan) throws Exception {
        ArrayList<FakeProcessorPlan> plans = new ArrayList<FakeProcessorPlan>(commandsPerPlan.length);
        int totalCommands = 0;
        for (int i = 0; i < commandsPerPlan.length; ++i) {
            totalCommands += commandsPerPlan[i];
            plans.add(new FakeProcessorPlan(commandsPerPlan[i]));
        }
        BatchedUpdatePlan plan = new BatchedUpdatePlan(plans, totalCommands, null);
        TupleBatch batch = plan.nextBatch();
        TestBatchedUpdatePlan.assertEquals((int)totalCommands, (int)batch.getRowCount());
        for (int i = 1; i <= totalCommands; ++i) {
            TestBatchedUpdatePlan.assertEquals((Object)new Integer(1), batch.getTuple(i).get(0));
        }
    }

    public void testOpen() throws Exception {
        FakeProcessorPlan[] plans = new FakeProcessorPlan[4];
        for (int i = 0; i < plans.length; ++i) {
            plans[i] = new FakeProcessorPlan(1);
        }
        BatchedUpdatePlan plan = new BatchedUpdatePlan(Arrays.asList(plans), plans.length, null);
        plan.open();
        for (int i = 1; i < plans.length; ++i) {
            TestBatchedUpdatePlan.assertFalse((boolean)plans[i].isOpened());
        }
    }

    public void testNextBatch1() throws Exception {
        this.helpTestNextBatch(new int[]{1, 5, 2, 1, 10, 1, 1});
    }

    public void testNextBatch2() throws Exception {
        this.helpTestNextBatch(new int[]{5, 4, 10, 7, 22, 9, 12, 8, 11});
    }

    public void testNextBatch3() throws Exception {
        this.helpTestNextBatch(new int[]{1, 1, 1, 1});
    }
}

