/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestDependentJoins {
    static ProcessorPlan helpGetPlan(String sql) {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(2));
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        return plan;
    }

    @Test
    public void testMultiCritDepJoin1() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e1=pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin2() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestDependentJoins.helpGetPlan(sql);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin3() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin4() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm2.g1.e1=pm1.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin5() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE concat(pm1.g1.e1, 'a') = concat(pm2.g1.e1, 'a') AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin5a() {
        String sql = "SELECT X.e1 FROM pm1.g1 as X, pm2.g1 WHERE concat(X.e1, 'a') = concat(pm2.g1.e1, 'a') AND X.e2=pm2.g1.e2 order by x.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin5b() {
        String sql = "SELECT X.e1, X.e2 FROM pm1.g1 as X, pm2.g1 WHERE concat(X.e1, convert(X.e4, string)) = concat(pm2.g1.e1, convert(pm2.g1.e4, string)) AND X.e2=pm2.g1.e2 order by x.e1, x.e2 option makedep x";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(3)), Arrays.asList("b", new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin6() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e1 = concat(pm2.g1.e1, '') AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin7() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE concat(pm1.g1.e1, '') = pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin8() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e1 = pm2.g1.e1 AND pm1.g1.e2 <> pm2.g1.e2 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestDependentJoins.helpGetPlan(sql);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin9() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e2 <> pm2.g1.e2 option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("c"), Arrays.asList("c"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("b"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMultiCritDepJoin10() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e3=pm2.g1.e3 AND pm1.g1.e2=pm2.g1.e2 AND pm2.g1.e1 = 'a' option makedep pm1.g1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testLargeSetInDepJoinWAccessPatternCausingSortNodeInsertCanHandleAlias() {
        this.helpTestDepAccessCausingSortNodeInsert(true);
    }

    @Test
    public void testLargeSetInDepJoinWAccessPatternCausingSortNodeInsertCannotHandleAlias() {
        this.helpTestDepAccessCausingSortNodeInsert(false);
    }

    public void helpTestDepAccessCausingSortNodeInsert(boolean accessNodeHandlesAliases) {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm4.g1 a INNER JOIN pm1.g1 b ON a.e2=b.e2 AND a.e1 = b.e1 OPTION MAKEDEP a";
        List[] expected = new List[]{Arrays.asList("aa ", "aa ", new Integer(0)), Arrays.asList("bb   ", "bb   ", new Integer(1)), Arrays.asList("cc  ", "cc  ", new Integer(2))};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        if (accessNodeHandlesAliases) {
            depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        }
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm4", (SourceCapabilities)depcaps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)capFinder);
        Assert.assertTrue((boolean)(plan instanceof RelationalPlan));
        RelationalPlan relationalPlan = (RelationalPlan)plan;
        RelationalNode project = relationalPlan.getRootNode();
        RelationalNode join = project.getChildren()[0];
        Assert.assertTrue((String)("Expected instance of JoinNode (for dep join) but got " + join.getClass()), (boolean)(join instanceof JoinNode));
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)fakeMetadata);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase5130() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        String sql = "select a.intkey from bqt1.smalla a, bqt1.smallb b where concat(a.stringkey, 't') = b.stringkey option makedep a";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT a.stringkey, a.intkey FROM bqt1.smalla AS a", "SELECT b.stringkey FROM bqt1.smallb AS b"}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.stringkey FROM bqt1.smallb AS g_0", new List[]{Arrays.asList("1t"), Arrays.asList("2")});
        dataManager.addData("SELECT g_0.stringkey, g_0.intkey FROM bqt1.smalla AS g_0", new List[]{Arrays.asList("1", new Integer(1))});
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        TestProcessor.helpProcess(plan, dataManager, expected);
        Assert.assertFalse((boolean)dataManager.getCommandHistory().contains("SELECT a.stringkey, a.intkey FROM bqt1.smalla AS a WHERE concat(a.stringkey, 't') IN ('1', '2')"));
    }

    @Test
    public void testCase5130a() throws Exception {
        HardcodedDataManager dataManager = this.helpTestDependentJoin(false);
        Assert.assertFalse((boolean)dataManager.getCommandHistory().contains("SELECT a.stringkey, a.intkey FROM bqt2.smalla AS a WHERE (concat(a.stringkey, 't') IN ('1t', '2')) AND (a.intkey IN (1))"));
    }

    @Test
    public void testUnlimitedIn() throws Exception {
        this.helpTestDependentJoin(true);
    }

    private HardcodedDataManager helpTestDependentJoin(boolean unlimitIn) throws TeiidComponentException, TeiidProcessingException {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, false);
        if (unlimitIn) {
            caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)-1);
        }
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        String sql = "select a.intkey from bqt1.smalla a, bqt2.smallb b where concat(a.stringkey, 't') = b.stringkey and a.intkey = b.intkey option makedep a";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.stringkey, g_0.intkey FROM bqt1.smalla AS g_0 WHERE g_0.intkey IN (<dependent values>)", "SELECT g_0.stringkey, g_0.intkey FROM bqt2.smallb AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 2, 1, 0, 0});
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.stringkey, g_0.intkey FROM bqt2.smallb AS g_0", new List[]{Arrays.asList("1t", new Integer(1)), Arrays.asList("2t", new Integer(2))});
        dataManager.addData("SELECT g_0.stringkey, g_0.intkey FROM bqt1.smalla AS g_0 WHERE g_0.intkey IN (1, 2)", new List[]{Arrays.asList("1", new Integer(1))});
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        TestProcessor.helpProcess(plan, dataManager, expected);
        return dataManager;
    }

    static void sampleData4(FakeDataManager dataMgr) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm1.g1", new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("b", new Integer(1), Boolean.TRUE, null), Arrays.asList("c", new Integer(2), Boolean.FALSE, new Double(0.0))});
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm6.g1", new List[]{Arrays.asList("b", new Integer(0)), Arrays.asList("d", new Integer(3)), Arrays.asList("e", new Integer(1))});
    }

    @Test
    public void testLargeSetInDepAccess() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm6.g1 WHERE pm1.g1.e1=pm6.g1.e1 OPTION MAKEDEP pm6.g1";
        FakeDataManager dataManager = new FakeDataManager();
        TestDependentJoins.sampleData4(dataManager);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm6", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList(new String("b"))};
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteria() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, -1, 1, 2);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaConcurrent() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, -1, 4, 4);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaCompound() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, 4, 3, 3);
    }

    @Test
    public void testLargeSetInDepAccessMultiJoinCriteriaCompoundAll() throws Exception {
        this.helpTestLargeSetInDepAccessMultiJoinCriteria(1, 10, 2, 2);
    }

    @Test
    public void testLargeSetMultipleDependentSources() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm2.g1 makedep, /*+ makeind */ pm1.g2 where pm1.g1.e1=pm2.g1.e1 AND pm1.g2.e2=pm2.g1.e2 order by e1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)1);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)3);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a")};
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT pm1.g2.e2 FROM pm1.g2", "SELECT pm2.g1.e1, pm2.g1.e2 FROM pm2.g1 WHERE (pm2.g1.e1 IN (<dependent values>)) AND (pm2.g1.e2 IN (<dependent values>))", "SELECT pm1.g1.e1 FROM pm1.g1"}, plan);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList("a")});
        dataManager.addData("SELECT pm1.g2.e2 FROM pm1.g2", new List[]{Arrays.asList(1), Arrays.asList(2), Arrays.asList(3)});
        dataManager.addData("SELECT pm2.g1.e1, pm2.g1.e2 FROM pm2.g1 WHERE (pm2.g1.e1 = 'a') AND ((pm2.g1.e2 = 1) OR (pm2.g1.e2 = 2))", new List[]{Arrays.asList("a", 1)});
        dataManager.addData("SELECT pm2.g1.e1, pm2.g1.e2 FROM pm2.g1 WHERE (pm2.g1.e1 = 'a') AND (pm2.g1.e2 = 3)", new List[]{Arrays.asList("a", 3)});
        CommandContext cc = TestProcessor.createCommandContext();
        TestProcessor.helpProcess(plan, cc, dataManager, expected);
    }

    public void helpTestLargeSetInDepAccessMultiJoinCriteria(int maxInSize, int maxPredicates, int maxConcurrency, int concurrentOpen) throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM (pm1.g2 cross join pm1.g1) inner join pm2.g1 makedep ON pm1.g1.e1=pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 AND pm1.g2.e4 = pm2.g1.e4 order by e1";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)maxInSize);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, (Object)maxPredicates);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b")};
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT pm1.g2.e4 FROM pm1.g2", "SELECT pm2.g1.e1, pm2.g1.e2, pm2.g1.e4 FROM pm2.g1 WHERE (pm2.g1.e1 IN (<dependent values>)) AND (pm2.g1.e2 IN (<dependent values>)) AND (pm2.g1.e4 IN (<dependent values>))", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1"}, plan);
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setUserRequestSourceConcurrency(maxConcurrency);
        FakeTupleSource.resetStats();
        TestProcessor.helpProcess(plan, cc, dataManager, expected);
        Assert.assertEquals((String)"Wrong number of concurrent source queries", (long)concurrentOpen, (long)FakeTupleSource.maxOpen);
    }

    @Test
    public void testLargeSetInDepAccessWithAccessPattern() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm4.g1 a INNER JOIN pm1.g1 b ON a.e1=b.e1 AND a.e2 = b.e2";
        List[] expected = new List[]{Arrays.asList("aa ", "aa ", new Integer(0)), Arrays.asList("bb   ", "bb   ", new Integer(1)), Arrays.asList("cc  ", "cc  ", new Integer(2))};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("pm4", (SourceCapabilities)depcaps);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)fakeMetadata, (CapabilitiesFinder)capFinder);
        Assert.assertTrue((boolean)(plan instanceof RelationalPlan));
        RelationalPlan relationalPlan = (RelationalPlan)plan;
        RelationalNode project = relationalPlan.getRootNode();
        RelationalNode join = project.getChildren()[0];
        Assert.assertTrue((String)("Expected instance of JoinNode (for dep join) but got " + join.getClass()), (boolean)(join instanceof JoinNode));
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)fakeMetadata);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDependentNoRows() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1 AND pm1.g1.e2 = -100 OPTION MAKEDEP pm1.g2";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testExpressionInDepJoin() {
        String sql = "SELECT pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 WHERE (pm1.g1.e2+1)=pm2.g1.e2 order by pm1.g1.e2, pm2.g1.e2 OPTION MAKEDEP pm2.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(2), new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDependentJoinBackoff() throws Exception {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1, pm6.g1 WHERE pm1.g1.e1=pm6.g1.e1";
        FakeDataManager dataManager = new FakeDataManager();
        TestDependentJoins.sampleData4(dataManager);
        TransformationMetadata fakeMetadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 1, (QueryMetadataInterface)fakeMetadata);
        RealMetadataFactory.setCardinality("pm6.g1", 1000, (QueryMetadataInterface)fakeMetadata);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities depcaps = new BasicSourceCapabilities();
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        depcaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        depcaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm6", (SourceCapabilities)depcaps);
        List[] expected = new List[]{Arrays.asList(new String("b"))};
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)fakeMetadata, new String[]{"SELECT pm6.g1.e1 FROM pm6.g1 WHERE pm6.g1.e1 IN (<dependent values>) ORDER BY pm6.g1.e1", "SELECT pm1.g1.e1 FROM pm1.g1"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestProcessor.helpProcess(plan, dataManager, expected);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("SELECT pm1.g1.e1 FROM pm1.g1", "SELECT pm6.g1.e1 FROM pm6.g1 ORDER BY pm6.g1.e1")), new HashSet<String>(dataManager.getQueries()));
    }

    @Test
    public void testDjHint() {
        String sql = "SELECT pm1.g1.e1 FROM pm1.g1 WHERE e1 IN /*+ DJ */ (select e1 from pm2.g1) order by pm1.g1.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testMakeIndHint() {
        String sql = "SELECT pm1.g1.e1 FROM /*+ MAKEIND */ pm1.g1, pm2.g1 WHERE pm1.g1.e1 = pm2.g1.e1 AND pm1.g1.e2=pm2.g1.e2 order by pm1.g1.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }
}

