/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.FakeFunctionMetadataSource;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestFunctionPushdown {
    @Test
    public void testMustPushdownOverMultipleSourcesWithoutSupport() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.FAILED_PLANNING);
    }

    @Test
    public void testMustPushdownOverMultipleSources() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("misc.namespace.func", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(1, "a")});
        dataManager.addData("SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(1), Arrays.asList(2)});
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList("a")});
    }

    @Test
    public void testMustPushdownOverMultipleSourcesWithView() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("misc.namespace.func", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from (select x.* from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2 order by e1 limit 10) as x";
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", "SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1, g_0.e1 AS c_2 FROM pm1.g1 AS g_0 ORDER BY c_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(1)});
        dataManager.addData("SELECT g_0.e2 AS c_0, func(g_0.e1) AS c_1, g_0.e1 AS c_2 FROM pm1.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(1, "aa", "a"), Arrays.asList(2, "bb", "b")});
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList("aa")});
    }

    @Test
    public void testMustPushdownOverMultipleSourcesWithViewDupRemoval() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource()));
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setFunctionSupport("misc.namespace.func", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "select func(x.e1) from (select distinct x.* from pm1.g1 as x, pm2.g1 as y where x.e2 = y.e2 order by e1 limit 10) as x";
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[0], TestOptimizer.ComparisonMode.FAILED_PLANNING);
    }
}

