/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ExecutorUtils;
import org.teiid.dqp.internal.process.QueryProcessorFactoryImpl;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.FakeFunctionMetadataSource;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.TestRuleRaiseNull;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.FakeDataStore;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;
import org.teiid.query.validator.Validator;
import org.teiid.query.validator.ValidatorReport;

public class TestProcessor {
    private static final List[] SP1RS = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList(null, new Integer(1)), Arrays.asList("a", new Integer(3)), Arrays.asList("c", new Integer(1)), Arrays.asList("b", new Integer(2)), Arrays.asList("a", new Integer(0))};
    private static final boolean DEBUG = false;

    static Command helpParse(String sql) {
        try {
            return QueryParser.getQueryParser().parseCommand(sql);
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public static ProcessorPlan helpGetPlan(String sql, QueryMetadataInterface metadata) {
        return TestProcessor.helpGetPlan(sql, metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder());
    }

    public static ProcessorPlan helpGetPlan(String sql, QueryMetadataInterface metadata, CapabilitiesFinder finder) {
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan process = TestProcessor.helpGetPlan(command, metadata, finder);
        return process;
    }

    static ProcessorPlan helpGetPlan(Command command, QueryMetadataInterface metadata) {
        return TestProcessor.helpGetPlan(command, metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder());
    }

    static ProcessorPlan helpGetPlan(Command command, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) {
        CommandContext context = TestProcessor.createCommandContext();
        try {
            return TestProcessor.helpGetPlan(command, metadata, capFinder, context);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProcessorPlan helpGetPlan(Command command, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws TeiidException {
        AnalysisRecord analysisRecord = new AnalysisRecord(false, false);
        if (!(metadata instanceof TempMetadataAdapter)) {
            metadata = new TempMetadataAdapter(metadata, new TempMetadataStore());
        }
        context.setMetadata(metadata);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        ValidatorReport repo = Validator.validate((LanguageObject)command, (QueryMetadataInterface)metadata);
        ArrayList failures = new ArrayList();
        repo.collectInvalidObjects(failures);
        if (failures.size() > 0) {
            Assert.fail((String)("Exception during validation (" + repo));
        }
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)metadata, (CommandContext)context);
        ProcessorPlan process = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, (CommandContext)context);
        process = process.clone();
        Assert.assertNotNull((String)"Output elements of process plan are null", (Object)process.getOutputElements());
        ProcessorPlan processorPlan = process;
        return processorPlan;
    }

    public static void helpProcess(ProcessorPlan plan, ProcessorDataManager dataManager, List[] expectedResults) {
        CommandContext context = TestProcessor.createCommandContext();
        try {
            TestProcessor.helpProcess(plan, context, dataManager, expectedResults);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void helpProcess(ProcessorPlan plan, CommandContext context, ProcessorDataManager dataManager, List[] expectedResults) throws Exception {
        ProcessorPlan clonePlan = plan.clone();
        TestProcessor.doProcess(plan, dataManager, expectedResults, context);
        plan.reset();
        TestProcessor.doProcess(plan, dataManager, expectedResults, context);
        TestProcessor.doProcess(clonePlan, dataManager, expectedResults, context);
    }

    private void helpProcessException(ProcessorPlan plan, ProcessorDataManager dataManager) {
        this.helpProcessException(plan, dataManager, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpProcessException(ProcessorPlan plan, ProcessorDataManager dataManager, String expectedErrorMessage) {
        TupleBuffer tsId = null;
        BufferManager bufferMgr = null;
        try {
            bufferMgr = BufferManagerFactory.getStandaloneBufferManager();
            CommandContext context = new CommandContext((Object)"0", "test", null, null, 1);
            QueryProcessor processor = new QueryProcessor(plan, context, bufferMgr, dataManager);
            processor.setNonBlocking(true);
            BatchCollector collector = processor.createBatchCollector();
            tsId = collector.collectTuples();
            Assert.fail((String)"Expected error during processing, but got none.");
        }
        catch (TeiidException e) {
            if (expectedErrorMessage != null) {
                Assert.assertEquals((Object)expectedErrorMessage, (Object)e.getMessage());
            }
        }
        finally {
            if (tsId != null) {
                tsId.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProcess(ProcessorPlan plan, ProcessorDataManager dataManager, List[] expectedResults, CommandContext context) throws Exception {
        BufferManager bufferMgr = context.getBufferManager();
        if (bufferMgr == null) {
            BufferManagerImpl bm = BufferManagerFactory.createBufferManager();
            bm.setProcessorBatchSize(context.getProcessorBatchSize());
            bm.setConnectorBatchSize(context.getProcessorBatchSize());
            context.setBufferManager((BufferManager)bm);
            bufferMgr = bm;
        }
        context.getNextRand(0L);
        if (context.getTempTableStore() == null) {
            context.setTempTableStore(new TempTableStore(context.getConnectionID(), TempTableStore.TransactionMode.ISOLATE_WRITES));
        }
        if (context.getGlobalTableStore() == null) {
            GlobalTableStoreImpl gts = new GlobalTableStoreImpl(bufferMgr, context.getMetadata());
            context.setGlobalTableStore((GlobalTableStore)gts);
        }
        if (!(dataManager instanceof TempTableDataManager)) {
            SessionAwareCache cache = new SessionAwareCache();
            cache.setBufferManager(bufferMgr);
            dataManager = new TempTableDataManager(dataManager, bufferMgr, ExecutorUtils.getDirectExecutor(), cache);
        }
        if (context.getQueryProcessorFactory() == null) {
            context.setQueryProcessorFactory((QueryProcessor.ProcessorFactory)new QueryProcessorFactoryImpl(bufferMgr, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), null, context.getMetadata()));
        }
        TupleBuffer id = null;
        try {
            QueryProcessor processor = new QueryProcessor(plan, context, bufferMgr, dataManager);
            BatchCollector collector = processor.createBatchCollector();
            for (int i = 0; i < 100; ++i) {
                try {
                    id = collector.collectTuples();
                    break;
                }
                catch (BlockedException e) {
                    continue;
                }
            }
            if (id == null) {
                Assert.fail((String)"did not complete processing");
            }
            if (expectedResults != null) {
                TestProcessor.examineResults(expectedResults, bufferMgr, id);
            }
        }
        finally {
            if (id != null) {
                id.remove();
            }
        }
    }

    static void examineResults(List[] expectedResults, BufferManager bufferMgr, TupleBuffer tsID) throws TeiidComponentException, SQLException, TeiidProcessingException {
        IndexedTupleSource ts = tsID.createIndexedTupleSource();
        int count = tsID.getRowCount();
        Assert.assertEquals((String)"Did not get expected row count: ", (long)expectedResults.length, (long)count);
        for (int i = 0; i < count; ++i) {
            List record = ts.nextTuple();
            if (record.size() == 1 && expectedResults[i].size() == 1) {
                Object cellValue = record.get(0);
                if (cellValue instanceof XMLType) {
                    XMLType id = (XMLType)cellValue;
                    String actualDoc = id.getString();
                    if (expectedResults[i].size() == 1) {
                        TestProcessor.compareDocuments((String)expectedResults[i].get(0), actualDoc);
                        continue;
                    }
                } else if (cellValue instanceof Object[]) {
                    Assert.assertArrayEquals((Object[])((Object[])expectedResults[i].get(0)), (Object[])((Object[])cellValue));
                    continue;
                }
            }
            Assert.assertEquals((String)("Row " + i + " does not match expected: "), (Object)expectedResults[i], (Object)record);
        }
        ts.closeSource();
    }

    public static void compareDocuments(String expectedDoc, String actualDoc) {
        StringTokenizer tokens1 = new StringTokenizer(expectedDoc, "\r\n");
        StringTokenizer tokens2 = new StringTokenizer(actualDoc, "\r\n");
        while (tokens1.hasMoreTokens()) {
            String token1 = tokens1.nextToken().trim();
            if (!tokens2.hasMoreTokens()) {
                Assert.fail((String)("XML doc mismatch: expected=" + token1 + "\nactual=none"));
            }
            String token2 = tokens2.nextToken().trim();
            Assert.assertEquals((String)"XML doc mismatch: ", (Object)token1, (Object)token2);
        }
        if (tokens2.hasMoreTokens()) {
            Assert.fail((String)("XML doc mismatch: expected=none\nactual=" + tokens2.nextToken().trim()));
        }
    }

    public static CommandContext createCommandContext() {
        Properties props = new Properties();
        props.setProperty("soap_host", "my.host.com");
        props.setProperty("soap_port", "12345");
        CommandContext context = new CommandContext((Object)"0", "test", "user", null, "myvdb", 1, props, false);
        context.setProcessorBatchSize(256);
        context.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        context.setPreparedPlanCache(new SessionAwareCache());
        return context;
    }

    public static void sampleData1(FakeDataManager dataMgr) {
        try {
            FakeDataStore.sampleData1(dataMgr, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleData2(FakeDataManager dataMgr) {
        try {
            FakeDataStore.sampleData2(dataMgr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleData2a(FakeDataManager dataMgr) {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        try {
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm1.g1", new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("b", new Integer(1), Boolean.TRUE, null), Arrays.asList("c", new Integer(2), Boolean.FALSE, new Double(0.0))});
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm2.g1", new List[]{Arrays.asList("b", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("b", new Integer(7), Boolean.FALSE, new Double(2.0)), Arrays.asList("d", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("e", new Integer(1), Boolean.TRUE, null)});
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "pm4.g1", new List[]{Arrays.asList("aa", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("bb", new Integer(1), Boolean.TRUE, null), Arrays.asList("cc", new Integer(2), Boolean.FALSE, new Double(0.0))});
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sampleData2b(FakeDataManager dataMgr, QueryMetadataInterface metadata) {
        try {
            dataMgr.registerTuples(metadata, "pm1.g1", new List[]{Arrays.asList("aa ", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("bb   ", new Integer(1), Boolean.TRUE, null), Arrays.asList("cc  ", new Integer(2), Boolean.FALSE, new Double(0.0))});
            dataMgr.registerTuples(metadata, "pm2.g1", new List[]{Arrays.asList("b", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("d", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("e", new Integer(1), Boolean.TRUE, null)});
            dataMgr.registerTuples(metadata, "pm4.g1", new List[]{Arrays.asList("aa ", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("bb   ", new Integer(1), Boolean.TRUE, null), Arrays.asList("cc  ", new Integer(2), Boolean.FALSE, new Double(0.0))});
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleDataBQT1(FakeDataManager dataMgr) {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        try {
            int j;
            int i;
            List[] tuples = new List[20];
            for (i = 0; i < tuples.length; ++i) {
                tuples[i] = new ArrayList(17);
                tuples[i].add(new Integer(i));
                for (j = 0; j < 16; ++j) {
                    tuples[i].add(null);
                }
            }
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
            tuples = new List[20];
            for (i = 0; i < tuples.length; ++i) {
                tuples[i] = new ArrayList(17);
                tuples[i].add(new Integer(i));
                for (j = 0; j < 16; ++j) {
                    tuples[i].add(null);
                }
            }
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt2.mediumb", tuples);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleDataBQT2(FakeDataManager dataMgr) {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String[] groups = new String[]{"bqt1.smalla", "bqt2.smalla", "bqt3.smalla"};
        try {
            for (int i = 0; i < groups.length; ++i) {
                String groupName = groups[i];
                List[] tuples = new List[30];
                for (int row = 0; row < tuples.length; ++row) {
                    tuples[row] = new ArrayList(17);
                    tuples[row].add(new Integer(row));
                    for (int col = 0; col < 16; ++col) {
                        tuples[row].add(null);
                    }
                }
                dataMgr.registerTuples((QueryMetadataInterface)metadata, groupName, tuples);
            }
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleDataBQT_defect11682(FakeDataManager dataMgr) {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        try {
            List[] tuples = new List[2];
            for (int i = 1; i <= tuples.length; ++i) {
                int index = i - 1;
                tuples[index] = new ArrayList(17);
                tuples[index].add(new Integer(i));
                tuples[index].add(null);
                tuples[index].add(new Integer(i));
                tuples[index].add(null);
                tuples[index].add(new Float(i));
                tuples[index].add(new Long(i));
                tuples[index].add(new Double(i));
                tuples[index].add(new Byte((byte)i));
                tuples[index].add(null);
                tuples[index].add(null);
                tuples[index].add(null);
                tuples[index].add(null);
                tuples[index].add(null);
                tuples[index].add(new Short((short)i));
                tuples[index].add(new BigInteger(i + ""));
                tuples[index].add(new BigDecimal(i + ".0"));
                tuples[index].add(null);
            }
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleDataBQTSmall(FakeDataManager dataMgr) {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        try {
            List[] tuples = new List[1];
            for (int i = 0; i < tuples.length; ++i) {
                tuples[i] = new ArrayList(17);
                tuples[i].add(new Integer(i));
                for (int j = 0; j < 16; ++j) {
                    tuples[i].add(null);
                }
            }
            dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", tuples);
        }
        catch (TeiidException e) {
            throw new RuntimeException(e);
        }
    }

    private List createRowWithTimestamp(String tsStr) {
        Timestamp ts = Timestamp.valueOf(tsStr);
        return Arrays.asList(new Integer(0), "a", new Integer(1), "a", null, null, null, null, null, null, ts, null, null, null, null, null, null);
    }

    private void sampleDataBQT_case1566(FakeDataManager dataMgr) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        dataMgr.registerTuples((QueryMetadataInterface)metadata, "bqt1.smalla", new List[]{this.createRowWithTimestamp("2002-01-01 10:00:00"), this.createRowWithTimestamp("2002-01-01 14:00:00"), this.createRowWithTimestamp("2002-01-02 10:00:00"), this.createRowWithTimestamp("2002-01-02 14:00:00"), this.createRowWithTimestamp("2002-01-02 19:00:00.01")});
    }

    static List getProcResultSetSymbols(List params) {
        ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>();
        for (SPParameter param : params) {
            if (param.getResultSetColumns() == null) continue;
            result.addAll(param.getResultSetColumns());
        }
        for (SPParameter param : params) {
            if (param.getParameterType() != 3 && param.getParameterType() != 4) continue;
            result.add(param.getParameterSymbol());
        }
        return result;
    }

    @Test
    public void test1() {
        String sql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test2() {
        String sql = "SELECT COUNT(*) FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(6))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test3() {
        String sql = "SELECT COUNT(*), COUNT(e1), COUNT(distinct e1), COUNT(distinct e2), COUNT(distinct e3), COUNT(distinct e4) FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(6), new Integer(5), new Integer(3), new Integer(4), new Integer(2), new Integer(4))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test4() {
        String sql = "SELECT MIN(e2), MAX(e2), SUM(e2), AVG(e2), SUM(distinct e2), AVG(distinct e2) FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(0), new Integer(3), new Long(7L), new Double(1.1666666666666667), new Long(6L), new Double(1.5))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test5() {
        String sql = "SELECT MIN(e4), MAX(e4), SUM(e4), AVG(e4), SUM(distinct e4), AVG(distinct e4) FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Double(0.0), new Double(7.0), new Double(12.0), new Double(2.4), new Double(10.0), new Double(2.5))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test7() {
        String sql = "SELECT * FROM vm1.g1";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test8() {
        String sql = "SELECT * FROM vm1.g2 order by 1, 2, 3";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(0), Boolean.TRUE, new Double(7.0)), Arrays.asList("a", new Integer(0), Boolean.TRUE, new Double(7.0)), Arrays.asList("a", new Integer(3), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(3), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test9() {
        String sql = "SELECT * FROM vm1.g4 order by e1";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("0"), Arrays.asList("0"), Arrays.asList("1"), Arrays.asList("1"), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void test10() {
        String sql = "SELECT e1 FROM vm1.g4 where e1 = 'a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBooleanComparisonGT() {
        String sql = "SELECT pm1.g1.e3 FROM pm1.g1 WHERE e3 > {b'false'}";
        List[] expected = new List[]{Arrays.asList(Boolean.TRUE), Arrays.asList(Boolean.TRUE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBooleanComparisonGE() {
        String sql = "SELECT pm1.g1.e3 FROM pm1.g1 WHERE e3 >= {b'false'}";
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.TRUE), Arrays.asList(Boolean.TRUE), Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBooleanComparisonLT() {
        String sql = "SELECT pm1.g1.e3 FROM pm1.g1 WHERE e3 < {b'true'}";
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBooleanComparisonLE() {
        String sql = "SELECT pm1.g1.e3 FROM pm1.g1 WHERE e3 <= {b'true'}";
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.TRUE), Arrays.asList(Boolean.TRUE), Arrays.asList(Boolean.FALSE), Arrays.asList(Boolean.FALSE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testConcatOperator() {
        String sql = "SELECT pm1.g1.e1 || e2 AS x FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList("a0"), Arrays.asList(new Object[]{null}), Arrays.asList("a3"), Arrays.asList("c1"), Arrays.asList("b2"), Arrays.asList("a0")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect4841_1() {
        String sql = "SELECT e1 a, e1 b FROM pm1.g1 order by a";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect4841_2() {
        String sql = "SELECT e1 a, e1 b FROM pm1.g1 order by a";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5292_1() {
        String sql = "SELECT DISTINCT e1, e1 a FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5292_2() {
        String sql = "SELECT DISTINCT e1, e1 a FROM pm1.g1 ORDER BY a";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5004() {
        String sql = "SELECT COUNT(*) FROM pm1.g1 WHERE e1='xxxx'";
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5004a() throws Exception {
        String sql = "SELECT COUNT(*) FROM pm1.g1 WHERE e1='xxxx'";
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        CommandContext context = TestProcessor.createCommandContext();
        context.setProcessorBatchSize(2);
        context.setMetadata((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), context);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void test13() {
        String sql = "SELECT COUNT(e2), MIN(e2), MAX(e2), SUM(e2), AVG(e2) FROM pm1.g1 WHERE e2=-999999";
        List[] expected = new List[]{Arrays.asList(new Integer(0), null, null, null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCriteriaAliasedGroup() {
        String sql = "select e1, e2 FROM pm2.g1 Y WHERE 2.0 = e4";
        List[] expected = new List[]{Arrays.asList("b", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCriteriaComparesUnequalConstants() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE 'abc' = 'xyz'";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testRightOuterJoin1() {
        String sql = "SELECT pm1.g1.e1, pm2.g1.e1 FROM pm1.g1 RIGHT OUTER JOIN pm2.g1 ON pm1.g1.e1=pm2.g1.e1";
        List[] expected = new List[]{Arrays.asList("b", "b"), Arrays.asList(null, "d"), Arrays.asList(null, "e")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testLeftOuterJoin1() {
        String sql = "SELECT pm1.g1.e1, pm2.g1.e1 FROM pm1.g1 LEFT OUTER JOIN pm2.g1 ON pm1.g1.e1=pm2.g1.e1";
        List[] expected = new List[]{Arrays.asList("a", null), Arrays.asList("b", "b"), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testFullOuterJoin1() throws Exception {
        String sql = "SELECT pm1.g1.e1, pm2.g1.e1 FROM pm1.g1 FULL OUTER JOIN pm2.g1 ON pm1.g1.e1=pm2.g1.e1";
        List[] expected = new List[]{Arrays.asList("a", null), Arrays.asList("b", "b"), Arrays.asList("c", null), Arrays.asList(null, "d"), Arrays.asList(null, "e")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testFullOuterJoin2() throws Exception {
        String sql = "SELECT a.e4 c0, b.e4 c1 FROM pm1.g1 a FULL OUTER JOIN pm1.g1 b ON a.e4=b.e4 order by c0";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(new Double(0.0), new Double(0.0)), Arrays.asList(new Double(2.0), new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSortedFullOuterJoin() throws Exception {
        String sql = "SELECT pm1.g1.e2, pm2.g1.e2 FROM pm1.g1 FULL OUTER JOIN pm2.g1 ON pm1.g1.e2=pm2.g1.e2 and pm1.g1.e2 > 3";
        List[] expected = new List[]{Arrays.asList(null, 2), Arrays.asList(3, null), Arrays.asList(null, 3), Arrays.asList(null, 4)};
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e2 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(3)});
        hdm.addData("SELECT g_0.e2 AS c_0 FROM pm2.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(2), Arrays.asList(3), Arrays.asList(4)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setProcessorBatchSize(2);
        TestProcessor.helpProcess(plan, cc, hdm, expected);
    }

    @Test
    public void testFullOuterJoin3() throws Exception {
        String sql = "SELECT a.e4 c0, b.e4 c1 FROM pm1.g1 b FULL OUTER JOIN (select e4, 1 x from pm1.g1 union all select e4, 2 from pm1.g1) a ON a.e4=b.e4 and a.x = 2 order by c0";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(new Double(0.0), new Double(0.0)), Arrays.asList(new Double(0.0), null), Arrays.asList(new Double(2.0), new Double(2.0)), Arrays.asList(new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testLeftOuterJoinWithInlineView() {
        String sql = "SELECT x.e1, pm2.g1.e1 FROM (SELECT e1 FROM pm1.g1) AS x LEFT OUTER JOIN pm2.g1 ON x.e1=pm2.g1.e1";
        List[] expected = new List[]{Arrays.asList("a", null), Arrays.asList("b", "b"), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5273_1() {
        String sql = "SELECT expr FROM vm1.g5 ORDER BY expr";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("bval"), Arrays.asList("cval")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5273_2() {
        String sql = "SELECT expr AS e FROM vm1.g5 ORDER BY e";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("bval"), Arrays.asList("cval")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5273_3() {
        String sql = "SELECT e2 AS e FROM vm1.g5 ORDER BY e";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5273_4() {
        String sql = "SELECT e AS f FROM vm1.g6 ORDER BY f";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("bval"), Arrays.asList("cval")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5273_5() {
        String sql = "SELECT e AS f FROM vm1.g7 ORDER BY f";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("a0"), Arrays.asList("a0"), Arrays.asList("a3"), Arrays.asList("b2"), Arrays.asList("c1")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect5273_6() {
        String sql = "SELECT e AS f FROM vm1.g8 ORDER BY f";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("aval"), Arrays.asList("bval"), Arrays.asList("cval")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testFalseCriteria1() {
        String sql = "SELECT 5 FROM pm1.g1 WHERE 0=1";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testFalseCriteria2() {
        String sql = "SELECT count(*) FROM pm1.g1 WHERE 0=1";
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubquery1() {
        String sql = "SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubquerySimple() {
        String sql = "SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCritInSubquery() {
        String sql = "SELECT e1 FROM (SELECT e1 FROM pm1.g1 WHERE e1 = 'a') AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCritAboveSubquery() {
        String sql = "SELECT e1 FROM (SELECT e1 FROM pm1.g1) AS x WHERE e1 = 'a'";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryInJoinPredicate() {
        String sql = "SELECT x.e1 FROM (SELECT e1 FROM pm1.g1) AS x JOIN (SELECT e1 FROM pm1.g1) y ON x.e1=y.e1 order by x.e1";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryWithRenaming() {
        String sql = "SELECT x.a FROM (SELECT e1 AS a FROM pm1.g1) AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNestedSubquery() {
        String sql = "SELECT x.a FROM (SELECT e1 AS a FROM (SELECT e1 FROM pm1.g1) AS y) AS x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryINClause() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryINClauseWithNulls() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e4 IN (SELECT e4 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryINClauseWithNulls2() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e4 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryINClauses() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1) AND e1 IN (SELECT e1 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryINClauseMixedCriteria() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1) AND e1 IN ('b')";
        List[] expected = new List[]{Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryINClauseMixedCriteria2() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1) AND NOT (e1 = 'a')";
        List[] expected = new List[]{Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNestedSubqueryINClauses() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1 WHERE e1 IN (SELECT e1 FROM pm1.g1))";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryXML() {
        String sql = "SELECT * FROM (SELECT * FROM xmltest.doc1) AS x";
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node1><node2><node3/></node2></node1></root>")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryExistsPredicate() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE EXISTS (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryExistsPredicate2() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE EXISTS (SELECT e2 FROM pm2.g1 WHERE e1 = 'ZZTop')";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 = ANY (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate2() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 = SOME (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate3() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 = ALL (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate4() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 <= ALL (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate5() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 < SOME (SELECT e2 FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate5a() {
        String sql = "SELECT e1 FROM pm2.g1 WHERE e2 < SOME (SELECT e2 FROM pm1.g1)";
        List[] expected = new List[]{Arrays.asList("b"), Arrays.asList("e")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicate6() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 < (SELECT e2 FROM pm2.g1 WHERE e1 = 'e')";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryComparePredicateNested() {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 < SOME (SELECT e2 FROM pm2.g1 WHERE EXISTS (SELECT e2 FROM pm2.g1))";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList(new Integer(0), "a"), Arrays.asList(new Integer(1), "b"), Arrays.asList(new Integer(2), "c")});
        dataManager.addData("SELECT pm2.g1.e2 FROM pm2.g1", new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(1))});
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryScalar() {
        String sql = "SELECT e1, (SELECT e2 FROM pm2.g1 WHERE e1 = 'b') FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", new Integer(0)), Arrays.asList("c", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryScalar2() {
        String sql = "SELECT e1, (SELECT e2 FROM pm2.g1 WHERE e1 = 'a') FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", null), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryScalarException() throws Exception {
        String sql = "SELECT e1, (SELECT e2 FROM pm2.g1) FROM pm1.g1";
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        this.helpProcessException(plan, dataManager);
    }

    @Test
    public void testSubqueryScalarInTransformation() {
        String sql = "select * from vm1.g25";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), new Double(0.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0), new Double(0.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), new Double(0.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null, new Double(0.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), new Double(0.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSubqueryScalarInTransformation2() {
        String sql = "select * from vm1.g25 where e5 = 0.0";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), new Double(0.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0), new Double(0.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), new Double(0.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null, new Double(0.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), new Double(0.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery_CASE2022() {
        String sql = "select * from BQT2_V WHERE BQT2_V.IntKey < 50";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT1(dataManager);
        this.sampleDataBQT2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery1() {
        String sql = "Select e1, e2, e4 from pm1.g1 where e2 in (select e2 FROM pm2.g1 WHERE pm1.g1.e4 = pm2.g1.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryCaching() throws Exception {
        String sql = "Select e1 from pm1.g1 where e2 in (select e2 FROM pm2.g1 WHERE pm1.g1.e3 = pm2.g1.e3)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new String[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.doProcess(plan, dataManager, expected, TestProcessor.createCommandContext());
        Assert.assertEquals((long)3L, (long)dataManager.getQueries().size());
    }

    @Test
    public void testCorrelatedSubqueryCase3667() {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        String sql = "Select e1, e2, e4 from pm2.g1 where 1=2 UNION ALL Select e1, e2, e4 from vm1.g1 outg1 where outg1.e2 in (select ing1.e2 FROM vm1.g1 ing1 WHERE outg1.e4 = ing1.e4)";
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList("aString", new Integer(22), new Double(22.0))};
        dataManager.addData("SELECT g_0.e1, g_0.e2, g_0.e4 FROM pm1.g1 AS g_0 WHERE g_0.e2 IN (SELECT g_1.e2 FROM pm1.g1 AS g_1 WHERE g_1.e4 = g_0.e4)", expected);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryCase3667a() {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "Select e1, e2, e4 from vm1.g1 outg1 where outg1.e2 in (select ing1.e2 FROM vm1.g1 ing1 WHERE outg1.e4 = ing1.e4)";
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList("aString", new Integer(22), new Double(22.0))};
        dataManager.addData("SELECT g_0.e1, g_0.e2, g_0.e4 FROM pm1.g1 AS g_0 WHERE g_0.e2 IN (SELECT g_1.e2 FROM pm1.g1 AS g_1 WHERE g_1.e4 = g_0.e4)", expected);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery2() {
        String sql = "Select e1, e2 from pm1.g1 where e2 in (select e2 FROM pm2.g1 WHERE pm1.g1.e4 = pm2.g1.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery3() {
        String sql = "Select e1, (select e2 FROM pm2.g1 WHERE pm1.g1.e4 = pm2.g1.e4) from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery3a() {
        String sql = "Select e1, (select e2 FROM pm2.g1 WHERE X.e4 = e4) from pm1.g1 X";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery3b() {
        String sql = "Select e1, (select e2 FROM pm2.g1 Y WHERE X.e4 = e4) from pm1.g1 X";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery3c() {
        String sql = "Select e1, (select e2 FROM pm2.g1 Y WHERE X.e4 = Y.e4) from pm1.g1 X";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery4() {
        String sql = "Select e1, e2 from pm1.g1 X where e2 in (select e2 FROM pm2.g1 WHERE X.e4 = pm2.g1.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery4a() {
        String sql = "Select e1, e2 from pm1.g1 X where e2 = some (select e2 FROM pm2.g1 WHERE X.e4 = pm2.g1.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery_defect9968() {
        String sql = "Select e1, e2 from pm1.g1 X where e2 in (select max(X.e2) FROM pm2.g1 WHERE X.e4 = pm2.g1.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery_defect9968a() {
        String sql = "Select e1, e2 from pm1.g1 X where e2 in (select ((X.e2)/2) as e FROM pm2.g1 WHERE X.e4 = pm2.g1.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery_defect9968b() {
        String sql = "Select e1, e2 from pm1.g1 X where e2 in (select (select e2 as e FROM pm2.g1 WHERE X.e4 = pm2.g1.e4) as e FROM pm2.g1)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery_defect10021() {
        String sql = "Select e1, e2 from table1 X where e4 in (select max(Y.e4) FROM table1 Y WHERE X.e4 = Y.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("c", new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery5() {
        String sql = "Select * from pm1.g1 where exists (select * FROM pm2.g1 WHERE pm1.g1.e1 = e1)";
        List[] expected = new List[]{Arrays.asList("b", new Integer(1), Boolean.TRUE, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery6() {
        String sql = "Select count(*) from pm1.g1 where not (exists (select * FROM pm2.g1 WHERE pm1.g1.e1 = e1))";
        List[] expected = new List[]{Arrays.asList(new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery7() {
        String sql = "select e2, e4, (select avg(e4) FROM pm1.g1 Y WHERE X.e1 = e1) from pm1.g1 X";
        List[] expected = new List[]{Arrays.asList(new Integer(0), new Double(2.0), new Double(3.6666666666666665)), Arrays.asList(new Integer(1), new Double(1.0), null), Arrays.asList(new Integer(3), new Double(7.0), new Double(3.6666666666666665)), Arrays.asList(new Integer(1), null, null), Arrays.asList(new Integer(2), new Double(0.0), new Double(0.0)), Arrays.asList(new Integer(0), new Double(2.0), new Double(3.6666666666666665))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubquery8() {
        String sql = "select X.e2, X.e4, (select avg(Y.e4) FROM pm1.g1 Y WHERE X.e1 = Y.e1) from pm1.g1 X";
        List[] expected = new List[]{Arrays.asList(new Integer(0), new Double(2.0), new Double(3.6666666666666665)), Arrays.asList(new Integer(1), new Double(1.0), null), Arrays.asList(new Integer(3), new Double(7.0), new Double(3.6666666666666665)), Arrays.asList(new Integer(1), null, null), Arrays.asList(new Integer(2), new Double(0.0), new Double(0.0)), Arrays.asList(new Integer(0), new Double(2.0), new Double(3.6666666666666665))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer1() {
        String sql = "Select e1, e2 from vm1.g1 X where e2 in (select e2 FROM vm1.g1 Y WHERE X.e4 = Y.e4)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList(null, new Integer(1)), Arrays.asList("a", new Integer(3)), Arrays.asList("b", new Integer(2)), Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer2() {
        String sql = "Select e1, e2 from vm1.g2 where e2 in (select e2 FROM vm1.g1 WHERE vm1.g2.e4 = vm1.g1.e4) order by e1, e2";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(3)), Arrays.asList("b", new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer3() {
        String sql = "Select e2 from vm1.g6 where e2 in (select e2 FROM vm1.g1 WHERE vm1.g6.e = e1)";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer4() {
        String sql = "Select e2 from vm1.g7 where e2 in (select e2 FROM vm1.g1 WHERE vm1.g7.e = e1)";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer5() {
        String sql = "Select e1 from vm1.g4 where not (e1 in (select e1 FROM vm1.g1 WHERE vm1.g4.e1 = e1)) order by e1";
        List[] expected = new List[]{Arrays.asList("0"), Arrays.asList("0"), Arrays.asList("1"), Arrays.asList("1"), Arrays.asList("2"), Arrays.asList("3")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer6() {
        String sql = "Select e2 from vm1.g1 X where e2 in (select X.e2 FROM vm1.g1)";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer6a() {
        String sql = "Select e2 from vm1.g1 where e2 in (select vm1.g1.e2 FROM vm1.g5)";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer6b() {
        String sql = "Select e2 from vm1.g1 where e2 in (select vm1.g1.e2 FROM vm1.g2)";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer6c() {
        String sql = "Select e2 from vm1.g7 where e2 in (select vm1.g7.e FROM vm1.g1)";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer6e() {
        String sql = "Select e2 from vm1.g1 where e2 in (select vm1.g1.e2 FROM vm1.g2a)";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryVirtualLayer7() {
        String sql = "Select e2 from vm1.g7 where e2 in (select vm1.g7.e FROM vm1.g1 WHERE vm1.g7.e = e1)";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation() {
        String sql = "Select * from vm1.g21";
        List[] expected = new List[]{Arrays.asList("b", new Integer(1), Boolean.TRUE, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation2() {
        String sql = "Select * from vm1.g20";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation3() {
        String sql = "Select * from vm1.g19 order by e1";
        List[] expected = new List[]{Arrays.asList("0"), Arrays.asList("0"), Arrays.asList("1"), Arrays.asList("1"), Arrays.asList("2"), Arrays.asList("3")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation4() {
        String sql = "Select * from vm1.g20 where exists (Select * from vm1.g19 where convert(vm1.g20.e2, string) = vm1.g19.e1)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation5() {
        String sql = "Select * from vm1.g19 where exists (Select e2 from vm1.g20 where convert(e2, string) = vm1.g19.e1) order by e1";
        List[] expected = new List[]{Arrays.asList("0"), Arrays.asList("0"), Arrays.asList("1"), Arrays.asList("1"), Arrays.asList("2"), Arrays.asList("3")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation6() {
        String sql = "Select * from vm1.g21 where e2 = some (Select e2 from pm1.g1 where e1 = vm1.g21.e1)";
        List[] expected = new List[]{Arrays.asList("b", new Integer(1), Boolean.TRUE, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation7() {
        String sql = "Select * from vm1.g21 where exists (Select e2 from pm1.g2 where e4 = convert(vm1.g21.e2, double))";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation8() {
        String sql = "Select * from vm1.g21 where exists (Select e2 from pm1.g1 where e4 = convert(vm1.g21.e2, double))";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation9() {
        String sql = "Select * from vm1.g22";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), null), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation10() {
        String sql = "Select * from vm1.g23";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), null), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation11() {
        String sql = "Select * from vm1.g24";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation12() {
        String sql = "Select * from vm1.g24 X where exists (Select * from vm1.g24 Y where X.e2 = Y.e2)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation13() {
        String sql = "Select e1, e2, e3, e4, (select e4 from vm1.g25 where pm1.g1.e4 = e5 and e4=0.0) as e5 from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0), null), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), null), Arrays.asList("c", new Integer(1), Boolean.TRUE, null, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation14() {
        String sql = "Select e1, e2, e3, e4, (select e4 from vm1.g26 where pm1.g1.e4 = e5 and e4=0.0) as e5 from pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0), null), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), null), Arrays.asList("c", new Integer(1), Boolean.TRUE, null, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation15() {
        String sql = "Select e1, e2, e3, e4, (select e4 from vm1.g23 where vm1.g22.e4 = e5) as e5 from vm1.g22 where e1 = 'a'";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), new Double(7.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation15a() {
        String sql = "Select e1, e2, e3, e4 from pm1.g1 where exists (select * from vm1.g26 where pm1.g1.e3 = e3)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation15b() {
        String sql = "Select e1, e2, e3, e4, (select e4 from vm1.g23 where vm1.g22.e4 = e5) as e5 from vm1.g22 where e1 = 'a' and exists (select * from vm1.g23 where vm1.g22.e3 = e3)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0), new Double(7.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation15c() {
        String sql = "Select e1, e2, e3, e4 from pm1.g1 where exists (select e1, e2, e3, e4, e5 as e from vm1.g26 where pm1.g1.e3 = e3)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation15d() {
        String sql = "Select e1, e2, e3, e4 from pm1.g1 where exists (select e1, e2, e3, e4, ((e4 + e5)/(e4 + 1)) as e from vm1.g26 where pm1.g1.e3 = e3)";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryInTransformation16() {
        String sql = "select * from vm1.g26 where e5 = 0.0";
        List[] expected = new List[]{Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0), new Double(0.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueriesNested() {
        String sql = "Select e1, e2, e4 from pm1.g1 where e2 < all (select e2 from pm1.g2 where pm1.g1.e1 = e1 and exists(select e2 from pm2.g1 where pm1.g2.e4 = pm2.g1.e4))";
        Command query = TestProcessor.helpParse(sql);
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Double(2.0)), Arrays.asList("b", new Integer(1), null), Arrays.asList("c", new Integer(2), new Double(0.0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(query, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryAndInlineView() {
        String sql = "Select e1, (select e2 FROM pm2.g1 Y WHERE X.e4 = Y.e4) from (select * from pm1.g1) as X";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryAndInlineView2() {
        String sql = "Select e1 from (select * from pm1.g1) as X WHERE e2 IN (select e2 FROM pm2.g1 Y WHERE X.e4 = Y.e4)";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryAndInlineView3() {
        String sql = "Select e1, (select e2 FROM pm2.g1 Y WHERE X.e4 = Y.e4) from (select * from pm1.g1 UNION ALL select * from pm1.g1) as X";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null), Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedSubqueryAndInlineView4() {
        String sql = "Select e1, (select e2 FROM pm2.g1 Y WHERE X.e4 = Y.e4) from (select pm1.g1.e1, (select pm1.g1.e2 from pm1.g1 Z where pm1.g1.e1 = Z.e1), pm1.g1.e3, pm1.g1.e4 from pm1.g1) as X";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("b", null), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testXMLUnion_defect8373() {
        String sql = "SELECT * FROM xmltest.doc5";
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node1><node2>a</node2></node1><node1><node2/></node1><node1><node2>a</node2></node1><node1><node2>c</node2></node1><node1><node2>b</node2></node1><node1><node2>a</node2></node1><node1><node2>a</node2></node1><node1><node2/></node1><node1><node2>a</node2></node1><node1><node2>c</node2></node1><node1><node2>b</node2></node1><node1><node2>a</node2></node1></root>")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery1() {
        String sql = "EXEC pm1.sq1()";
        List[] expected = SP1RS;
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery2() {
        String sql = "EXEC pm1.sq2('a')";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(3)), Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery3() {
        String sql = "select x.e1 from (EXEC pm1.sq1()) as x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery4() {
        String sql = "EXEC pm1.sq5('a')";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(3)), Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery5() {
        String sql = "EXEC pm1.sp1()";
        List[] expected = SP1RS;
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", expected);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery6() {
        String sql = "EXEC pm1.sqsp1()";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", SP1RS);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery7() {
        String sql = "EXEC pm1.sq17()";
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><node1><node2><node3/></node2></node1></root>")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery8() {
        String sql = "EXEC pm1.sq5(5)";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery9() {
        String sql = "EXEC pm1.sq5(concat('a', ''))";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(3)), Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testStoredQuery10() {
        String sql = "EXEC pm1.sq3b(\"in\" = 'a', in3 = 'something')";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(3)), Arrays.asList("a", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInsert() {
        String sql = "Insert into pm1.g1 (pm1.g1.e1, pm1.g1.e2) values ('MyString', 1)";
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("INSERT INTO pm1.g1 (pm1.g1.e1, pm1.g1.e2) VALUES ('MyString', 1)", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect7770_FullOuter() {
        String sql = "SELECT BQT1.SmallA.IntKey AS SmallA_IntKey, BQT2.MediumB.IntKey AS MediumB_IntKey FROM BQT1.SmallA FULL OUTER JOIN BQT2.MediumB ON BQT1.SmallA.IntKey = BQT2.MediumB.IntKey WHERE (BQT1.SmallA.IntKey >= 0) AND (BQT1.SmallA.IntKey <= 15) AND (BQT2.MediumB.IntKey >= 5) AND (BQT2.MediumB.IntKey <= 20)";
        List[] expected = new List[]{Arrays.asList(new Integer(5), new Integer(5)), Arrays.asList(new Integer(6), new Integer(6)), Arrays.asList(new Integer(7), new Integer(7)), Arrays.asList(new Integer(8), new Integer(8)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(new Integer(11), new Integer(11)), Arrays.asList(new Integer(12), new Integer(12)), Arrays.asList(new Integer(13), new Integer(13)), Arrays.asList(new Integer(14), new Integer(14)), Arrays.asList(new Integer(15), new Integer(15))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect7770_RightOuter() {
        String sql = "SELECT BQT1.SmallA.IntKey AS SmallA_IntKey, BQT2.MediumB.IntKey AS MediumB_IntKey FROM BQT1.SmallA RIGHT OUTER JOIN BQT2.MediumB ON BQT1.SmallA.IntKey = BQT2.MediumB.IntKey WHERE (BQT1.SmallA.IntKey >= 0) AND (BQT1.SmallA.IntKey <= 15) AND (BQT2.MediumB.IntKey >= 5) AND (BQT2.MediumB.IntKey <= 20)";
        List[] expected = new List[]{Arrays.asList(new Integer(5), new Integer(5)), Arrays.asList(new Integer(6), new Integer(6)), Arrays.asList(new Integer(7), new Integer(7)), Arrays.asList(new Integer(8), new Integer(8)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(new Integer(11), new Integer(11)), Arrays.asList(new Integer(12), new Integer(12)), Arrays.asList(new Integer(13), new Integer(13)), Arrays.asList(new Integer(14), new Integer(14)), Arrays.asList(new Integer(15), new Integer(15))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect7770_LeftOuter() {
        String sql = "SELECT BQT1.SmallA.IntKey AS SmallA_IntKey, BQT2.MediumB.IntKey AS MediumB_IntKey FROM BQT1.SmallA LEFT OUTER JOIN BQT2.MediumB ON BQT1.SmallA.IntKey = BQT2.MediumB.IntKey WHERE (BQT1.SmallA.IntKey >= 0) AND (BQT1.SmallA.IntKey <= 15) AND (BQT2.MediumB.IntKey >= 5) AND (BQT2.MediumB.IntKey <= 20)";
        List[] expected = new List[]{Arrays.asList(new Integer(5), new Integer(5)), Arrays.asList(new Integer(6), new Integer(6)), Arrays.asList(new Integer(7), new Integer(7)), Arrays.asList(new Integer(8), new Integer(8)), Arrays.asList(new Integer(9), new Integer(9)), Arrays.asList(new Integer(10), new Integer(10)), Arrays.asList(new Integer(11), new Integer(11)), Arrays.asList(new Integer(12), new Integer(12)), Arrays.asList(new Integer(13), new Integer(13)), Arrays.asList(new Integer(14), new Integer(14)), Arrays.asList(new Integer(15), new Integer(15))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testReorder1() {
        String sql = "SELECT e1 AS x, {b'false'}, e2+e4, e3 FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", Boolean.FALSE, new Double(2.0), Boolean.FALSE), Arrays.asList(null, Boolean.FALSE, new Double(2.0), Boolean.FALSE), Arrays.asList("a", Boolean.FALSE, new Double(10.0), Boolean.TRUE), Arrays.asList("c", Boolean.FALSE, null, Boolean.TRUE), Arrays.asList("b", Boolean.FALSE, new Double(2.0), Boolean.FALSE), Arrays.asList("a", Boolean.FALSE, new Double(2.0), Boolean.FALSE)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testTwoFullOuterJoins1() {
        String sql = "SELECT A.IntKey AS A_IntKey, B.IntKey AS B_IntKey, C.IntKey AS C_IntKey FROM (BQT1.SmallA AS A FULL OUTER JOIN BQT2.SmallA AS B ON A.IntKey = B.IntKey) FULL OUTER JOIN BQT3.SmallA AS C ON B.IntKey = C.IntKey WHERE (A.IntKey >= 0) AND (A.IntKey <= 15) AND (B.IntKey >= 5) AND (B.IntKey <= 20) AND (C.IntKey >= 10) AND (C.IntKey <= 30)";
        List[] expected = new List[]{Arrays.asList(new Integer(10), new Integer(10), new Integer(10)), Arrays.asList(new Integer(11), new Integer(11), new Integer(11)), Arrays.asList(new Integer(12), new Integer(12), new Integer(12)), Arrays.asList(new Integer(13), new Integer(13), new Integer(13)), Arrays.asList(new Integer(14), new Integer(14), new Integer(14)), Arrays.asList(new Integer(15), new Integer(15), new Integer(15))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSelectDistinctOnBQT() {
        String sql = "SELECT DISTINCT IntKey FROM BQT1.SmallA";
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(5)), Arrays.asList(new Integer(6)), Arrays.asList(new Integer(7)), Arrays.asList(new Integer(8)), Arrays.asList(new Integer(9)), Arrays.asList(new Integer(10)), Arrays.asList(new Integer(11)), Arrays.asList(new Integer(12)), Arrays.asList(new Integer(13)), Arrays.asList(new Integer(14)), Arrays.asList(new Integer(15)), Arrays.asList(new Integer(16)), Arrays.asList(new Integer(17)), Arrays.asList(new Integer(18)), Arrays.asList(new Integer(19))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSelectWithNoFrom() {
        String sql = "SELECT 5";
        List[] expected = new List[]{Arrays.asList(new Integer(5))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBetween() {
        String sql = "SELECT * FROM pm1.g1 WHERE e2 BETWEEN 1 AND 2";
        List[] expected = new List[]{Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBetweenInCase() {
        String sql = "SELECT CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(-1)), Arrays.asList(new Integer(-1)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(-1)), Arrays.asList(new Integer(-1)), Arrays.asList(new Integer(-1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan("SELECT CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBetweenInCaseInSum() {
        String sql = "SELECT SUM(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Long(-2L))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan("SELECT SUM(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBetweenInCaseInSumWithGroupBy() {
        String sql = "SELECT e1, SUM(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1 GROUP BY e1 ORDER BY e1";
        List[] expected = new List[]{Arrays.asList(null, new Long(-1L)), Arrays.asList("a", new Long(1L)), Arrays.asList("b", new Long(-1L)), Arrays.asList("c", new Long(-1L))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan("SELECT e1, SUM(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 ELSE -1 END) FROM pm1.g1 GROUP BY e1 ORDER BY e1", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBetweenInCaseInCount() {
        String sql = "SELECT COUNT(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 END) FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan("SELECT COUNT(CASE WHEN e2 BETWEEN 3 AND 5 THEN e2 END) FROM pm1.g1", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase() {
        String sql = "SELECT e2, CASE e2 WHEN 1 THEN 2 ELSE 3 END FROM pm1.g1 WHERE e2 BETWEEN 1 AND 2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(2), new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSelectNoFrom1() {
        String sql = "SELECT 1";
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSelectNoFrom2() {
        String sql = "SELECT 1, {b'true'}, 2.0 AS x, {d'2003-11-04'}";
        List[] expected = new List[]{Arrays.asList(new Integer(1), Boolean.TRUE, new Double(2.0), TimestampUtil.createDate((int)103, (int)10, (int)4))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase1566() throws Exception {
        String sql = "SELECT x, COUNT(*) FROM (SELECT convert(TimestampValue, date) AS x FROM bqt1.smalla) as y GROUP BY x";
        List[] expected = new List[]{Arrays.asList(Date.valueOf("2002-01-01"), new Integer(2)), Arrays.asList(Date.valueOf("2002-01-02"), new Integer(3))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT_case1566(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect10976() {
        String sql = "SELECT * FROM vm1.g28";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("A", "a"), Arrays.asList("B", "b"), Arrays.asList("C", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect10976_2() {
        String sql = "SELECT * FROM vm1.g29";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("A", "a"), Arrays.asList("B", "b"), Arrays.asList("C", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect10976_3() {
        String sql = "SELECT * FROM vm1.g30";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect10976_4() {
        String sql = "SELECT * FROM vm1.g31 order by x";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect10976_5() {
        String sql = "SELECT * FROM vm1.g32";
        List[] expected = new List[]{Arrays.asList(null, null), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect11236_MergeJoinWithFunctions() {
        String sql = "SELECT pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e2 = (pm2.g1.e2+1) order by pm1.g1.e2, pm2.g1.e2";
        boolean pushDown = false;
        boolean dependent = false;
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), new Integer(2))};
        this.helpTestMergeJoinWithExpression(sql, pushDown, dependent, expected);
    }

    @Test
    public void testMergeJoinWithFunctionsPushDown() {
        String sql = "SELECT pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e2 = (pm2.g1.e2+1)";
        boolean pushDown = true;
        boolean dependent = false;
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), new Integer(2))};
        this.helpTestMergeJoinWithExpression(sql, pushDown, dependent, expected);
    }

    @Test
    public void testMergeJoinWithFunctionsPushDownDependent() {
        String sql = "SELECT pm1.g1.e2, pm2.g1.e2 FROM pm1.g1, pm2.g1 WHERE pm1.g1.e2 = (pm2.g1.e2+1) option makedep pm1.g1";
        boolean pushDown = true;
        boolean dependent = true;
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(1), new Integer(0)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(3), new Integer(2))};
        this.helpTestMergeJoinWithExpression(sql, pushDown, dependent, expected);
    }

    private void helpTestMergeJoinWithExpression(String sql, boolean pushDown, boolean dependent, List[] expected) {
        Object dataManager = null;
        if (!pushDown) {
            FakeDataManager fakeDataManager = new FakeDataManager();
            TestProcessor.sampleData1(fakeDataManager);
            dataManager = fakeDataManager;
        } else {
            HardcodedDataManager hardCoded = new HardcodedDataManager();
            List[] results = new List[]{Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(0), new Integer(1)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(2), new Integer(3)), Arrays.asList(new Integer(3), new Integer(4))};
            hardCoded.addData("SELECT g_0.e2 AS c_0, (g_0.e2 + 1) AS c_1 FROM pm2.g1 AS g_0 ORDER BY c_1", results);
            if (!dependent) {
                results = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3))};
                hardCoded.addData("SELECT g_0.e2 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", results);
            } else {
                results = new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(1))};
                hardCoded.addData("SELECT g_0.e2 AS c_0 FROM pm1.g1 AS g_0 WHERE g_0.e2 IN (1, 2)", results);
                results = new List[]{Arrays.asList(new Integer(3))};
                hardCoded.addData("SELECT g_0.e2 AS c_0 FROM pm1.g1 AS g_0 WHERE g_0.e2 IN (3, 4)", results);
            }
            dataManager = hardCoded;
        }
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder finder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, pushDown);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, pushDown);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(2));
        caps.setFunctionSupport("+", pushDown);
        finder.addCapabilities("pm1", (SourceCapabilities)caps);
        finder.addCapabilities("pm2", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)finder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase2() {
        String sql = "SELECT e2, CASE e2 WHEN 1 THEN 2 END FROM pm1.g1 WHERE e2 BETWEEN 1 AND 2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(2), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSortGroupCombination() throws Exception {
        String sql = "select e2, max(e1) from pm1.g1 x group by e2 order by e2 desc";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(3, "a"), Arrays.asList(2, "b"), Arrays.asList(1, "c"), Arrays.asList(0, "a")});
    }

    @Test
    public void testUnorderedLimitWithProc() throws Exception {
        String sql = "select e1 from (exec pm1.sq1()) x limit 1";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList("a")});
    }

    @Test
    public void testCase3() {
        String sql = "SELECT e2, CASE e2 WHEN 1 THEN 2 ELSE null END FROM pm1.g1 WHERE e2 BETWEEN 1 AND 2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(1), new Integer(2)), Arrays.asList(new Integer(2), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase4() {
        String nestedExpression = "(SELECT e1 FROM pm1.g2 WHERE e2 = 3)";
        String sql = "SELECT e2, CASE e2 WHEN 1 THEN " + nestedExpression + " ELSE null END FROM pm1.g1 WHERE e2 BETWEEN 1 AND 2";
        List[] expected = new List[]{Arrays.asList(new Integer(1), "a"), Arrays.asList(new Integer(1), "a"), Arrays.asList(new Integer(2), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase5() {
        String nestedExpression = "(SELECT e2 FROM pm1.g2 WHERE pm1.g1.e2 = (e4 + 2))";
        String sql = "SELECT e2, CASE e2 WHEN " + nestedExpression + " THEN 1 ELSE null END FROM pm1.g1";
        List[] expected = new List[]{Arrays.asList(new Integer(0), null), Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(3), null), Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(2), new Integer(1)), Arrays.asList(new Integer(0), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect12135() {
        String sql = "SELECT pm1.g1.e1, pm1.g2.e1 FROM pm1.g1 LEFT OUTER JOIN pm1.g2 ON pm1.g1.e1=pm1.g2.e1";
        List[] expected = new List[]{Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("b", "b"), Arrays.asList("b", "b"), Arrays.asList("c", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect12081() {
        String sql = "SELECT DISTINCT vm1.g1.e1, upper(vm1.g1.e1) as Nuge, pm1.g1.e1, upper(pm1.g1.e1) as Nuge FROM vm1.g1, pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", "A", "a", "A"), Arrays.asList("a", "A", "b", "B"), Arrays.asList("a", "A", "c", "C"), Arrays.asList("b", "B", "a", "A"), Arrays.asList("b", "B", "b", "B"), Arrays.asList("b", "B", "c", "C"), Arrays.asList("c", "C", "a", "A"), Arrays.asList("c", "C", "b", "B"), Arrays.asList("c", "C", "c", "C")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect12081_2() {
        String sql = "SELECT DISTINCT vm1.g1b.e1, vm1.g1b.e1Upper, pm1.g1.e1, upper(pm1.g1.e1) as e1Upper FROM vm1.g1b, pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", "A", "a", "A"), Arrays.asList("a", "A", "b", "B"), Arrays.asList("a", "A", "c", "C"), Arrays.asList("b", "B", "a", "A"), Arrays.asList("b", "B", "b", "B"), Arrays.asList("b", "B", "c", "C"), Arrays.asList("c", "C", "a", "A"), Arrays.asList("c", "C", "b", "B"), Arrays.asList("c", "C", "c", "C")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect12081_3() {
        String sql = "SELECT DISTINCT vm1.g1b.e1, vm1.g1b.e1Upper, pm1.g1.e1, vm1.g1b.e1Upper FROM vm1.g1b, pm1.g1";
        List[] expected = new List[]{Arrays.asList("a", "A", "a", "A"), Arrays.asList("a", "A", "b", "A"), Arrays.asList("a", "A", "c", "A"), Arrays.asList("b", "B", "a", "B"), Arrays.asList("b", "B", "b", "B"), Arrays.asList("b", "B", "c", "B"), Arrays.asList("c", "C", "a", "C"), Arrays.asList("c", "C", "b", "C"), Arrays.asList("c", "C", "c", "C")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect12081_4() {
        String sql = "SELECT DISTINCT e1, e1 FROM pm1.g1 where e1 = 'a' LIMIT 1";
        List[] expected = new List[]{Arrays.asList("a", "a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect12719() {
        String sql = "SELECT e1_, e2_, e2 FROM vm1.g34, pm1.g2 WHERE vm1.g34.e1_ = pm1.g2.e1 order by e1_, e2_";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), new Integer(1)), Arrays.asList("b", new Integer(0), new Integer(0)), Arrays.asList("b", new Integer(0), new Integer(5)), Arrays.asList("b", new Integer(0), new Integer(2)), Arrays.asList("b", new Integer(1), new Integer(0)), Arrays.asList("b", new Integer(1), new Integer(5)), Arrays.asList("b", new Integer(1), new Integer(2)), Arrays.asList("d", new Integer(3), new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect13034() {
        String sql = "SELECT CONCAT('http://', CONCAT(CASE WHEN (HOST IS NULL) OR (HOST = '') THEN 'soap_host' ELSE HOST END, CASE WHEN (PORT IS NULL) OR (PORT = '') THEN '/metamatrix-soap/services/DataService' ELSE CONCAT(':', CONCAT(PORT, '/metamatrix-soap/services/DataService')) END)) AS location FROM (SELECT env('soap_host') AS HOST, env('soap_port') AS PORT) AS props";
        List[] expected = new List[]{Arrays.asList("http://my.host.com:12345/metamatrix-soap/services/DataService")};
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, new FakeDataManager(), expected);
    }

    @Test
    public void testIntAvgDefect11682() {
        String sql = "SELECT AVG(IntKey), AVG(IntNum), AVG(FloatNum), AVG(LongNum), AVG(DoubleNum), AVG(ByteNum), AVG(ShortValue), AVG(BigIntegerValue), AVG(BigDecimalValue) FROM BQT1.SmallA";
        List[] expected = new List[]{Arrays.asList(new Double(1.5), new Double(1.5), new Double(1.5), new Double(1.5), new Double(1.5), new Double(1.5), new Double(1.5), new BigDecimal("1.500000000"), new BigDecimal("1.500000000"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT_defect11682(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonJoinCriteriaInFrom() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a LEFT OUTER JOIN pm2.g1 b ON a.e1=b.e1 AND b.e2 = 0";
        List[] expected = new List[]{Arrays.asList("a", null, null), Arrays.asList("b", "b", new Integer(0)), Arrays.asList("c", null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonJoinCriteriaInWhere() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a LEFT OUTER JOIN pm2.g1 b ON a.e1=b.e1 WHERE b.e2 = 0";
        List[] expected = new List[]{Arrays.asList("b", "b", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonJoinCriteriaInWhere2() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a LEFT OUTER JOIN pm1.g2 b ON a.e1=b.e1 WHERE (a.e2 + b.e2 = 1)";
        List[] expected = new List[]{Arrays.asList("a", "a", new Integer(1)), Arrays.asList("b", "b", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonJoinCriteriaInWhere3() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a LEFT OUTER JOIN pm1.g2 b ON a.e1=b.e1 WHERE (a.e2 = 0) OR (b.e2 = 0)";
        List[] expected = new List[]{Arrays.asList("a", "a", new Integer(1)), Arrays.asList("b", "b", new Integer(0))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonJoinCriteriaInFromNestedInVirtual() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a LEFT OUTER JOIN (SELECT c.e1, d.e2 FROM pm2.g1 c JOIN pm2.g1 d ON c.e1=d.e1 AND d.e2 >= 0) b ON a.e1=b.e1 AND b.e2 = 0";
        List[] expected = new List[]{Arrays.asList("a", null, null), Arrays.asList("b", "b", new Integer(0)), Arrays.asList("c", null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonJoinCriteriaInFromUsingDependentJoin() {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a LEFT OUTER JOIN pm2.g1 b ON a.e1=b.e1 AND b.e2 = 0";
        List[] expected = new List[]{Arrays.asList("a", null, null), Arrays.asList("b", "b", new Integer(0)), Arrays.asList("c", null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect13700() {
        List[] expected = new List[]{Arrays.asList(new Integer(10))};
        ProcessorPlan plan = TestProcessor.helpGetPlan("EXEC pm1.vsp36(5)", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, new FakeDataManager(), expected);
    }

    @Test
    public void testDefect13920() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, false);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse("SELECT e5, e2, e3, e4 FROM vm1.g1c WHERE e5 >= {ts'2004-08-01 00:00:00.0'}");
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)capFinder);
        FakeDataManager dataManager = new FakeDataManager();
        dataManager.registerTuples((QueryMetadataInterface)RealMetadataFactory.example1Cached(), "pm1.g1", new List[]{Arrays.asList("Jan 01 2004 12:00:00", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("Dec 31 2004 12:00:00", new Integer(1), Boolean.TRUE, null), Arrays.asList("Aug 01 2004 12:00:00", new Integer(2), Boolean.FALSE, new Double(0.0))});
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31, 0, 0, 0);
        cal.set(14, 0);
        Timestamp t1 = new Timestamp(cal.getTime().getTime());
        cal.clear();
        cal.set(2004, 7, 1, 0, 0, 0);
        cal.set(14, 0);
        Timestamp t2 = new Timestamp(cal.getTime().getTime());
        List[] expected = new List[]{Arrays.asList(t1, new Integer(1), Boolean.TRUE, null), Arrays.asList(t2, new Integer(2), Boolean.FALSE, new Double(0.0))};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testComplexJoinExpressionsUsingDependentJoin() throws Exception {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm1.g1 a, pm2.g1 b where rtrim(a.e1)=(b.e1 || b.e1)";
        List[] expected = new List[]{Arrays.asList("bb   ", "b", new Integer(0))};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1000));
        caps.setFunctionSupport("||", true);
        caps.setFunctionSupport("rtrim", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm1.g1", 1010, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm2.g1", 9, (QueryMetadataInterface)metadata);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)metadata);
        Command command = TestProcessor.helpParse(sql);
        CommandContext context = TestProcessor.createCommandContext();
        context.setMetadata((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, capFinder, context);
        Assert.assertTrue((boolean)(plan instanceof RelationalPlan));
        RelationalPlan relationalPlan = (RelationalPlan)plan;
        RelationalNode project = relationalPlan.getRootNode();
        RelationalNode join = project.getChildren()[0];
        Assert.assertTrue((String)("Expected instance of JoinNode (for dep join) but got " + join.getClass()), (boolean)(join instanceof JoinNode));
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testComplexJoinExpressionsUsingDependentJoinWithAccessPattern() throws Exception {
        String sql = "SELECT a.e1, b.e1, b.e2 FROM pm4.g1 a, pm2.g1 b where rtrim(a.e1)=(b.e1 || b.e1)";
        List[] expected = new List[]{Arrays.asList("bb   ", "b", new Integer(0))};
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, (Object)new Integer(1));
        caps.setFunctionSupport("||", true);
        caps.setFunctionSupport("rtrim", true);
        capFinder.addCapabilities("pm4", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1();
        RealMetadataFactory.setCardinality("pm4.g1", 1010, (QueryMetadataInterface)metadata);
        RealMetadataFactory.setCardinality("pm2.g1", 9, (QueryMetadataInterface)metadata);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)metadata);
        Command command = TestProcessor.helpParse(sql);
        CommandContext context = TestProcessor.createCommandContext();
        context.setMetadata((QueryMetadataInterface)metadata);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, capFinder, context);
        Assert.assertTrue((boolean)(plan instanceof RelationalPlan));
        RelationalPlan relationalPlan = (RelationalPlan)plan;
        RelationalNode project = relationalPlan.getRootNode();
        RelationalNode join = project.getChildren()[0];
        Assert.assertTrue((String)("Expected instance of JoinNode (for dep join) but got " + join.getClass()), (boolean)(join instanceof JoinNode));
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testPushingCriteriaUnderJoinButNotToSource() {
        String sql = "SELECT A.IntKey AS A_IntKey, B.IntKey AS B_IntKey, C.IntKey AS C_IntKey FROM (BQT1.SmallA AS A FULL OUTER JOIN BQT2.SmallA AS B ON A.IntKey = B.IntKey) LEFT OUTER JOIN BQT3.SmallA AS C ON B.IntKey = C.IntKey WHERE (sin(A.IntKey) >= 0) AND (C.IntKey >= 10)";
        List[] expected = new List[]{Arrays.asList(new Integer(13), new Integer(13), new Integer(13)), Arrays.asList(new Integer(14), new Integer(14), new Integer(14)), Arrays.asList(new Integer(15), new Integer(15), new Integer(15)), Arrays.asList(new Integer(19), new Integer(19), new Integer(19)), Arrays.asList(new Integer(20), new Integer(20), new Integer(20)), Arrays.asList(new Integer(21), new Integer(21), new Integer(21)), Arrays.asList(new Integer(26), new Integer(26), new Integer(26)), Arrays.asList(new Integer(27), new Integer(27), new Integer(27)), Arrays.asList(new Integer(28), new Integer(28), new Integer(28))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPushdownLiteralInSelectUnderAggregate() {
        String sql = "SELECT COUNT(*) FROM (SELECT '' AS y, a.IntKey FROM BQT1.SmallA a union all select '', b.intkey from bqt1.smallb b) AS x";
        List[] expected = new List[]{Arrays.asList(new Integer(30))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPushdownLiteralInSelectWithOrderBy() {
        String sql = "SELECT 1, concat('a', 'b' ) AS X FROM BQT1.SmallA where intkey = 0 UNION ALL select 2, 'Hello2' from BQT1.SmallA where intkey = 1 order by X desc";
        List[] expected = new List[]{Arrays.asList(null, null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQTSmall(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPreparedStatementDefect15348() throws Exception {
        String sql = "SELECT e1 from pm1.g1 where myrtrim(?)=e1";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("myrtrim", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource(), true));
        TestProcessor.processPreparedStatement(sql, expected, dataManager, capFinder, (QueryMetadataInterface)metadata, Arrays.asList("a    "));
    }

    static void processPreparedStatement(String sql, List[] expected, ProcessorDataManager dataManager, CapabilitiesFinder capFinder, QueryMetadataInterface metadata, List<?> values) throws Exception {
        Command command = TestProcessor.helpParse(sql);
        CommandContext context = TestProcessor.createCommandContext();
        context.setMetadata(metadata);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, metadata, capFinder, context);
        VariableContext vc = new VariableContext();
        Iterator<?> valIter = values.iterator();
        for (Reference ref : ReferenceCollectorVisitor.getReferences((LanguageObject)command)) {
            vc.setGlobalValue(ref.getContextSymbol(), valIter.next());
        }
        context.setVariableContext(vc);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testPreparedStatementDefect15348b() throws Exception {
        String sql = "SELECT e1 from pm4.g1 where myrtrim(concat(?, 'a  '))=e1";
        List[] expected = new List[]{Arrays.asList("aa")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setFunctionSupport("myrtrim", true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("pm4", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore(), "example1", new FunctionTree("foo", (FunctionMetadataSource)new FakeFunctionMetadataSource(), true));
        TestProcessor.processPreparedStatement(sql, expected, dataManager, capFinder, (QueryMetadataInterface)metadata, Arrays.asList("a"));
    }

    @Test
    public void testSourceDoesntSupportGroupAlias() {
        String sql = "SELECT a.IntKey, b.IntKey FROM BQT1.SmallA a, BQT1.SmallB b WHERE a.IntKey = 5 AND A.IntKey = b.IntKey";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> atomicQueries = TestOptimizer.getAtomicQueries(plan);
        Assert.assertEquals((String)"Expected one query to get pushed down", (long)1L, (long)atomicQueries.size());
        String atomicSql = atomicQueries.iterator().next().toString();
        String expectedSql = "SELECT BQT1.SmallA.IntKey, BQT1.SmallB.IntKey FROM BQT1.SmallA, BQT1.SmallB WHERE (BQT1.SmallA.IntKey = BQT1.SmallB.IntKey) AND (BQT1.SmallA.IntKey = 5) AND (BQT1.SmallB.IntKey = 5)";
        Assert.assertEquals((Object)expectedSql, (Object)atomicSql);
        List[] expected = new List[]{Arrays.asList(new Integer(5), new Integer(5))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, expected);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSourceDoesntSupportGroupAliasOrCriteria() {
        String sql = "SELECT a.IntKey, b.IntKey FROM BQT1.SmallA a, BQT1.SmallB b WHERE a.StringKey = '5' AND A.IntKey = b.IntKey";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> atomicQueries = TestOptimizer.getAtomicQueries(plan);
        Assert.assertEquals((String)"Expected 2 queries to get pushed down", (long)2L, (long)atomicQueries.size());
        String expectedSql = "SELECT BQT1.SmallA.StringKey, BQT1.SmallA.IntKey FROM BQT1.SmallA";
        String expectedSql2 = "SELECT BQT1.SmallB.IntKey FROM BQT1.SmallB";
        HashSet<String> expectedQueries = new HashSet<String>();
        expectedQueries.add(expectedSql);
        expectedQueries.add(expectedSql2);
        Assert.assertEquals(expectedQueries, atomicQueries);
        List[] input1 = new List[]{Arrays.asList("5", new Integer(5))};
        List[] input2 = new List[]{Arrays.asList(new Integer(5))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        dataManager.addData(expectedSql2, input2);
        List[] expected = new List[]{Arrays.asList(new Integer(5), new Integer(5))};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testSourceDoesntSupportGroupAliasInVirtual() {
        String sql = "SELECT x FROM (SELECT a.IntKey as x, b.IntKey as y FROM BQT1.SmallA a, BQT1.SmallB b WHERE a.IntKey = 5 AND A.IntKey = b.IntKey) AS z, BQT2.SmallA WHERE y = IntKey";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> atomicQueries = TestOptimizer.getAtomicQueries(plan);
        Assert.assertEquals((String)"Expected 2 queries to get pushed down", (long)2L, (long)atomicQueries.size());
        String expectedSql = "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA, BQT1.SmallB WHERE (BQT1.SmallA.IntKey = BQT1.SmallB.IntKey) AND (BQT1.SmallA.IntKey = 5) AND (BQT1.SmallB.IntKey = 5)";
        String expectedSql2 = "SELECT BQT2.SmallA.IntKey FROM BQT2.SmallA WHERE BQT2.SmallA.IntKey = 5";
        HashSet<String> expectedQueries = new HashSet<String>();
        expectedQueries.add(expectedSql);
        expectedQueries.add(expectedSql2);
        Assert.assertEquals(expectedQueries, atomicQueries);
        List[] input1 = new List[]{Arrays.asList(new Integer(5), new Integer(5))};
        List[] input2 = new List[]{Arrays.asList(new Integer(5))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        dataManager.addData(expectedSql2, input2);
        List[] expected = new List[]{Arrays.asList(new Integer(5))};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCaseInGroupBy() {
        String sql = "SELECT sum (IntKey), case when IntKey>=5000 then '5000 +' else '0-999' end FROM BQT1.SmallA GROUP BY case when IntKey>=5000 then '5000 +' else '0-999' end";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        String expectedSql = "SELECT SUM(v_0.c_1), v_0.c_0 FROM (SELECT CASE WHEN g_0.IntKey >= 5000 THEN '5000 +' ELSE '0-999' END AS c_0, g_0.IntKey AS c_1 FROM BQT1.SmallA AS g_0) AS v_0 GROUP BY v_0.c_0";
        Assert.assertEquals((long)1L, (long)actualQueries.size());
        Assert.assertEquals((Object)expectedSql, (Object)actualQueries.iterator().next().toString());
        List[] input1 = new List[]{Arrays.asList(new Integer(5), new Integer(10))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        List[] expected = new List[]{Arrays.asList(new Integer(5), new Integer(10))};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCaseInGroupByAndHavingCantPush() {
        String sql = "SELECT sum (IntKey), case when IntKey>=5000 then '5000 +' else '0-999' end FROM BQT1.SmallA GROUP BY case when IntKey>=5000 then '5000 +' else '0-999' end HAVING case when IntKey>=5000 then '5000 +' else '0-999' end = '5000 +'";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        String expectedSql = "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA";
        Assert.assertEquals((long)1L, (long)actualQueries.size());
        Assert.assertEquals((Object)expectedSql, (Object)actualQueries.iterator().next().toString());
        List[] input1 = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(10000)), Arrays.asList(new Integer(10002))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        List[] expected = new List[]{Arrays.asList(new Long(20002L), "5000 +")};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCaseInGroupByAndHavingCantPush2() {
        String sql = "SELECT sum (IntKey), case when IntKey>=5000 then '5000 +' else '0-999' end || 'x' FROM BQT1.SmallA GROUP BY case when IntKey>=5000 then '5000 +' else '0-999' end HAVING length(case when IntKey>=5000 then '5000 +' else '0-999' end) > 5";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        String expectedSql = "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA";
        Assert.assertEquals((long)1L, (long)actualQueries.size());
        Assert.assertEquals((Object)expectedSql, (Object)actualQueries.iterator().next().toString());
        List[] input1 = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(10000)), Arrays.asList(new Integer(10002))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        List[] expected = new List[]{Arrays.asList(new Long(20002L), "5000 +x")};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCaseInGroupByAndHavingCantPush3() {
        String sql = "SELECT s, c FROM (SELECT sum (IntKey) s, case when IntKey>=5000 then '5000 +' else '0-999' end || 'x' c FROM BQT1.SmallA GROUP BY case when IntKey>=5000 then '5000 +' else '0-999' end ) AS x WHERE length(c) > 5 AND s = 20002";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        String expectedSql = "SELECT BQT1.SmallA.IntKey FROM BQT1.SmallA";
        Assert.assertEquals((long)1L, (long)actualQueries.size());
        Assert.assertEquals((Object)expectedSql, (Object)actualQueries.iterator().next().toString());
        List[] input1 = new List[]{Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(10000)), Arrays.asList(new Integer(10002))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        List[] expected = new List[]{Arrays.asList(new Long(20002L), "5000 +x")};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testFunctionOfAggregateCantPush() {
        String sql = "SELECT StringKey || 'x', SUM(length(StringKey || 'x')) + 1 AS x FROM BQT1.SmallA GROUP BY StringKey || 'x' HAVING space(MAX(length((StringKey || 'x') || 'y'))) = '   '";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        String expectedSql = "SELECT BQT1.SmallA.StringKey FROM BQT1.SmallA";
        Assert.assertEquals((long)1L, (long)actualQueries.size());
        Assert.assertEquals((Object)expectedSql, (Object)actualQueries.iterator().next().toString());
        List[] input1 = new List[]{Arrays.asList("0"), Arrays.asList("1"), Arrays.asList("10"), Arrays.asList("11"), Arrays.asList("100")};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        List[] expected = new List[]{Arrays.asList("0x", new Long(3L)), Arrays.asList("1x", new Long(3L))};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase2634() {
        String sql = "SELECT x, IntKey FROM (SELECT IntKey, 'a' AS x FROM BQT1.SmallA UNION ALL SELECT IntKey, 'b' AS x FROM BQT1.SmallB) as Z";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        Set<String> actualQueries = TestOptimizer.getAtomicQueries(plan);
        String expectedSql = "SELECT 'a' AS c_0, BQT1.SmallA.IntKey AS c_1 FROM BQT1.SmallA UNION ALL SELECT 'b' AS c_0, BQT1.SmallB.IntKey AS c_1 FROM BQT1.SmallB";
        Assert.assertEquals((long)1L, (long)actualQueries.size());
        Assert.assertEquals((Object)expectedSql, (Object)actualQueries.iterator().next().toString());
        List[] input1 = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(1)), Arrays.asList("b", new Integer(0)), Arrays.asList("b", new Integer(1))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData(expectedSql, input1);
        List[] expected = new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList("a", new Integer(1)), Arrays.asList("b", new Integer(0)), Arrays.asList("b", new Integer(1))};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testQueryWithoutFromWithOrderBy() {
        String sql = "select 'three' as x ORDER BY x";
        List[] expected = new List[]{Arrays.asList("three")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testQueryWithoutFromWithOrderBy2() {
        String sql = "select concat('three', ' sixteen') as x ORDER BY x";
        List[] expected = new List[]{Arrays.asList("three sixteen")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testQueryWithoutFromWithOrderBy3() {
        String sql = "SELECT CONCAT('yy', 'z') as c1234567890123456789012345678901234567890, CONCAT('21', '12') AS EXPR ORDER BY c1234567890123456789012345678901234567890";
        List[] expected = new List[]{Arrays.asList("yyz", "2112")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase2507_3() {
        String sql = "SELECT CONCAT('yy', 'z') AS c1234567890123456789012345678901234567890, CONCAT('21', '12') AS EXPR ORDER BY c1234567890123456789012345678901234567890";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("concat", true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[0], true);
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0});
        List[] expectedResults = new List[]{Arrays.asList("yyz", "2112")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT1(dataManager);
        TestProcessor.helpProcess(plan, dataManager, expectedResults);
    }

    @Test
    public void testMultiGroupJoinCriteria() {
        String sql = "SELECT X.NEWFIELD FROM (SELECT SMALLA.STRINGNUM, CASE WHEN SMALLA.STRINGNUM LIKE '1%' THEN SMALLA.INTKEY WHEN SMALLA.STRINGNUM LIKE '2%' THEN SMALLB.INTNUM WHEN SMALLA.STRINGNUM LIKE '3%' THEN MEDIUMA.INTKEY END AS NEWFIELD FROM BQT1.SMALLA, BQT1.SMALLB, BQT1.MEDIUMA WHERE SMALLA.INTKEY = SMALLB.INTKEY AND SMALLA.INTKEY = MEDIUMA.INTKEY) AS X WHERE X.NEWFIELD = -3";
        String expectedAtomic1 = "SELECT BQT1.SMALLB.INTKEY, BQT1.SMALLB.INTNUM FROM BQT1.SMALLB";
        String expectedAtomic2 = "SELECT BQT1.MEDIUMA.INTKEY FROM BQT1.MEDIUMA";
        String expectedAtomic3 = "SELECT BQT1.SMALLA.INTKEY, BQT1.SMALLA.STRINGNUM FROM BQT1.SMALLA";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{expectedAtomic1, expectedAtomic2, expectedAtomic3}, true);
        TestOptimizer.checkNodeTypes(plan, new int[]{3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 0});
        List[] expectedResults = new List[]{Arrays.asList(new Integer(-3))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        List[] input1 = new List[]{Arrays.asList(new Integer(1), new Integer(-4)), Arrays.asList(new Integer(2), new Integer(-3)), Arrays.asList(new Integer(3), new Integer(-2))};
        dataManager.addData(expectedAtomic1, input1);
        List[] input2 = new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3))};
        dataManager.addData(expectedAtomic2, input2);
        List[] input3 = new List[]{Arrays.asList(new Integer(1), new String("1")), Arrays.asList(new Integer(2), new String("2")), Arrays.asList(new Integer(3), new String("3"))};
        dataManager.addData(expectedAtomic3, input3);
        TestProcessor.helpProcess(plan, dataManager, expectedResults);
    }

    @Test
    public void testDefect18360() {
        String sql = "SELECT a.intkey, a.intnum FROM bqt1.smalla a join bqt2.mediumb b on a.stringkey = b.stringkey group by a.intkey, a.intnum";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)new BasicSourceCapabilities());
        capFinder.addCapabilities("BQT2", (SourceCapabilities)new BasicSourceCapabilities());
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (CapabilitiesFinder)capFinder);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        List[] data1 = new List[]{Arrays.asList("1", new Integer(1), new Integer(5)), Arrays.asList("2", new Integer(2), new Integer(6)), Arrays.asList("3", new Integer(3), new Integer(7))};
        dataManager.addData("SELECT bqt1.smalla.stringkey, bqt1.smalla.intkey, bqt1.smalla.intnum FROM bqt1.smalla", data1);
        List[] data2 = new List[]{Arrays.asList("1"), Arrays.asList("2"), Arrays.asList("3")};
        dataManager.addData("SELECT bqt2.mediumb.stringkey FROM bqt2.mediumb", data2);
        List[] expectedResults = new List[]{Arrays.asList(new Integer(1), new Integer(5)), Arrays.asList(new Integer(2), new Integer(6)), Arrays.asList(new Integer(3), new Integer(7))};
        TestProcessor.helpProcess(plan, dataManager, expectedResults);
    }

    @Test
    public void testDefect17407() {
        String sql = "select pm1.g1.e1 from pm1.g1, g7 MAKEDEP WHERE pm1.g1.e2=g7.e2 order by e1";
        List[] expected = new List[]{Arrays.asList(new Object[]{null}), Arrays.asList(new Object[]{null}), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDecodeAsCriteria() {
        String sql = "SELECT x.foo, e2 FROM (select decodestring(e1, 'a,q,b,w') as foo, e2 from vm1.g1) as x where x.foo = 'w'";
        List[] expected = new List[]{Arrays.asList("w", new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInputParamInNestedExecParam() {
        String sql = "EXEC pm1.vsp48('a')";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("a"), Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testVariableInExecParam() {
        String sql = "EXEC pm1.vsp49()";
        List[] expected = new List[]{Arrays.asList("b", new Integer(2))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testVariableInNestedExecParam() {
        String sql = "EXEC pm1.vsp50()";
        List[] expected = new List[]{Arrays.asList("b")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testVariableInNestedExecParamInLoop() {
        String sql = "EXEC pm1.vsp51()";
        List[] expected = new List[]{Arrays.asList("bb")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testVariableInNestedExecParamInAssignment() {
        String sql = "EXEC pm1.vsp52()";
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInputParamInNestedExecParamInLoop() {
        String sql = "EXEC pm1.vsp53('b')";
        List[] expected = new List[]{Arrays.asList("bb")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInputParamInNestedExecParamInAssignment() {
        String sql = "EXEC pm1.vsp54('c')";
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testBitwiseAggregateProc() throws Exception {
        String sql = "EXEC virt.agg()";
        List[] expected = new List[]{Arrays.asList(new Integer(0), "a", new Integer(19)), Arrays.asList(new Integer(1), "b", new Integer(4)), Arrays.asList(new Integer(2), "c", new Integer(3))};
        TransformationMetadata metadata = RealMetadataFactory.exampleBitwise();
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBitwise(dataManager, (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private void sampleDataBitwise(FakeDataManager dataMgr, QueryMetadataInterface metadata) throws Exception {
        dataMgr.registerTuples(metadata, "phys.t", new List[]{Arrays.asList(new Integer(0), "a", new Integer(1)), Arrays.asList(new Integer(0), "a", new Integer(3)), Arrays.asList(new Integer(0), "a", new Integer(16)), Arrays.asList(new Integer(1), "b", new Integer(4)), Arrays.asList(new Integer(2), "c", new Integer(2)), Arrays.asList(new Integer(2), "c", new Integer(1))});
    }

    @Test
    public void testFunctionGroupByInJoinCriteria() {
        String sql = "SELECT lower(vm1.g1.e1) from vm1.g1, vm1.g2a where vm1.g1.e1 = vm1.g2a.e1 group by lower(vm1.g1.e1)";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private TransformationMetadata createProjectErrorMetadata() {
        MetadataStore metadataStore = new MetadataStore();
        Schema p1 = RealMetadataFactory.createPhysicalModel("p1", metadataStore);
        Table t1 = RealMetadataFactory.createPhysicalGroup("t", p1);
        RealMetadataFactory.createElements(t1, new String[]{"a", "b"}, new String[]{"string", "string"});
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        QueryNode n1 = new QueryNode("SELECT convert(a, integer) as c, b FROM p1.t");
        Table vt1 = RealMetadataFactory.createVirtualGroup("t1", v1, n1);
        RealMetadataFactory.createElements(vt1, new String[]{"c", "b"}, new String[]{"integer", "string"});
        QueryNode n3 = new QueryNode("SELECT c, b FROM v1.t1 UNION ALL SELECT c, b FROM v1.t1");
        Table vu1 = RealMetadataFactory.createVirtualGroup("u1", v1, n3);
        RealMetadataFactory.createElements(vu1, new String[]{"c", "b"}, new String[]{"integer", "string"});
        return RealMetadataFactory.createTransformationMetadata(metadataStore, "projectError", new FunctionTree[0]);
    }

    @Test
    public void testProjectionErrorOverUnionWithConvert() {
        TransformationMetadata metadata = this.createProjectErrorMetadata();
        String sql = "SELECT COUNT(*) FROM v1.u1";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("p1", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(new Integer(2))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT 1 AS c_0 FROM p1.t AS g_1 UNION ALL SELECT 1 AS c_0 FROM p1.t AS g_0", new List[]{Arrays.asList(1), Arrays.asList(1)});
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUpdatesInLoop() {
        String sql = "update vm1.g39 set e2=3";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 FROM pm1.g1 AS g_0 WHERE g_0.e2 = 3", new List[]{Arrays.asList(new Integer(3))});
        dataManager.addData("UPDATE pm1.g1 SET e2 = 3 WHERE pm1.g1.e2 = 3", new List[]{Arrays.asList(new Integer(1))});
        List[] expected = new List[]{Arrays.asList(0)};
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testRand() {
        String sql = "SELECT RAND(E2) FROM pm1.g1 where pm1.g1.e2=3";
        List[] expected = new List[]{Arrays.asList(new Double(0.731057369148862))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInsertTempTableCreation() {
        MetadataStore metadataStore = new MetadataStore();
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        QueryNode n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN insert into #temp (var1) values (1); select #temp.var1 from #temp; END");
        ColumnSet<Procedure> rs = RealMetadataFactory.createResultSet("rs", new String[]{"var1"}, new String[]{"integer"});
        Procedure vp = RealMetadataFactory.createVirtualProcedure("vp", v1, null, n1);
        vp.setResultSet(rs);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "foo", new FunctionTree[0]);
        ProcessorPlan plan = TestProcessor.helpGetPlan("exec v1.vp()", (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(1))};
        TestProcessor.helpProcess(plan, new FakeDataManager(), expected);
    }

    @Test
    public void testInsertTempTableCreation1() {
        MetadataStore metadataStore = new MetadataStore();
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        QueryNode n1 = new QueryNode("CREATE VIRTUAL PROCEDURE BEGIN insert into #temp (var1) values (1); select 2 as var1 into #temp; select #temp.var1 from #temp; END");
        ColumnSet<Procedure> rs = RealMetadataFactory.createResultSet("rs", new String[]{"var1"}, new String[]{"integer"});
        Procedure vp = RealMetadataFactory.createVirtualProcedure("vp", v1, null, n1);
        vp.setResultSet(rs);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "foo", new FunctionTree[0]);
        ProcessorPlan plan = TestProcessor.helpGetPlan("exec v1.vp()", (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2))};
        TestProcessor.helpProcess(plan, new FakeDataManager(), expected);
    }

    @Test
    public void testCase4531() {
        String sql = "select intkey, intnum from (select intnum as intkey, 1 as intnum from bqt1.smalla union all select intkey, intnum from bqt1.smalla union all select intkey, intnum from bqt2.smalla) x";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(1), new Integer(1))};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.intkey, g_0.intnum FROM bqt2.smalla AS g_0", new List[]{Arrays.asList(new Integer(1), new Integer(1))});
        dataManager.addData("SELECT g_1.intnum AS c_0, 1 AS c_1 FROM bqt1.smalla AS g_1 UNION ALL SELECT g_0.IntKey AS c_0, g_0.IntNum AS c_1 FROM bqt1.smalla AS g_0", new List[]{Arrays.asList(new Integer(1), new Integer(1)), Arrays.asList(new Integer(1), new Integer(1))});
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    private void sampleDataBQT2a(FakeDataManager dataMgr) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        String[] groups = new String[]{"bqt1.smalla", "bqt2.smalla", "bqt3.smalla"};
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            String groupName = groups[groupIndex];
            List[] tuples = new List[3];
            for (int row = 0; row < tuples.length; ++row) {
                tuples[row] = new ArrayList(17);
                tuples[row].add(new Integer(row));
                tuples[row].add(String.valueOf(row));
                tuples[row].add(new Integer(row));
                tuples[row].add(String.valueOf(row));
                for (int col = 0; col < 10; ++col) {
                    tuples[row].add(null);
                }
                tuples[row].add(new BigInteger(String.valueOf(row)));
                tuples[row].add(new BigDecimal(row));
                tuples[row].add(null);
            }
            dataMgr.registerTuples((QueryMetadataInterface)metadata, groupName, tuples);
        }
    }

    @Test
    public void testDefect15355() throws Exception {
        String sql = "SELECT e1, e1 FROM pm1.g1 UNION ALL SELECT e1, (SELECT e1 FROM pm2.g1 WHERE pm2.g1.e2 = pm1.g2.e2) FROM pm1.g2";
        List[] expected = new List[]{Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c"), Arrays.asList("a", "e"), Arrays.asList("b", "b"), Arrays.asList("b", null), Arrays.asList("b", null), Arrays.asList("d", null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        capFinder.addCapabilities("pm2", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355b() throws Exception {
        String sql = "SELECT StringKey, BigIntegerValue FROM BQT1.SmallA UNION ALL SELECT StringKey, (SELECT BigIntegerValue FROM BQT3.SmallA WHERE BQT3.SmallA.BigIntegerValue = BQT2.SmallA.StringNum) FROM BQT2.SmallA";
        List[] expected = new List[]{Arrays.asList("0", new BigInteger("0")), Arrays.asList("1", new BigInteger("1")), Arrays.asList("2", new BigInteger("2")), Arrays.asList("0", new BigInteger("0")), Arrays.asList("1", new BigInteger("1")), Arrays.asList("2", new BigInteger("2"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355c() throws Exception {
        String sql = "SELECT StringKey, BigIntegerValue FROM VQT.Defect15355 WHERE StringKey = '0'";
        List[] expected = new List[]{Arrays.asList("0", new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355d() throws Exception {
        String sql = "SELECT StringKey, BigIntegerValue FROM VQT.Defect15355a WHERE StringKey = '0'";
        List[] expected = new List[]{Arrays.asList("0", new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355e() throws Exception {
        String sql = "SELECT BigIntegerValue, StringKey FROM VQT.Defect15355 WHERE StringKey = '0'";
        List[] expected = new List[]{Arrays.asList(new BigInteger("0"), "0")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355f() throws Exception {
        String sql = "SELECT BigIntegerValue FROM VQT.Defect15355 WHERE StringKey = '0'";
        List[] expected = new List[]{Arrays.asList(new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355f2() throws Exception {
        String sql = "SELECT BigIntegerValue FROM VQT.Defect15355 WHERE StringKey LIKE '%0' AND StringKey LIKE '0%'";
        List[] expected = new List[]{Arrays.asList(new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355g() throws Exception {
        String sql = "SELECT BigIntegerValue AS a, BigIntegerValue AS b FROM VQT.Defect15355 WHERE StringKey = '0'";
        List[] expected = new List[]{Arrays.asList(new BigInteger("0"), new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355h() throws Exception {
        String sql = "SELECT BigIntegerValue FROM VQT.Defect15355 WHERE BigIntegerValue = '0'";
        List[] expected = new List[]{Arrays.asList(new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDefect15355i() throws Exception {
        String sql = "SELECT BigIntegerValue FROM VQT.Defect15355b WHERE BigIntegerValue = '0'";
        List[] expected = new List[]{Arrays.asList(new BigInteger("0"))};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2a(dataManager);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT1", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        capFinder.addCapabilities("BQT3", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.exampleBQTCached();
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInnerCorrelatedReference() throws Exception {
        String sql = "SELECT DISTINCT A.e1 FROM pm1.g3 AS A WHERE (A.e1 IN (SELECT A.e1 FROM pm1.g3))";
        List[] expected = new List[]{};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT DISTINCT g_0.e1 FROM pm1.g3 AS g_0 WHERE g_0.e1 IN (SELECT g_0.e1 FROM pm1.g3 AS g_1)", expected);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        Command command = TestProcessor.helpParse(sql);
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase5413() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "SELECT e1 FROM pm1.g2 WHERE LOOKUP('pm1.g1','e1', 'e2', 0) = e1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Command command = TestProcessor.helpParse(sql);
        CommandContext context = TestProcessor.createCommandContext();
        ProcessorPlan plan = TestProcessor.helpGetPlan(command, (QueryMetadataInterface)metadata, capFinder, context);
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        FakeDataStore.sampleData2(dataManager);
        TestProcessor.helpProcess(plan, context, dataManager, expected);
    }

    @Test
    public void testRaiseNullWithSelectInto() {
        String sql = "select pm1.g1.e1, pm1.g1.e2, pm1.g1.e3, pm1.g1.e4 into pm1.g2 from pm1.g1 where (1=0)";
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0});
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        TestProcessor.helpProcess(plan, new FakeDataManager(), expected);
    }

    @Test
    public void testCase6219() {
        String sql = "SELECT e1 FROM pm1.g1, (SELECT 'ACT' AS StateCode,'A' AS StateAbbrv UNION ALL SELECT 'NSW' AS StateCode, 'N' AS StateAbbrv) AS StateNames_Abbrvs WHERE (pm1.g1.e1 = StateCode) AND ((StateNames_Abbrvs.StateAbbrv || pm1.g1.e1) = 'VVIC')";
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestOptimizer.checkNodeTypes(plan, new int[]{0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 3, 0, 0, 1});
        List[] expected = new List[]{};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSortWithLimit() {
        String sql = "select e1 from (select pm1.g1.e1, pm1.g1.e2 from pm1.g1 order by pm1.g1.e1, pm1.g1.e2 limit 1) x";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(new Object[]{null})};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSortWithLimit1() {
        String sql = "select c from (select pm1.g1.e1 a, pm1.g1.e2 b, pm1.g1.e3 c from pm1.g1 order by b limit 1) x";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata);
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
        Assert.assertEquals((Object)"SELECT pm1.g1.e3, pm1.g1.e2 FROM pm1.g1", (Object)manager.getQueries().iterator().next());
    }

    @Test
    public void testSortWithLimit2() {
        String sql = "select a from (select max(e2) a from pm1.g1 group by e2 order by a limit 1) x where a = 0";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSortWithLimit3() {
        String sql = "select c from (select pm1.g1.e3 c from pm1.g1 order by pm1.g1.e2 limit 1) x";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testSortWithLimit4() {
        String sql = "select c from (select pm1.g1.e1 a, pm1.g1.e2 b, pm1.g1.e3 c from pm1.g1 order by b limit 1) x";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, false);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps));
        List[] expected = new List[]{Arrays.asList(Boolean.FALSE)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
        Assert.assertEquals((Object)"SELECT g_0.e3 AS c_0, g_0.e2 AS c_1 FROM pm1.g1 AS g_0 ORDER BY c_1", (Object)manager.getQueries().iterator().next());
    }

    @Test
    public void testSortWithOffset() {
        String sql = "select e1 from (select pm1.g1.e1, pm1.g1.e2 from pm1.g1 order by pm1.g1.e1, pm1.g1.e2 offset 4 rows) x";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_OFFSET, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{Arrays.asList("a")};
        HardcodedDataManager manager = new HardcodedDataManager((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        manager.addData("SELECT g1.e1, g1.e2 FROM g1 ORDER BY g1.e1, g1.e2 LIMIT 4, 2147483647", new List[]{Arrays.asList("a", 1)});
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testCountWithHaving() {
        String sql = "select e1, count(*) from pm1.g1 group by e1 having count(*) > 1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("a", new Integer(3))};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testLimitZero() {
        String sql = "select e1 from pm1.g1 limit 0";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        TestOptimizer.checkNodeTypes(plan, TestRuleRaiseNull.FULLY_NULL);
        List[] expected = new List[]{};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testLimitZero1() {
        String sql = "select distinct vm1.g1.e1, y.e1 from vm1.g1 left outer join (select 1 x, e1 from vm1.g2 limit 0) y on vm1.g1.e1 = y.e1 where vm1.g1.e1 = 'a'";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        TestOptimizer.checkNodeTypes(plan, new int[]{1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0});
        List[] expected = new List[]{Arrays.asList("a", null)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testLimitZero2() {
        String sql = "select vm1.g1.e1 from vm1.g1 union select e1 from pm1.g2 limit 0";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testLimitZero3() {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        String sql = "select e1 from pm1.g2 limit 0";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
        List[] expected = new List[]{};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testUnionWithTypeConversion() {
        String sql = "select pm1.g1.e1, pm1.g1.e2 from pm1.g1 where e1 = 'b' union select e2, e1 from pm1.g2 where e1 = 'b' order by e1, e2";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("2", "b"), Arrays.asList("b", "2")};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testNonDeterministicEvaluation() throws Exception {
        String sql = "select e1, convert(rand()*1000, integer) as x from pm1.g1 where e1 = 'a'";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("a", new Integer(240)), Arrays.asList("a", new Integer(637)), Arrays.asList("a", new Integer(550))};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testDeterministicEvaluation() throws Exception {
        String sql = "select e1, convert(rand(0)*1000, integer) as x from pm1.g1 where e1 = 'a'";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList("a", new Integer(730)), Arrays.asList("a", new Integer(730)), Arrays.asList("a", new Integer(730))};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testEmptyAggregate() throws Exception {
        String sql = "select count(e1) from pm1.g1 where 1 = 0";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(new Integer(0))};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testNullAggregate() throws Exception {
        String sql = "select count(*), count(e1), sum(convert(e1, integer)) from pm1.g1 where e1 is null";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(new Integer(1), new Integer(0), null)};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testNullAggregate1() throws Exception {
        String sql = "select e1 from pm1.g1 where 1 = 0 group by e1";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testReferenceReplacementWithExpression() throws Exception {
        String sql = "select e1, e2 from (select e1, convert(e2, string) e2 from pm1.g1) x where exists (select e3 from pm1.g2 where x.e2 = e1)";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testCase6193_1() throws Exception {
        String sql = "select a.INTKEY, b.intkey from bqt1.smalla a LEFT OUTER JOIN bqt2.SMALLA b on a.intkey=b.intkey and a.intkey=5 where a.intkey <10 ";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        capFinder.addCapabilities("BQT2", (SourceCapabilities)caps);
        List[] expected = new List[]{Arrays.asList(new Integer(0), null), Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(2), null), Arrays.asList(new Integer(3), null), Arrays.asList(new Integer(4), null), Arrays.asList(new Integer(5), new Integer(5)), Arrays.asList(new Integer(6), null), Arrays.asList(new Integer(7), null), Arrays.asList(new Integer(8), null), Arrays.asList(new Integer(9), null)};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleDataBQT2(dataManager);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), new String[]{"SELECT b.intkey FROM bqt2.SMALLA AS b", "SELECT a.intkey FROM bqt1.smalla AS a"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0});
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase6193_2() throws Exception {
        String sql = "select a.e2, b.e2 from pm1.g1 a LEFT OUTER JOIN pm1.g2 b on a.e4=b.e4 and (a.e2+b.e2)=4 order by a.e2";
        List[] expected = new List[]{Arrays.asList(new Integer(0), null), Arrays.asList(new Integer(0), null), Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(2), new Integer(2)), Arrays.asList(new Integer(3), null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT a.e4, a.e2 FROM pm1.g1 AS a", "SELECT b.e4, b.e2 FROM pm1.g2 AS b"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0});
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCase6193_3() throws Exception {
        String sql = "select a.x, b.y from (select 4 x union select 1) a LEFT OUTER JOIN (select (a.e2 + b.e2) y from pm1.g1 a LEFT OUTER JOIN pm1.g2 b on a.e4=b.e4) b on (a.x = b.y)";
        List[] expected = new List[]{Arrays.asList(new Integer(1), null), Arrays.asList(new Integer(4), new Integer(4))};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT a.e4, a.e2 FROM pm1.g1 AS a", "SELECT b.e4, b.e2 FROM pm1.g2 AS b"}, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), TestOptimizer.ComparisonMode.CORRECTED_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, new int[]{2, 0, 0, 0, 0, 0, 0, 2, 0, 0, 4, 0, 0, 1});
        TestOptimizer.checkDependentJoinCount(plan, 1);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testPushdownNonAliasedSelectLiteral() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        List[] expected = new List[]{Arrays.asList("a", "b"), Arrays.asList("a", "c")};
        HardcodedDataManager manager = new HardcodedDataManager();
        manager.addData("SELECT pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList("b"), Arrays.asList("c")});
        TestProcessor.processPreparedStatement("select ?, e1 from pm1.g1", expected, manager, capFinder, (QueryMetadataInterface)metadata, Arrays.asList("a"));
    }

    @Test
    public void testCase6486() {
        String sql = "select pm2.g1.e1 from pm1.g2, pm2.g1 where pm1.g2.e1=pm2.g1.e1 group by pm2.g1.e1";
        List[] expected = new List[]{Arrays.asList("b"), Arrays.asList("d")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonPushedOffset() throws Exception {
        String sql = "SELECT e1 FROM pm1.g1 LIMIT 1, 5";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        List[] expected = new List[]{Arrays.asList("b"), Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        this.sampleData2(dataManager);
        ProcessorPlan plan = TestOptimizer.helpPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, (CapabilitiesFinder)capFinder, new String[]{"SELECT pm1.g1.e1 FROM pm1.g1 LIMIT 6"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testNonCorrelatedSubQueryExecution() throws Exception {
        String sql = "SELECT e1 FROM pm1.g1 WHERE e2 IN (SELECT e2 FROM pm2.g1)";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.setBlockOnce(true);
        dataManager.addData("SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList(1, "a"), Arrays.asList(2, "b")});
        dataManager.addData("SELECT pm2.g1.e2 FROM pm2.g1", new List[]{Arrays.asList(2)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        List[] expected = new List[]{Arrays.asList("b")};
        TestProcessor.doProcess(plan, dataManager, expected, TestProcessor.createCommandContext());
        Assert.assertEquals((long)2L, (long)dataManager.getCommandHistory().size());
    }

    @Test
    public void testAliasReuseInFunctionInSubQuery() throws Exception {
        String sql = "SELECT CONVERT(A.e2, biginteger) AS e2 FROM (   SELECT CONVERT(e2, long) AS e2 FROM pm1.g1 AS A WHERE e1 = 'a') AS A";
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder());
        List[] expected = new List[]{Arrays.asList(new BigInteger("0")), Arrays.asList(new BigInteger("3")), Arrays.asList(new BigInteger("0"))};
        FakeDataManager manager = new FakeDataManager();
        TestProcessor.sampleData1(manager);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testImplicitAggregateWithInlineView() {
        String sql = "SELECT * FROM (SELECT b.count, enterprise_id FROM (SELECT COUNT(*), 2 AS enterprise_id FROM (SELECT 'A Name' AS Name, 1 AS enterprise_id) c ) b ) a WHERE enterprise_id = 1";
        List[] expected = new List[]{};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedNestedTable() {
        String sql = "select y.e2, x.e1, x.e2 from (select * from pm1.g1) y, table (select * from pm1.g3 where e2 = y.e2) x";
        List[] expected = new List[]{Arrays.asList(0, "a", 0), Arrays.asList(0, "a", 0), Arrays.asList(1, null, 1), Arrays.asList(1, "c", 1), Arrays.asList(3, "a", 3), Arrays.asList(1, null, 1), Arrays.asList(1, "c", 1), Arrays.asList(2, "b", 2), Arrays.asList(0, "a", 0), Arrays.asList(0, "a", 0)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedNestedTable1() {
        String sql = "select y.e2, z.e2, x.e1, x.e2 from (select * from pm1.g1 order by e2 desc limit 2) y inner join pm1.g2 z on y.e1 = z.e1, table (select * from pm1.g3 where e2 = y.e2 + z.e2) x";
        List[] expected = new List[]{Arrays.asList(3, 0, "a", 3), Arrays.asList(3, 0, "a", 3)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedNestedTable2() {
        String sql = "select y.e1, x.e1 from (select distinct e1 from pm1.g1 where e1 is not null) y, table (call pm1.sq3b(\"in\" = e1, in3 = 'something')) x";
        List[] expected = new List[]{Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("a", "a"), Arrays.asList("b", "b"), Arrays.asList("c", "c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedNestedTable3() {
        String sql = "select y.e1, x.e1 from (select * from pm1.g1) y left outer join table (call pm1.sq3b(\"in\" = e2, in3 = 'something')) x on (1=1)";
        List[] expected = new List[]{Arrays.asList("a", null), Arrays.asList(null, null), Arrays.asList("a", null), Arrays.asList("c", null), Arrays.asList("b", null), Arrays.asList("a", null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedNestedTable4() {
        String sql = "select y.e1, y.e2, z.e2 from (select * from pm1.g1) y inner join table (select * from pm1.g3 where e2 = y.e2) x left outer join (select null as e1, e2 from pm1.g2) z on (x.e1 = z.e1) on (x.e1 = y.e1)";
        List[] expected = new List[]{Arrays.asList("a", 0, null), Arrays.asList("a", 0, null), Arrays.asList("a", 3, null), Arrays.asList("c", 1, null), Arrays.asList("b", 2, null), Arrays.asList("a", 0, null), Arrays.asList("a", 0, null)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCorrelatedNestedTable5() {
        String sql = "select y.e1, y.e2, z.e2 from (exec pm1.sq1()) y, table (exec pm1.sq2(y.e1)) x, table (exec pm1.sq2(x.e1)) z where y.e2 = 2";
        List[] expected = new List[]{Arrays.asList("b", 2, 2)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUncorrelatedScalarSubqueryPushdown() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1 where e1 < (select max(vm1.g1.e1) from vm1.g1)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 < (SELECT MAX(g_0.e1) FROM pm1.g1 AS g_0)"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT MAX(g_0.e1) FROM pm1.g1 AS g_0", new List[]{Arrays.asList("c")});
        hdm.addData("SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 < 'c'", new List[]{Arrays.asList("a")});
        hdm.setBlockOnce(true);
        List[] expected = new List[]{Arrays.asList("a")};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test
    public void testNonDeterministicScalarSubquery() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select count(distinct x) from (select (select uuid()) as x from pm1.g1) as v", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT 1 FROM pm1.g1 AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT 1 FROM pm1.g1 AS g_0", new List[]{Arrays.asList(1), Arrays.asList(1)});
        hdm.setBlockOnce(true);
        List[] expected = new List[]{Arrays.asList(2)};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test
    public void testUncorrelatedScalarSubqueryPushdown1() throws Exception {
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        ProcessorPlan plan = TestOptimizer.helpPlan("select pm1.g1.e1 from pm1.g1 where e1 < (select e1 from (EXEC pm1.sq1()) x order by e2 limit 1)", (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, new String[]{"SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 < (SELECT e1 FROM (EXEC pm1.sq1()) AS x ORDER BY e2 LIMIT 1)"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        TestOptimizer.checkNodeTypes(plan, TestOptimizer.FULL_PUSHDOWN);
        HardcodedDataManager hdm = new HardcodedDataManager();
        hdm.addData("SELECT g_0.e1 FROM pm1.g1 AS g_0 WHERE g_0.e1 < 'z'", new List[]{Arrays.asList("c")});
        hdm.addData("SELECT g_0.e1, g_0.e2 FROM pm1.g1 AS g_0", new List[]{Arrays.asList("z", 1), Arrays.asList("b", 2)});
        hdm.setBlockOnce(true);
        List[] expected = new List[]{Arrays.asList("c")};
        TestProcessor.helpProcess(plan, hdm, expected);
    }

    @Test
    public void testStoredProcedureSubqueryInput() {
        String sql = "exec pm1.sp2((select e2 from pm1.g1 order by e1 limit 1))";
        List[] expected = new List[]{Arrays.asList("b", 2)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e2, pm1.g1.e1 FROM pm1.g1", new List[]{Arrays.asList(1, "2"), Arrays.asList(3, "4")});
        dataManager.addData("EXEC pm1.sp2(1)", new List[]{Arrays.asList("b", 2)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testInlineViewWith() {
        String sql = "select * from (with x as (select e1 from pm1.g1) select x.e1 from x order by e1 nulls last limit 1) y";
        List[] expected = new List[]{Arrays.asList("a")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testDeleteCompensation() {
        String sql = "delete from pm1.g1 where e1 = 'a' and e2 in (select e2 from pm1.g2)";
        List[] expected = new List[]{Arrays.asList(3)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example4(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testUpdateCompensation() {
        String sql = "update pm1.g1 set e4 = null where e1 = 'a' and exists (select 1 from pm1.g2 where e2 = pm1.g1.e2)";
        List[] expected = new List[]{Arrays.asList(3)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, false);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example4(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps));
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test(expected=QueryPlannerException.class)
    public void testUpdateCompensationNotPossible() throws Exception {
        String sql = "update pm1.g1 set e4 = (select e4 from pm1.g2 where pm1.g2.e2 = pm1.g1.e2) where e1 = 'a'";
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, false);
        TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example4(), (CapabilitiesFinder)new DefaultCapabilitiesFinder((SourceCapabilities)caps), TestProcessor.createCommandContext());
    }

    @Test
    public void testDupSelect() throws Exception {
        String sql = "select e1, e1 from pm1.g1";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 FROM pm1.g1 AS g_0", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(1, 1)});
    }

    @Test
    public void testDupSelect1() throws Exception {
        String sql = "select 1, 2 from pm1.g1";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT 2 FROM pm1.g1 AS g_0", new List[]{Arrays.asList(2)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(1, 2)});
    }

    @Test
    public void testDupSelectWithOrderBy() throws Exception {
        String sql = "select e1 as a, e1 as b from pm1.g1 order by b";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e1 AS c_0 FROM pm1.g1 AS g_0 ORDER BY c_0", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(1, 1)});
    }

    @Test
    public void testOrderByExpression() throws Exception {
        String sql = "SELECT pm1.g1.e2 as y FROM pm1.g1 ORDER BY e3 || e1";
        List[] expected = new List[]{Arrays.asList(1), Arrays.asList(0), Arrays.asList(0), Arrays.asList(2), Arrays.asList(3), Arrays.asList(1)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder());
        TestProcessor.helpProcess(plan, dataManager, expected);
    }

    @Test
    public void testCrossJoinReduction() throws Exception {
        String sql = "select x.e2 from pm1.g2 y, pm1.g1 x where x.e1 = y.e1 and x.e1 = 'a'";
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT g_0.e2 FROM pm1.g1 AS g_0 WHERE g_0.e1 = 'a'", new List[]{Arrays.asList(3)});
        dataManager.addData("SELECT 1 FROM pm1.g2 AS g_0 WHERE g_0.e1 = 'a'", new List[]{Arrays.asList(1)});
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(false));
        TestProcessor.helpProcess(plan, dataManager, new List[]{Arrays.asList(3)});
    }
}

