/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;

public class TestSubquerySetCriteria
extends TestCase {
    public TestSubquerySetCriteria(String name) {
        super(name);
    }

    public static SubquerySetCriteria example1() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("a"));
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        query.setFrom(from);
        CompareCriteria crit = new CompareCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("a"));
        crit.setRightExpression((Expression)new Constant((Object)new Integer(5)));
        crit.setOperator(1);
        query.setCriteria((Criteria)crit);
        return new SubquerySetCriteria((Expression)new ElementSymbol("temp"), (QueryCommand)query);
    }

    public static SubquerySetCriteria example3() {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("a"));
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("m.g"));
        query.setFrom(from);
        CompareCriteria crit = new CompareCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("a"));
        crit.setRightExpression((Expression)new Constant((Object)new Integer(5)));
        crit.setOperator(1);
        query.setCriteria((Criteria)crit);
        return new SubquerySetCriteria((Expression)new ElementSymbol("temp2"), (QueryCommand)query);
    }

    public void testEquals1() {
        SubquerySetCriteria c1 = TestSubquerySetCriteria.example1();
        SubquerySetCriteria c2 = TestSubquerySetCriteria.example1();
        TestSubquerySetCriteria.assertTrue((String)"Equivalent set criteria should have been equal.", (boolean)c1.equals((Object)c2));
    }

    public void testEquals2() {
        SubquerySetCriteria c1 = TestSubquerySetCriteria.example1();
        SubquerySetCriteria c2 = c1.clone();
        TestSubquerySetCriteria.assertTrue((String)"Equivalent set criteria should have been equal.", (boolean)c1.equals((Object)c2));
    }

    public void testEquals3() {
        SubquerySetCriteria c1 = TestSubquerySetCriteria.example1();
        SubquerySetCriteria c2 = c1.clone();
        c2.setNegated(true);
        TestSubquerySetCriteria.assertFalse((String)"Set criteria are not the same", (boolean)c1.equals((Object)c2));
    }

    public void testSelfEquivalence() {
        SubquerySetCriteria s1 = TestSubquerySetCriteria.example1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        SubquerySetCriteria s1 = TestSubquerySetCriteria.example1();
        SubquerySetCriteria s1a = TestSubquerySetCriteria.example1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testEquivalenceDifferent() {
        SubquerySetCriteria s1 = TestSubquerySetCriteria.example1();
        SubquerySetCriteria s2 = TestSubquerySetCriteria.example3();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }
}

