/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.sql.visitor.StaticSymbolMappingVisitor;

public class TestStaticSymbolMappingVisitor
extends TestCase {
    public TestStaticSymbolMappingVisitor(String name) {
        super(name);
    }

    private Map getSymbolMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(this.exampleElement(true, 0), this.exampleElement(false, 0));
        map.put(this.exampleElement(true, 1), this.exampleElement(false, 1));
        map.put(this.exampleElement(true, 2), this.exampleElement(false, 2));
        map.put(this.exampleGroup(true, 0), this.exampleGroup(false, 0));
        map.put(this.exampleGroup(true, 1), this.exampleGroup(false, 1));
        return map;
    }

    private ElementSymbol exampleElement(boolean old, int i) {
        ElementSymbol element = null;
        element = old ? new ElementSymbol("OLDE" + i) : new ElementSymbol("NEWE" + i);
        return element;
    }

    private GroupSymbol exampleGroup(boolean old, int i) {
        if (old) {
            return new GroupSymbol("OLDG" + i);
        }
        return new GroupSymbol("NEWG" + i);
    }

    private void helpTest(LanguageObject obj, Map symbolMap) {
        List oldSymbols = (List)ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)false);
        GroupCollectorVisitor.getGroups((LanguageObject)obj, (Collection)oldSymbols);
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(symbolMap);
        DeepPreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        List newSymbols = (List)ElementCollectorVisitor.getElements((LanguageObject)obj, (boolean)false);
        GroupCollectorVisitor.getGroups((LanguageObject)obj, (Collection)newSymbols);
        TestStaticSymbolMappingVisitor.assertEquals((String)"Different number of symbols after mapping: ", (int)oldSymbols.size(), (int)newSymbols.size());
        Iterator oldIter = oldSymbols.iterator();
        Iterator newIter = newSymbols.iterator();
        while (oldIter.hasNext()) {
            Symbol oldSymbol = (Symbol)oldIter.next();
            Symbol newSymbol = (Symbol)newIter.next();
            Symbol expectedSymbol = (Symbol)symbolMap.get(oldSymbol);
            TestStaticSymbolMappingVisitor.assertEquals((String)"Did not get correct mapped symbol: ", (Object)expectedSymbol, (Object)newSymbol);
        }
    }

    public void testVisitCompareCriteria() {
        CompareCriteria cc = new CompareCriteria((Expression)this.exampleElement(true, 0), 1, (Expression)this.exampleElement(true, 1));
        this.helpTest((LanguageObject)cc, this.getSymbolMap());
    }

    public void testVisitDelete1() {
        Delete delete = new Delete(this.exampleGroup(true, 0));
        this.helpTest((LanguageObject)delete, this.getSymbolMap());
    }

    public void testVisitDelete2() {
        Delete delete = new Delete(this.exampleGroup(true, 0));
        delete.setCriteria((Criteria)new CompareCriteria((Expression)this.exampleElement(true, 0), 1, (Expression)this.exampleElement(true, 1)));
        this.helpTest((LanguageObject)delete, this.getSymbolMap());
    }

    public void testVisitGroupBy() {
        GroupBy gb = new GroupBy();
        gb.addSymbol((Expression)this.exampleElement(true, 0));
        gb.addSymbol((Expression)this.exampleElement(true, 1));
        this.helpTest((LanguageObject)gb, this.getSymbolMap());
    }

    public void testVisitInsert1() {
        Insert insert = new Insert();
        insert.setGroup(this.exampleGroup(true, 0));
        ArrayList<ElementSymbol> vars = new ArrayList<ElementSymbol>();
        vars.add(this.exampleElement(true, 0));
        vars.add(this.exampleElement(true, 1));
        insert.setVariables(vars);
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(new Constant((Object)"abc"));
        values.add(new Constant((Object)"abc"));
        insert.setValues(values);
        this.helpTest((LanguageObject)insert, this.getSymbolMap());
    }

    public void testVisitInsert2() {
        Insert insert = new Insert();
        insert.setGroup(this.exampleGroup(true, 0));
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(new Constant((Object)"abc"));
        values.add(new Constant((Object)"abc"));
        insert.setValues(values);
        this.helpTest((LanguageObject)insert, this.getSymbolMap());
    }

    public void testVisitIsNullCriteria() {
        IsNullCriteria inc = new IsNullCriteria((Expression)this.exampleElement(true, 0));
        this.helpTest((LanguageObject)inc, this.getSymbolMap());
    }

    public void testVisitMatchCriteria() {
        MatchCriteria mc = new MatchCriteria((Expression)this.exampleElement(true, 0), (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)mc, this.getSymbolMap());
    }

    public void testVisitBetweenCriteria() {
        BetweenCriteria bc = new BetweenCriteria((Expression)this.exampleElement(true, 0), (Expression)new Constant((Object)new Integer(1000)), (Expression)new Constant((Object)new Integer(2000)));
        this.helpTest((LanguageObject)bc, this.getSymbolMap());
    }

    public void testVisitOrderBy() {
        OrderBy ob = new OrderBy();
        ob.addVariable((SingleElementSymbol)this.exampleElement(true, 0));
        ob.addVariable((SingleElementSymbol)this.exampleElement(true, 1));
        ob.addVariable((SingleElementSymbol)new AliasSymbol("abc", (SingleElementSymbol)this.exampleElement(true, 2)));
        this.helpTest((LanguageObject)ob, this.getSymbolMap());
    }

    public void testVisitSelect1() {
        Select select = new Select();
        this.helpTest((LanguageObject)select, this.getSymbolMap());
    }

    public void testVisitSelect2() {
        Select select = new Select();
        MultipleElementSymbol all = new MultipleElementSymbol();
        select.addSymbol((SelectSymbol)all);
        this.helpTest((LanguageObject)select, this.getSymbolMap());
    }

    public void testVisitSelect3() {
        Select select = new Select();
        MultipleElementSymbol all = new MultipleElementSymbol();
        all.addElementSymbol(this.exampleElement(true, 0));
        select.addSymbol((SelectSymbol)all);
        this.helpTest((LanguageObject)select, this.getSymbolMap());
    }

    public void testVisitSelect4() {
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ExpressionSymbol("x", (Expression)new Function("length", new Expression[]{this.exampleElement(true, 0)})));
        select.addSymbol((SelectSymbol)new MultipleElementSymbol("abc.*"));
        select.addSymbol((SelectSymbol)this.exampleElement(true, 1));
        this.helpTest((LanguageObject)select, this.getSymbolMap());
    }

    public void testVisitSubquerySetCriteria() {
        SubquerySetCriteria ssc = new SubquerySetCriteria();
        ssc.setExpression((Expression)new Function("length", new Expression[]{this.exampleElement(true, 0)}));
        ssc.setCommand((QueryCommand)new Query());
        this.helpTest((LanguageObject)ssc, this.getSymbolMap());
    }

    public void testVisitUnaryFromClause() {
        UnaryFromClause ufc = new UnaryFromClause(this.exampleGroup(true, 0));
        this.helpTest((LanguageObject)ufc, this.getSymbolMap());
    }

    public void testVisitUpdate1() {
        Update update = new Update();
        update.setGroup(this.exampleGroup(true, 0));
        update.addChange(this.exampleElement(true, 0), (Expression)new Constant((Object)"abc"));
        update.addChange(this.exampleElement(true, 1), (Expression)new Constant((Object)"abc"));
        this.helpTest((LanguageObject)update, this.getSymbolMap());
    }

    public void testVisitUpdate2() {
        Update update = new Update();
        update.setGroup(this.exampleGroup(true, 0));
        update.addChange(this.exampleElement(true, 0), (Expression)new Constant((Object)"abc"));
        update.addChange(this.exampleElement(true, 1), (Expression)new Constant((Object)"abc"));
        update.setCriteria((Criteria)new CompareCriteria((Expression)this.exampleElement(true, 2), 3, (Expression)new Constant((Object)"xyz")));
        this.helpTest((LanguageObject)update, this.getSymbolMap());
    }

    public void testVisitAliasSymbol() {
        AliasSymbol as = new AliasSymbol("abc", (SingleElementSymbol)this.exampleElement(true, 0));
        this.helpTest((LanguageObject)as, this.getSymbolMap());
    }

    public void testVisitAllSymbol() {
        MultipleElementSymbol as = new MultipleElementSymbol();
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(this.exampleElement(true, 0));
        elements.add(this.exampleElement(true, 1));
        as.setElementSymbols(elements);
        this.helpTest((LanguageObject)as, this.getSymbolMap());
    }

    public void testVisitMultipleElementSymbol() {
        MultipleElementSymbol aigs = new MultipleElementSymbol("OLDG0.*");
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(this.exampleElement(true, 0));
        elements.add(this.exampleElement(true, 1));
        aigs.setElementSymbols(elements);
        this.helpTest((LanguageObject)aigs, this.getSymbolMap());
    }

    public void testFunction1() {
        Function f = new Function("concat", new Expression[0]);
        this.helpTest((LanguageObject)f, this.getSymbolMap());
    }

    public void testFunction2() {
        Function f = new Function("concat", new Expression[]{this.exampleElement(true, 0), this.exampleElement(true, 1)});
        this.helpTest((LanguageObject)f, this.getSymbolMap());
    }

    public void testFunction3() {
        Function f1 = new Function("concat", new Expression[]{this.exampleElement(true, 0), this.exampleElement(true, 1)});
        Function f2 = new Function("length", new Expression[]{f1});
        this.helpTest((LanguageObject)f2, this.getSymbolMap());
    }

    public void testMapMultipleElementSymbolName() {
        MultipleElementSymbol aigs = new MultipleElementSymbol("OLDG0");
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(this.exampleElement(true, 0));
        elements.add(this.exampleElement(true, 1));
        aigs.setElementSymbols(elements);
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)aigs, (LanguageVisitor)visitor);
        TestStaticSymbolMappingVisitor.assertEquals((String)"MultipleElementSymbol name did not get mapped correctly: ", (String)"NEWG0.*", (String)aigs.toString());
    }

    public void testExecName() {
        StoredProcedure exec = new StoredProcedure();
        exec.setProcedureName(this.exampleGroup(true, 1).getName());
        exec.setProcedureID((Object)"proc");
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)exec, (LanguageVisitor)visitor);
        TestStaticSymbolMappingVisitor.assertEquals((String)"Procedure name did not get mapped correctly: ", (String)this.exampleGroup(false, 1).getName(), (String)exec.getProcedureName());
    }

    public void testExecParamElement() {
        StoredProcedure exec = new StoredProcedure();
        exec.setProcedureName("pm1.proc1");
        exec.setProcedureID((Object)"proc");
        SPParameter param1 = new SPParameter(1, (Expression)this.exampleElement(true, 1));
        exec.setParameter(param1);
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)exec, (LanguageVisitor)visitor);
        TestStaticSymbolMappingVisitor.assertEquals((String)"Stored proc param did not get mapped correctly: ", (Object)this.exampleElement(false, 1), (Object)param1.getExpression());
    }

    public void testExecParamFunction() {
        StoredProcedure exec = new StoredProcedure();
        exec.setProcedureName("pm1.proc1");
        exec.setProcedureID((Object)"proc");
        Function f = new Function("length", new Expression[]{this.exampleElement(true, 1)});
        SPParameter param1 = new SPParameter(1, (Expression)f);
        exec.setParameter(param1);
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)exec, (LanguageVisitor)visitor);
        Function afterFunc = (Function)param1.getExpression();
        TestStaticSymbolMappingVisitor.assertEquals((String)"Stored proc param did not get mapped correctly: ", (Object)this.exampleElement(false, 1), (Object)afterFunc.getArg(0));
    }

    public void testExecParamNestedFunction() {
        StoredProcedure exec = new StoredProcedure();
        exec.setProcedureName("pm1.proc1");
        exec.setProcedureID((Object)"proc");
        Function f = new Function("length", new Expression[]{this.exampleElement(true, 1)});
        Function f2 = new Function("+", new Expression[]{f, new Constant((Object)new Integer(1))});
        SPParameter param1 = new SPParameter(1, (Expression)f2);
        exec.setParameter(param1);
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)exec, (LanguageVisitor)visitor);
        Function afterFunc = (Function)param1.getExpression();
        Function innerFunc = (Function)afterFunc.getArgs()[0];
        TestStaticSymbolMappingVisitor.assertEquals((String)"Stored proc param did not get mapped correctly: ", (Object)this.exampleElement(false, 1), (Object)innerFunc.getArg(0));
    }

    public void testCriteriaSelector() {
        CriteriaSelector selector = new CriteriaSelector();
        selector.setSelectorType(1);
        selector.addElement(this.exampleElement(true, 1));
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)selector, (LanguageVisitor)visitor);
        TestStaticSymbolMappingVisitor.assertEquals((String)"Criteria selector element did not get mapped correctly: ", (Object)this.exampleElement(false, 1), selector.getElements().get(0));
    }

    public void testTranslateCriteria() {
        TranslateCriteria trans = new TranslateCriteria();
        trans.addTranslation(new CompareCriteria((Expression)this.exampleElement(false, 1), 1, (Expression)this.exampleElement(false, 2)));
        StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(this.getSymbolMap());
        DeepPreOrderNavigator.doVisit((LanguageObject)trans, (LanguageVisitor)visitor);
        List elements = (List)ElementCollectorVisitor.getElements((LanguageObject)trans, (boolean)false);
        TestStaticSymbolMappingVisitor.assertEquals((String)"Translate criteria element did not get mapped correctly: ", (Object)this.exampleElement(false, 1), elements.get(0));
        TestStaticSymbolMappingVisitor.assertEquals((String)"Translate criteria element did not get mapped correctly: ", (Object)this.exampleElement(false, 2), elements.get(1));
    }
}

