/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;
import junit.framework.TestCase;
import org.junit.Test;
import org.teiid.core.types.BlobType;
import org.teiid.core.util.UnitTestUtil;

public class TestBlobValue
extends TestCase {
    public void testBlobValue() throws Exception {
        String testString = "this is test blob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        TestBlobValue.assertEquals((String)testString, (String)new String(bv.getBytes(1L, (int)bv.length())));
    }

    public void testBlobValuePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        String key = bv.getReferenceStreamId();
        BlobType read = UnitTestUtil.helpSerialize(bv);
        TestBlobValue.assertEquals((String)key, (String)read.getReferenceStreamId());
        TestBlobValue.assertNull((Object)read.getReference());
    }

    @Test
    public void testReferencePersistence() throws Exception {
        String testString = "this is test clob";
        SerialBlob blob = new SerialBlob(testString.getBytes());
        BlobType bv = new BlobType((Blob)blob);
        bv.setReferenceStreamId(null);
        BlobType read = UnitTestUtil.helpSerialize(bv);
        TestBlobValue.assertNull((Object)read.getReferenceStreamId());
        TestBlobValue.assertEquals((String)testString, (String)new String(read.getBytes(1L, (int)blob.length())));
    }
}

