/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import javax.naming.ConfigurationException;
import junit.framework.TestCase;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ExceptionUtil;

public class TestMetaMatrixExceptionUtil
extends TestCase {
    public TestMetaMatrixExceptionUtil(String name) {
        super(name);
    }

    public void testWithoutMessage() {
        NullPointerException npe = new NullPointerException();
        TeiidRuntimeException e = new TeiidRuntimeException((Throwable)npe);
        TestMetaMatrixExceptionUtil.assertEquals((String)"TeiidRuntimeException->NullPointerException", (String)ExceptionUtil.getLinkedMessagesVerbose((Throwable)e));
        TestMetaMatrixExceptionUtil.assertEquals((String)"nullnull", (String)ExceptionUtil.getLinkedMessages((Throwable)e));
    }

    public void testWithMessage() {
        NullPointerException npe = new NullPointerException("problem");
        TeiidRuntimeException e = new TeiidRuntimeException((Throwable)npe);
        TestMetaMatrixExceptionUtil.assertEquals((String)"TeiidRuntimeException-problem->NullPointerException", (String)ExceptionUtil.getLinkedMessagesVerbose((Throwable)e));
        TestMetaMatrixExceptionUtil.assertEquals((String)"problemproblem", (String)ExceptionUtil.getLinkedMessages((Throwable)e));
    }

    public void testWithAndWithoutMessage() {
        NullPointerException npe = new NullPointerException();
        TeiidException ce = new TeiidException((Throwable)npe, "problem");
        TeiidRuntimeException e = new TeiidRuntimeException((Throwable)ce);
        TestMetaMatrixExceptionUtil.assertEquals((String)"TeiidRuntimeException-problem->TeiidException->NullPointerException", (String)ExceptionUtil.getLinkedMessagesVerbose((Throwable)e));
        TestMetaMatrixExceptionUtil.assertEquals((String)"problemproblemnull", (String)ExceptionUtil.getLinkedMessages((Throwable)e));
    }

    public void testConfigurationException() {
        NullPointerException npe = new NullPointerException("problem1");
        ConfigurationException configException = new ConfigurationException("problem2");
        configException.setRootCause(npe);
        TeiidException e = new TeiidException((Throwable)configException, "problem3");
        TestMetaMatrixExceptionUtil.assertEquals((String)"TeiidException-problem3->ConfigurationException-problem2->NullPointerException-problem1", (String)ExceptionUtil.getLinkedMessagesVerbose((Throwable)e));
        TestMetaMatrixExceptionUtil.assertEquals((String)"problem3problem2problem1", (String)ExceptionUtil.getLinkedMessages((Throwable)e));
    }
}

