/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.Sequencable;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;

public final class ClobType
extends Streamable<Clob>
implements Clob,
Sequencable {
    private static final long serialVersionUID = 2753412502127824104L;
    private static final int CHAR_SEQUENCE_BUFFER_SIZE = 4096;

    public ClobType() {
    }

    public ClobType(Clob clob) {
        super(clob);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return ((Clob)this.reference).getAsciiStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return ((Clob)this.reference).getCharacterStream();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        return ((Clob)this.reference).getSubString(pos, length);
    }

    @Override
    long computeLength() throws SQLException {
        return ((Clob)this.reference).length();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        return ((Clob)this.reference).position(searchstr, start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        return ((Clob)this.reference).position(searchstr, start);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return ((Clob)this.reference).setAsciiStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return ((Clob)this.reference).setCharacterStream(pos);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return ((Clob)this.reference).setString(pos, str, offset, len);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return ((Clob)this.reference).setString(pos, str);
    }

    @Override
    public void truncate(long len) throws SQLException {
        ((Clob)this.reference).truncate(len);
    }

    public static String getString(Clob clob) throws SQLException, IOException {
        Reader reader = clob.getCharacterStream();
        StringWriter writer = new StringWriter();
        int c = reader.read();
        while (c != -1) {
            writer.write((char)c);
            c = reader.read();
        }
        reader.close();
        String data = writer.toString();
        writer.close();
        return data;
    }

    @Override
    public CharSequence getCharSequence() {
        return new CharSequence(){
            private String buffer;
            private int beginPosition;

            @Override
            public int length() {
                long result;
                try {
                    result = ClobType.this.length();
                }
                catch (SQLException err) {
                    throw new TeiidRuntimeException(err);
                }
                if ((long)((int)result) != result) {
                    throw new TeiidRuntimeException("Clob value is not representable by CharSequence");
                }
                return (int)result;
            }

            @Override
            public char charAt(int index) {
                try {
                    if (this.buffer == null || index < this.beginPosition || index >= this.beginPosition + this.buffer.length()) {
                        this.buffer = ClobType.this.getSubString(index + 1, 4096);
                        this.beginPosition = index;
                    }
                    return this.buffer.charAt(index - this.beginPosition);
                }
                catch (SQLException err) {
                    throw new TeiidRuntimeException(err);
                }
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                try {
                    return ClobType.this.getSubString(start + 1, end - start);
                }
                catch (SQLException err) {
                    throw new TeiidRuntimeException(err);
                }
            }
        };
    }

    @Override
    public void free() throws SQLException {
        ((Clob)this.reference).free();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return ((Clob)this.reference).getCharacterStream(pos, length);
    }

    public static SerialClob createClob(char[] chars) {
        try {
            return new SerialClob(chars);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException(e);
        }
    }

    @Override
    protected void readReference(ObjectInput in) throws IOException {
        char[] chars = new char[(int)this.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = in.readChar();
        }
        try {
            this.reference = new SerialClob(chars);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeReference(final ObjectOutput out) throws IOException {
        Reader r;
        Writer w = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                for (int i = off; i < len; ++i) {
                    out.writeShort(cbuf[i]);
                }
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        try {
            r = this.getCharacterStream();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        try {
            ObjectConverterUtil.write(w, r, (int)this.length, false);
        }
        finally {
            r.close();
        }
    }
}

