/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;

public class ObjectConverterUtil {
    private static final int DEFAULT_READING_SIZE = 8192;

    protected static byte[] convertBlobToByteArray(Blob data) throws TeiidException {
        try {
            InputStream l_blobStream = data.getBinaryStream();
            return ObjectConverterUtil.convertToByteArray(l_blobStream);
        }
        catch (IOException ioe) {
            Object[] params = new Object[]{data.getClass().getName()};
            throw new TeiidException(ioe, CorePlugin.Util.getString("ObjectConverterUtil.Error_translating_results_from_data_type_to_a_byte[]._1", params));
        }
        catch (SQLException sqe) {
            Object[] params = new Object[]{data.getClass().getName()};
            throw new TeiidException(sqe, CorePlugin.Util.getString("ObjectConverterUtil.Error_translating_results_from_data_type_to_a_byte[]._2", params));
        }
    }

    public static byte[] convertToByteArray(Object data) throws TeiidException, IOException {
        if (data instanceof InputStream) {
            return ObjectConverterUtil.convertToByteArray((InputStream)data);
        }
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        if (data instanceof Blob) {
            return ObjectConverterUtil.convertBlobToByteArray((Blob)data);
        }
        if (data instanceof File) {
            return ObjectConverterUtil.convertFileToByteArray((File)data);
        }
        Object[] params = new Object[]{data.getClass().getName()};
        throw new TeiidException(CorePlugin.Util.getString("ObjectConverterUtil.Object_type_not_supported_for_object_conversion._3", params));
    }

    public static byte[] convertToByteArray(InputStream is) throws IOException {
        return ObjectConverterUtil.convertToByteArray(is, -1);
    }

    public static byte[] convertToByteArray(InputStream is, int length) throws IOException {
        return ObjectConverterUtil.convertToByteArray(is, length, true);
    }

    public static byte[] convertToByteArray(InputStream is, int length, boolean close) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectConverterUtil.write((OutputStream)out, is, length, close);
        out.close();
        return out.toByteArray();
    }

    public static int write(OutputStream out, InputStream is, byte[] l_buffer, int length) throws IOException {
        return ObjectConverterUtil.write(out, is, l_buffer, length, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(OutputStream out, InputStream is, byte[] l_buffer, int length, boolean close) throws IOException {
        int writen = 0;
        try {
            int l_nbytes = 0;
            int readLength = length;
            readLength = length == -1 ? l_buffer.length : Math.min(length, l_buffer.length);
            while ((l_nbytes = is.read(l_buffer, 0, readLength)) != -1) {
                if (length != -1 && writen > length - l_nbytes) {
                    out.write(l_buffer, 0, writen + l_nbytes - length);
                    writen = length;
                    break;
                }
                out.write(l_buffer, 0, l_nbytes);
                writen += l_nbytes;
            }
            int n = writen;
            return n;
        }
        finally {
            if (close) {
                try {
                    is.close();
                }
                finally {
                    out.close();
                }
            }
        }
    }

    public static int write(OutputStream out, InputStream is, int length) throws IOException {
        return ObjectConverterUtil.write(out, is, length, true);
    }

    public static int write(OutputStream out, InputStream is, int length, boolean close) throws IOException {
        return ObjectConverterUtil.write(out, is, new byte[8192], length, close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(Writer out, Reader is, int length, boolean close) throws IOException {
        int writen = 0;
        try {
            char[] l_buffer = new char[8192];
            int l_nbytes = 0;
            while ((l_nbytes = is.read(l_buffer)) != -1) {
                if (length != -1 && writen > length - l_nbytes) {
                    out.write(l_buffer, 0, writen + l_nbytes - length);
                    writen = length;
                    break;
                }
                out.write(l_buffer, 0, l_nbytes);
                writen += l_nbytes;
            }
            int n = writen;
            return n;
        }
        finally {
            if (close) {
                try {
                    is.close();
                }
                finally {
                    out.close();
                }
            }
        }
    }

    public static InputStream convertToInputStream(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream isContent = new BufferedInputStream(bais);
        return isContent;
    }

    public static InputStream convertToInputStream(String data) {
        return ObjectConverterUtil.convertToInputStream(data.getBytes());
    }

    public static InputStream convertToInputStream(char[] data) {
        return ObjectConverterUtil.convertToInputStream(new String(data));
    }

    public static void write(InputStream is, String fileName) throws IOException {
        File f = new File(fileName);
        ObjectConverterUtil.write(is, f);
    }

    public static void write(Reader reader, String fileName) throws IOException {
        File f = new File(fileName);
        ObjectConverterUtil.write(reader, f);
    }

    public static void write(Reader reader, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(f);
        ObjectConverterUtil.write(fw, reader, -1, true);
    }

    public static void write(InputStream is, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream fio = new FileOutputStream(f);
        BufferedOutputStream bos = new BufferedOutputStream(fio);
        ObjectConverterUtil.write(bos, is, -1);
    }

    public static void write(byte[] data, String fileName) throws Exception {
        InputStream is = ObjectConverterUtil.convertToInputStream(data);
        ObjectConverterUtil.write(is, fileName);
        is.close();
    }

    public static void write(char[] data, String fileName) throws Exception {
        InputStream is = ObjectConverterUtil.convertToInputStream(data);
        ObjectConverterUtil.write(is, fileName);
        is.close();
    }

    public static char[] bytesToChar(byte[] bytes, String encoding) throws IOException {
        return ObjectConverterUtil.convertToCharArray(new ByteArrayInputStream(bytes), bytes.length, encoding);
    }

    public static byte[] convertFileToByteArray(File file) throws IOException {
        return ObjectConverterUtil.convertToByteArray(new FileInputStream(file), (int)file.length());
    }

    public static char[] convertFileToCharArray(File file, String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        return ObjectConverterUtil.convertToCharArray(stream, (int)file.length(), encoding);
    }

    public static String convertFileToString(File file) throws IOException {
        return new String(ObjectConverterUtil.convertFileToCharArray(file, null));
    }

    public static String convertToString(InputStream stream) throws IOException {
        return new String(ObjectConverterUtil.convertToCharArray(stream, -1, null));
    }

    public static char[] convertToCharArray(InputStream stream, int length, String encoding) throws IOException {
        InputStreamReader r = null;
        r = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        return ObjectConverterUtil.convertToCharArray(r, length);
    }

    public static byte[] convertToByteArray(ZipEntry ze, ZipFile zip) throws IOException {
        return ObjectConverterUtil.convertToByteArray(zip.getInputStream(ze), (int)ze.getSize());
    }

    public static String convertToString(Reader reader) throws IOException {
        return new String(ObjectConverterUtil.convertToCharArray(reader, Integer.MAX_VALUE));
    }

    public static char[] convertToCharArray(Reader reader, int length) throws IOException {
        StringWriter sb = new StringWriter();
        ObjectConverterUtil.write(sb, reader, length, true);
        return sb.toString().toCharArray();
    }
}

