/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.sql.Timestamp;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.ProcedureParameter;

public class TestParams
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestParams.createTranslationUtility(TestParams.getTestVDBName());

    public TestParams(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/sptest/spvdb.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Call getProcedure(String procName, int inputArgs, TranslationUtility transUtil) throws Exception {
        StringBuffer sql = new StringBuffer("EXEC " + procName + "(");
        if (inputArgs > 0) {
            sql.append("null");
            for (int i = 1; i < inputArgs; ++i) {
                sql.append(", null");
            }
        }
        sql.append(")");
        Call proc = (Call)transUtil.parseCommand(sql.toString());
        return proc;
    }

    private void checkParameter(Argument param, String name, String fullName, int index, Argument.Direction direction, String nameInSource, String defaultValue, BaseColumn.NullType nullability, Class javaType, int length, int precision, int scale, TranslationUtility transUtil, String modeledType, String modeledBaseType, String modeledPrimitiveType) throws Exception {
        ProcedureParameter p = param.getMetadataObject();
        TestParams.assertEquals((String)name, (String)p.getName());
        TestParams.assertEquals((String)fullName, (String)p.getFullName());
        TestParams.assertEquals((Object)direction, (Object)param.getDirection());
        TestParams.assertEquals((String)nameInSource, (String)p.getNameInSource());
        TestParams.assertEquals((String)defaultValue, (String)p.getDefaultValue());
        TestParams.assertEquals((Object)nullability, (Object)p.getNullType());
        TestParams.assertEquals((Object)javaType, (Object)p.getJavaType());
        TestParams.assertEquals((Object)javaType, (Object)param.getType());
        TestParams.assertEquals((int)length, (int)p.getLength());
        TestParams.assertEquals((int)precision, (int)p.getPrecision());
        TestParams.assertEquals((int)scale, (int)p.getScale());
        TestParams.assertEquals(null, (Object)param.getArgumentValue().getValue());
        TestParams.assertEquals((String)modeledType, (String)p.getDatatypeID());
        TestParams.assertEquals((String)modeledBaseType, (String)p.getBaseTypeID());
        TestParams.assertEquals((String)modeledPrimitiveType, (String)p.getPrimitiveTypeID());
    }

    public void testProcedureWithResultSet() throws Exception {
        Call proc = this.getProcedure("sptest.proc1", 4, CONNECTOR_METADATA_UTILITY);
        List params = proc.getArguments();
        TestParams.assertEquals((int)4, (int)params.size());
        this.checkParameter((Argument)params.get(0), "in1", "sptest.proc1.in1", 1, Argument.Direction.IN, null, "sample default", BaseColumn.NullType.No_Nulls, String.class, 20, 10, 5, CONNECTOR_METADATA_UTILITY, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
        this.checkParameter((Argument)params.get(1), "in2", "sptest.proc1.in2", 2, Argument.Direction.IN, null, "15", BaseColumn.NullType.Nullable, Integer.class, 0, 10, 0, CONNECTOR_METADATA_UTILITY, "http://www.w3.org/2001/XMLSchema#int", "http://www.w3.org/2001/XMLSchema#long", "http://www.w3.org/2001/XMLSchema#decimal");
        this.checkParameter((Argument)params.get(2), "in3", "sptest.proc1.in3", 3, Argument.Direction.IN, null, "2003-04-23 09:30:00", BaseColumn.NullType.Unknown, Timestamp.class, 22, 10, 0, CONNECTOR_METADATA_UTILITY, "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance#timestamp", "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#string");
        this.checkParameter((Argument)params.get(3), "inOptional", "sptest.proc1.inOptional", 4, Argument.Direction.IN, "optionalName", null, BaseColumn.NullType.Nullable, String.class, 0, 0, 0, CONNECTOR_METADATA_UTILITY, "http://www.w3.org/2001/XMLSchema#string", "http://www.w3.org/2001/XMLSchema#anySimpleType", "http://www.w3.org/2001/XMLSchema#string");
    }
}

