/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class AutoCleanupUtil {
    private static ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    private static final Set<PhantomReference<Object>> REFERENCES = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public static void setCleanupReference(Object o, Removable r) {
        REFERENCES.add(new PhantomCleanupReference(o, r));
        AutoCleanupUtil.doCleanup();
    }

    public static void doCleanup() {
        PhantomCleanupReference ref;
        for (int i = 0; i < 10 && (ref = (PhantomCleanupReference)QUEUE.poll()) != null; ++i) {
            ref.cleanup();
            REFERENCES.remove(ref);
        }
    }

    static final class PhantomCleanupReference
    extends PhantomReference<Object> {
        private Removable removable;

        public PhantomCleanupReference(Object referent, Removable removable) {
            super(referent, QUEUE);
            this.removable = removable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            try {
                this.removable.remove();
            }
            finally {
                this.removable = null;
                this.clear();
            }
        }
    }

    public static interface Removable {
        public void remove();
    }
}

