/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.client.BatchSerializer;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.SPage;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.processor.relational.ListNestedSortComparator;

public class STree
implements Cloneable {
    private static final Random seedGenerator = new Random(0L);
    protected int randomSeed;
    private int mask = 1;
    private int shift = 1;
    protected HashMap<Long, SPage> pages = new HashMap();
    protected volatile SPage[] header = new SPage[]{new SPage(this, true)};
    protected BatchManager keyManager;
    protected BatchManager leafManager;
    protected ListNestedSortComparator comparator;
    private int pageSize;
    protected int leafSize;
    protected int minPageSize;
    protected int keyLength;
    protected boolean batchInsert;
    protected SPage incompleteInsert;
    protected LobManager lobManager;
    protected ReentrantLock updateLock = new ReentrantLock();
    private AtomicInteger rowCount = new AtomicInteger();

    public STree(BatchManager manager, BatchManager leafManager, ListNestedSortComparator comparator, int pageSize, int leafSize, int keyLength, LobManager lobManager) {
        this.randomSeed = seedGenerator.nextInt() | 0x100;
        this.keyManager = manager;
        manager.setPrefersMemory(true);
        this.leafManager = leafManager;
        this.comparator = comparator;
        this.pageSize = pageSize;
        pageSize >>>= 3;
        while (pageSize > 0) {
            pageSize >>>= 1;
            ++this.shift;
            this.mask <<= 1;
            ++this.mask;
        }
        this.leafSize = leafSize;
        this.keyLength = keyLength;
        this.lobManager = lobManager;
        this.minPageSize = this.pageSize >> 5;
    }

    public STree clone() {
        this.updateLock.lock();
        try {
            STree clone = (STree)super.clone();
            if (this.lobManager != null) {
                clone.lobManager = this.lobManager.clone();
            }
            clone.updateLock = new ReentrantLock();
            clone.rowCount = new AtomicInteger(this.rowCount.get());
            clone.pages = new HashMap<Long, SPage>(this.pages);
            for (Map.Entry<Long, SPage> entry : clone.pages.entrySet()) {
                entry.setValue(entry.getValue().clone(clone));
            }
            for (Map.Entry<Long, SPage> entry : clone.pages.entrySet()) {
                SPage clonePage = entry.getValue();
                clonePage.next = clone.getPage(clonePage.next);
                clonePage.prev = clone.getPage(clonePage.prev);
                if (clonePage.children == null) continue;
                for (int i = 0; i < clonePage.children.size(); ++i) {
                    clonePage.children.set(i, clone.getPage(clonePage.children.get(i)));
                }
            }
            clone.header = Arrays.copyOf(this.header, this.header.length);
            for (int i = 0; i < this.header.length; ++i) {
                clone.header[i] = clone.pages.get(this.header[i].getId());
            }
            STree sTree = clone;
            return sTree;
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private SPage getPage(SPage page) {
        if (page == null) {
            return page;
        }
        return this.pages.get(page.getId());
    }

    public void writeValuesTo(ObjectOutputStream oos) throws TeiidComponentException, IOException {
        SPage page = this.header[0];
        oos.writeInt(this.rowCount.get());
        do {
            List<List<?>> batch = page.getValues();
            BatchSerializer.writeBatch((ObjectOutput)oos, (String[])this.leafManager.getTypes(), batch);
        } while (page.next != null);
    }

    public void setBatchInsert(boolean batchInsert) throws TeiidComponentException {
        if (this.batchInsert == batchInsert) {
            return;
        }
        this.batchInsert = batchInsert;
        if (batchInsert || this.incompleteInsert == null) {
            return;
        }
        SPage toFlush = this.incompleteInsert;
        this.incompleteInsert = null;
        if (toFlush.managedBatch != null) {
            return;
        }
        toFlush.setValues(toFlush.getValues());
    }

    public void readValuesFrom(ObjectInputStream ois) throws IOException, ClassNotFoundException, TeiidComponentException {
        int size = ois.readInt();
        int sizeHint = this.getExpectedHeight(size);
        this.batchInsert = true;
        while (this.getRowCount() < size) {
            List batch = BatchSerializer.readBatch((ObjectInput)ois, (String[])this.leafManager.getTypes());
            for (List list : batch) {
                this.insert(list, InsertMode.ORDERED, sizeHint);
            }
        }
        this.batchInsert = false;
    }

    protected SPage findChildTail(SPage page) {
        if (page == null) {
            page = this.header[this.header.length - 1];
            while (page.next != null) {
                page = page.next;
            }
            return page;
        }
        if (page.children != null) {
            page = page.children.get(page.children.size() - 1);
            while (page.next != null) {
                page = page.next;
            }
        }
        return page;
    }

    private int randomLevel() {
        int x = this.randomSeed;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        this.randomSeed = x;
        int level = 0;
        while ((x & this.mask) == this.mask) {
            ++level;
            x >>>= this.shift;
        }
        return level;
    }

    List find(List n, LinkedList<SPage.SearchResult> places) throws TeiidComponentException {
        SPage x = null;
        for (int i = this.header.length - 1; i >= 0; --i) {
            if (x == null) {
                x = this.header[i];
            }
            SPage.SearchResult s = SPage.search(x, n, places);
            if (places != null) {
                places.add(s);
            }
            if (s.index == -1 && s.page == this.header[i] || s.values.isEmpty()) {
                x = null;
                continue;
            }
            x = s.page;
            int index = s.index;
            boolean matched = true;
            if (index < 0) {
                matched = false;
                index = Math.max(0, -index - 2);
            }
            if (i == 0) {
                if (!matched) {
                    return null;
                }
                return s.values.get(index);
            }
            x = x.children.get(index);
        }
        return null;
    }

    public List find(List n) throws TeiidComponentException {
        return this.find(n, new LinkedList<SPage.SearchResult>());
    }

    public List insert(List tuple, InsertMode mode, int sizeHint) throws TeiidComponentException {
        LinkedList<SPage.SearchResult> places = new LinkedList<SPage.SearchResult>();
        List match = null;
        if (this.lobManager != null) {
            this.lobManager.updateReferences(tuple, LobManager.ReferenceMode.CREATE);
        }
        if (mode == InsertMode.ORDERED) {
            SPage last = null;
            while (last == null || last.children != null) {
                last = this.findChildTail(last);
                List<List<?>> batch = last.getValues();
                places.add(new SPage.SearchResult(-batch.size() - 1, last, batch));
            }
        } else {
            match = this.find(tuple, places);
            if (match != null) {
                if (mode != InsertMode.UPDATE) {
                    return match;
                }
                SPage.SearchResult last = places.getLast();
                SPage page = last.page;
                last.values.set(last.index, tuple);
                page.setValues(last.values);
                if (this.lobManager != null) {
                    this.lobManager.updateReferences(tuple, LobManager.ReferenceMode.REMOVE);
                }
                return match;
            }
        }
        List key = this.extractKey(tuple);
        int level = 0;
        if (mode != InsertMode.ORDERED) {
            level = sizeHint > -1 ? Math.min(sizeHint, this.randomLevel()) : this.randomLevel();
        } else if (!places.isEmpty() && places.getLast().values.size() == this.getPageSize(true)) {
            int row = this.rowCount.get();
            while (row != 0 && row % this.getPageSize(true) == 0) {
                row = (row - this.getPageSize(true) + 1) / this.getPageSize(true);
                ++level;
            }
        }
        assert (this.header.length == places.size());
        if (level >= this.header.length) {
            this.header = Arrays.copyOf(this.header, level + 1);
        }
        this.rowCount.addAndGet(1);
        SPage page = null;
        for (int i = 0; i <= level; ++i) {
            if (places.isEmpty()) {
                SPage newHead = new SPage(this, false);
                List<List<?>> batch = newHead.getValues();
                batch.add(key);
                newHead.setValues(batch);
                newHead.children.add(page);
                this.header[i] = newHead;
                page = newHead;
                continue;
            }
            SPage.SearchResult result = places.removeLast();
            List value = i == 0 ? tuple : page;
            page = this.insert(key, result, places.peekLast(), value, mode == InsertMode.ORDERED);
        }
        return null;
    }

    public int getExpectedHeight(int sizeHint) {
        if (sizeHint == 0) {
            return 0;
        }
        int logSize = 1;
        while (sizeHint > this.getPageSize(logSize == 0)) {
            sizeHint /= this.getPageSize(++logSize == 0);
        }
        return logSize;
    }

    List extractKey(List tuple) {
        if (tuple.size() > this.keyLength) {
            return new ArrayList(tuple.subList(0, this.keyLength));
        }
        return tuple;
    }

    SPage insert(List k, SPage.SearchResult result, SPage.SearchResult parent, Object value, boolean ordered) throws TeiidComponentException {
        boolean leaf;
        SPage page = result.page;
        int index = -result.index - 1;
        boolean bl = leaf = !(value instanceof SPage);
        if (result.values.size() == this.getPageSize(leaf)) {
            SPage nextPage = new SPage(this, leaf);
            List<List<?>> nextValues = nextPage.getValues();
            nextPage.next = page.next;
            nextPage.prev = page;
            if (nextPage.next != null) {
                nextPage.next.prev = nextPage;
            }
            page.next = nextPage;
            boolean inNext = false;
            if (!ordered) {
                nextValues.addAll(result.values.subList(this.getPageSize(leaf) / 2, this.getPageSize(leaf)));
                result.values.subList(this.getPageSize(leaf) / 2, this.getPageSize(leaf)).clear();
                if (!leaf) {
                    nextPage.children.addAll(page.children.subList(this.getPageSize(leaf) / 2, this.getPageSize(false)));
                    page.children.subList(this.getPageSize(false) / 2, this.getPageSize(false)).clear();
                }
                if (index <= this.getPageSize(leaf) / 2) {
                    STree.setValue(index, k, value, result.values, page);
                } else {
                    inNext = true;
                    STree.setValue(index - this.getPageSize(leaf) / 2, k, value, nextValues, nextPage);
                }
                page.setValues(result.values);
                if (parent != null) {
                    List<?> min = nextPage.getValues().get(0);
                    SPage.correctParents(parent.page, min, page, nextPage);
                }
            } else {
                inNext = true;
                STree.setValue(0, k, value, nextValues, nextPage);
            }
            nextPage.setValues(nextValues);
            if (inNext) {
                page = nextPage;
            }
        } else {
            STree.setValue(index, k, value, result.values, page);
            page.setValues(result.values);
        }
        return page;
    }

    static void setValue(int index, List key, Object value, List<List<?>> values, SPage page) {
        if (value instanceof SPage) {
            values.add(index, key);
            page.children.add(index, (SPage)value);
        } else {
            values.add(index, (List)value);
        }
    }

    public List remove(List key) throws TeiidComponentException {
        LinkedList<SPage.SearchResult> places = new LinkedList<SPage.SearchResult>();
        List tuple = this.find(key, places);
        if (tuple == null) {
            return null;
        }
        this.rowCount.addAndGet(-1);
        for (int i = 0; i < this.header.length; ++i) {
            int size;
            SPage.SearchResult searchResult = places.removeLast();
            if (searchResult.index < 0) continue;
            searchResult.values.remove(searchResult.index);
            boolean leaf = true;
            if (searchResult.page.children != null) {
                leaf = false;
                searchResult.page.children.remove(searchResult.index);
            }
            if ((size = searchResult.values.size()) == 0) {
                if (this.header[i] != searchResult.page) {
                    searchResult.page.remove(false);
                    if (searchResult.page.next != null) {
                        searchResult.page.next.prev = searchResult.page.prev;
                    }
                    searchResult.page.prev.next = searchResult.page.next;
                    searchResult.page.next = this.header[i];
                    searchResult.page.prev = null;
                    continue;
                }
                this.header[i].remove(false);
                if (this.header[i].next != null) {
                    this.header[i] = this.header[i].next;
                    this.header[i].prev = null;
                    continue;
                }
                if (i != 0) {
                    this.header = Arrays.copyOf(this.header, i);
                    break;
                }
                this.header[0] = new SPage(this, true);
                continue;
            }
            if (size < this.getPageSize(leaf) / 2) {
                List<List<?>> prevValues;
                List<List<?>> nextValues;
                if (searchResult.page.next != null && (nextValues = searchResult.page.next.getValues()).size() < this.getPageSize(leaf) / 4) {
                    SPage.merge(places, nextValues, searchResult.page, searchResult.values);
                    continue;
                }
                if (searchResult.page.prev != null && (prevValues = searchResult.page.prev.getValues()).size() < this.getPageSize(leaf) / 4) {
                    SPage.merge(places, searchResult.values, searchResult.page.prev, prevValues);
                    continue;
                }
            }
            searchResult.page.setValues(searchResult.values);
        }
        if (this.lobManager != null) {
            this.lobManager.updateReferences(tuple, LobManager.ReferenceMode.REMOVE);
        }
        return tuple;
    }

    public void remove() {
        this.truncate(true);
        this.keyManager.remove();
        this.leafManager.remove();
    }

    public int getRowCount() {
        return this.rowCount.get();
    }

    public int truncate(boolean force) {
        int oldSize = this.rowCount.getAndSet(0);
        for (int i = 0; i < this.header.length; ++i) {
            SPage page = this.header[i];
            while (page != null) {
                page.remove(force);
                page = page.next;
            }
        }
        this.header = new SPage[]{new SPage(this, true)};
        return oldSize;
    }

    public int getHeight() {
        return this.header.length;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = this.header.length - 1; i >= 0; --i) {
            SPage page = this.header[i];
            result.append("Level ").append(i).append(" ");
            while (page != null) {
                result.append(page);
                result.append(", ");
                page = page.next;
            }
            result.append("\n");
        }
        return result.toString();
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setPreferMemory(boolean preferMemory) {
        this.leafManager.setPrefersMemory(preferMemory);
    }

    public boolean isPreferMemory() {
        return this.leafManager.prefersMemory();
    }

    public ListNestedSortComparator getComparator() {
        return this.comparator;
    }

    public void compact() {
        while (this.header.length != 1) {
            SPage child = this.header[this.header.length - 2];
            if (child.next != null) {
                return;
            }
            this.header = Arrays.copyOf(this.header, this.header.length - 1);
        }
        return;
    }

    public void removeRowIdFromKey() {
        --this.keyLength;
        int[] sortParameters = this.comparator.getSortParameters();
        sortParameters = Arrays.copyOf(sortParameters, sortParameters.length - 1);
        this.comparator.setSortParameters(sortParameters);
    }

    public void clearClonedFlags() {
        for (SPage page : this.pages.values()) {
            page.trackingObject = null;
        }
    }

    public int getPageSize(boolean leaf) {
        if (leaf) {
            return this.leafSize;
        }
        return this.pageSize;
    }

    BatchManager getBatchManager(boolean leaf) {
        if (leaf) {
            return this.leafManager;
        }
        return this.keyManager;
    }

    public static enum InsertMode {
        ORDERED,
        NEW,
        UPDATE;

    }
}

