/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.List;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.translator.ExecutionFactory;

public class CapabilitiesConverter {
    private CapabilitiesConverter() {
    }

    public static SourceCapabilities convertCapabilities(ExecutionFactory srcCaps) {
        return CapabilitiesConverter.convertCapabilities(srcCaps, null);
    }

    public static BasicSourceCapabilities convertCapabilities(ExecutionFactory srcCaps, Object connectorID) {
        List pushDowns;
        BasicSourceCapabilities tgtCaps = new BasicSourceCapabilities();
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, srcCaps.supportsSelectExpression());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, srcCaps.supportsSelectDistinct());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, srcCaps.supportsAliasedTable());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, srcCaps.supportsInnerJoins());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, srcCaps.supportsSelfJoins(), SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, srcCaps.supportsOuterJoins());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, srcCaps.supportsFullOuterJoins());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, srcCaps.supportsInlineViews(), SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, srcCaps.supportsCompareCriteriaEquals());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, srcCaps.supportsCompareCriteriaOrdered());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE, srcCaps.supportsLikeCriteria());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.CRITERIA_LIKE_ESCAPE, srcCaps.supportsLikeCriteriaEscapeCharacter(), SourceCapabilities.Capability.CRITERIA_LIKE);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, srcCaps.supportsInCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, srcCaps.supportsInCriteriaSubquery());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_ISNULL, srcCaps.supportsIsNullCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_OR, srcCaps.supportsOrCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, srcCaps.supportsNotCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_EXISTS, srcCaps.supportsExistsCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_SOME, srcCaps.supportsQuantifiedCompareCriteriaSome());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_QUANTIFIED_ALL, srcCaps.supportsQuantifiedCompareCriteriaAll());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, srcCaps.supportsOrderBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, srcCaps.supportsAggregatesSum());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, srcCaps.supportsAggregatesAvg());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, srcCaps.supportsAggregatesMin());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, srcCaps.supportsAggregatesMax());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, srcCaps.supportsAggregatesCount());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, srcCaps.supportsAggregatesCountStar());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT, srcCaps.supportsAggregatesDistinct());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_SCALAR, srcCaps.supportsScalarSubqueries());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, srcCaps.supportsCorrelatedSubqueries());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_CASE, srcCaps.supportsCaseExpressions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, srcCaps.supportsSearchedCaseExpressions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, srcCaps.supportsUnions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_INTERSECT, srcCaps.supportsIntersect());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_EXCEPT, srcCaps.supportsExcept());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, srcCaps.supportsSetQueryOrderBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.BULK_UPDATE, srcCaps.supportsBulkUpdate());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.BATCHED_UPDATES, srcCaps.supportsBatchedUpdates());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY, srcCaps.supportsFunctionsInGroupBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ROW_LIMIT, srcCaps.supportsRowLimit());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ROW_OFFSET, srcCaps.supportsRowOffset());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_ANSI_JOIN, srcCaps.useAnsiJoin());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.REQUIRES_CRITERIA, srcCaps.requiresCriteria());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, srcCaps.supportsGroupBy());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_HAVING, srcCaps.supportsHaving());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_QUERYEXPRESSION, srcCaps.supportsInsertWithQueryExpression());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, srcCaps.supportsOrderByUnrelated());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_ENHANCED_NUMERIC, srcCaps.supportsAggregatesEnhancedNumeric());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, srcCaps.supportsOrderByNullOrdering());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.INSERT_WITH_ITERATOR, srcCaps.supportsInsertWithIterator());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.COMMON_TABLE_EXPRESSIONS, srcCaps.supportsCommonTableExpressions());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.ELEMENTARY_OLAP, srcCaps.supportsElementaryOlapOperations());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.ADVANCED_OLAP, srcCaps.supportsAdvancedOlapOperations(), SourceCapabilities.Capability.ELEMENTARY_OLAP);
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.WINDOW_FUNCTION_ORDER_BY_AGGREGATES, srcCaps.supportsWindowOrderByWithAggregates(), SourceCapabilities.Capability.ELEMENTARY_OLAP);
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_AGGREGATES_ARRAY, srcCaps.supportsArrayAgg());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_SIMILAR, srcCaps.supportsSimilarTo());
        tgtCaps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_LIKE_REGEX, srcCaps.supportsLikeRegex());
        CapabilitiesConverter.setSupports(connectorID, tgtCaps, SourceCapabilities.Capability.WINDOW_FUNCTION_DISTINCT_AGGREGATES, srcCaps.supportsWindowDistinctAggregates(), SourceCapabilities.Capability.ELEMENTARY_OLAP, SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT);
        List functions = srcCaps.getSupportedFunctions();
        if (functions != null && functions.size() > 0) {
            for (String func : functions) {
                tgtCaps.setFunctionSupport(func.toLowerCase(), true);
            }
        }
        if ((pushDowns = srcCaps.getPushDownFunctions()) != null && pushDowns.size() > 0) {
            for (FunctionMethod func : pushDowns) {
                tgtCaps.setFunctionSupport(func.getName().toLowerCase(), true);
            }
        }
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, new Integer(srcCaps.getMaxInCriteriaSize()));
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, new Integer(srcCaps.getMaxDependentInPredicates()));
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.CONNECTOR_ID, connectorID);
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.MAX_QUERY_FROM_GROUPS, new Integer(srcCaps.getMaxFromGroups()));
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED, srcCaps.getSupportedJoinCriteria());
        tgtCaps.setSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER, srcCaps.getDefaultNullOrder());
        return tgtCaps;
    }

    private static void setSupports(Object connectorID, BasicSourceCapabilities tgtCaps, SourceCapabilities.Capability cap, boolean supports, SourceCapabilities.Capability ... required) {
        if (!supports) {
            return;
        }
        for (SourceCapabilities.Capability capability : required) {
            if (tgtCaps.supportsCapability(capability)) continue;
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (String)QueryPlugin.Util.getString("support_required", new Object[]{cap, capability, connectorID}));
            supports = false;
        }
        tgtCaps.setCapabilitySupport(cap, supports);
    }
}

