/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;

public abstract class AggregateFunction {
    private int expressionIndex = -1;
    private int conditionIndex = -1;

    public void setExpressionIndex(int expressionIndex) {
        this.expressionIndex = expressionIndex;
    }

    public void setConditionIndex(int conditionIndex) {
        this.conditionIndex = conditionIndex;
    }

    public void initialize(Class<?> dataType, Class<?> inputType) {
    }

    public abstract void reset();

    public void addInput(List<?> tuple) throws TeiidComponentException, TeiidProcessingException {
        if (this.conditionIndex != -1 && !Boolean.TRUE.equals(tuple.get(this.conditionIndex))) {
            return;
        }
        if (this.expressionIndex == -1) {
            this.addInputDirect(null, tuple);
            return;
        }
        Object input = tuple.get(this.expressionIndex);
        if (input != null || this.respectsNull()) {
            this.addInputDirect(input, tuple);
        }
    }

    public boolean respectsNull() {
        return false;
    }

    public abstract void addInputDirect(Object var1, List<?> var2) throws TeiidComponentException, TeiidProcessingException;

    public abstract Object getResult() throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException;
}

