/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.LimitNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class AccessNode
extends SubqueryAwareRelationalNode {
    private static final int MAX_CONCURRENT = 10;
    private Command command;
    private String modelName;
    private String connectorBindingId;
    private boolean shouldEvaluate = false;
    private ArrayList<TupleSource> tupleSources = new ArrayList();
    private boolean isUpdate = false;
    private boolean returnedRows = false;
    protected Command nextCommand;
    private int reserved;
    private int schemaSize;
    private Object[] projection;
    private List<SelectSymbol> originalSelect;
    private Object modelId;

    protected AccessNode() {
    }

    public AccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        this.schemaSize = this.getBufferManager().getSchemaSize(this.getOutputElements());
    }

    @Override
    public void reset() {
        super.reset();
        this.tupleSources.clear();
        this.isUpdate = false;
        this.returnedRows = false;
        this.nextCommand = null;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setModelId(Object id) {
        this.modelId = id;
    }

    public Object getModelId() {
        return this.modelId;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        Command atomicCommand = this.command;
        boolean needProcessing = true;
        if (this.shouldEvaluate) {
            atomicCommand = this.initialCommand();
        }
        do {
            atomicCommand = this.nextCommand();
            if (this.shouldEvaluate) {
                needProcessing = this.prepareNextCommand(atomicCommand);
                this.nextCommand = null;
            } else {
                needProcessing = RelationalNodeUtil.shouldExecute(atomicCommand, true);
            }
            this.isUpdate = RelationalNodeUtil.isUpdate(atomicCommand);
            if (!needProcessing) continue;
            this.registerRequest(atomicCommand);
        } while (!this.processCommandsIndividually() && this.hasNextCommand() && this.tupleSources.size() < Math.min(10, this.getContext().getUserRequestSourceConcurrency()));
    }

    public boolean isShouldEvaluate() {
        return this.shouldEvaluate;
    }

    public void minimizeProject(Command atomicCommand) {
        if (!(atomicCommand instanceof Query)) {
            return;
        }
        Query query = (Query)atomicCommand;
        Select select = query.getSelect();
        List<SelectSymbol> symbols = select.getSymbols();
        if (symbols.size() == 1) {
            return;
        }
        boolean shouldProject = false;
        LinkedHashMap<Expression, Integer> uniqueSymbols = new LinkedHashMap<Expression, Integer>();
        this.projection = new Object[symbols.size()];
        this.originalSelect = new ArrayList<SelectSymbol>(query.getSelect().getSymbols());
        int i = 0;
        int j = 0;
        Iterator<SelectSymbol> iter = symbols.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol ss = (SingleElementSymbol)iter.next();
            Expression ex = SymbolMap.getExpression(ss);
            if (ex instanceof Constant) {
                this.projection[i] = ex;
                if (iter.hasNext() || j != 0) {
                    iter.remove();
                    shouldProject = true;
                } else {
                    this.projection[i] = j++;
                }
            } else {
                Integer index = (Integer)uniqueSymbols.get(ex);
                if (index == null) {
                    uniqueSymbols.put(ex, j);
                    index = j++;
                } else {
                    iter.remove();
                    shouldProject = true;
                }
                this.projection[i] = index;
            }
            ++i;
        }
        if (!shouldProject) {
            this.projection = new Object[0];
        } else if (query.getOrderBy() != null) {
            for (OrderByItem item : query.getOrderBy().getOrderByItems()) {
                Integer index = (Integer)uniqueSymbols.get(SymbolMap.getExpression(item.getSymbol()));
                if (index == null) continue;
                item.setExpressionPosition(index);
                item.setSymbol((SingleElementSymbol)select.getSymbols().get(index));
            }
        }
    }

    public List<SelectSymbol> getOriginalSelect() {
        return this.originalSelect;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    static void rewriteAndEvaluate(Command atomicCommand, Evaluator eval, CommandContext context, QueryMetadataInterface metadata) throws TeiidProcessingException, TeiidComponentException {
        try {
            QueryRewriter.evaluateAndRewrite(atomicCommand, eval, context, metadata);
        }
        catch (QueryValidatorException e) {
            throw new TeiidProcessingException((Throwable)((Object)e), QueryPlugin.Util.getString("AccessNode.rewrite_failed", new Object[]{atomicCommand}));
        }
    }

    protected Command initialCommand() throws TeiidProcessingException, TeiidComponentException {
        return this.nextCommand();
    }

    protected Command nextCommand() {
        if (this.nextCommand == null) {
            this.nextCommand = (Command)this.command.clone();
        }
        return this.nextCommand;
    }

    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        AccessNode.rewriteAndEvaluate(atomicCommand, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
        return RelationalNodeUtil.shouldExecute(atomicCommand, true);
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (!this.tupleSources.isEmpty() || this.hasNextCommand()) {
            if (this.tupleSources.isEmpty() && this.processCommandsIndividually()) {
                this.registerNext();
            }
            for (int i = 0; i < this.tupleSources.size(); ++i) {
                TupleSource tupleSource = this.tupleSources.get(i);
                try {
                    List<?> tuple = null;
                    while ((tuple = tupleSource.nextTuple()) != null) {
                        this.returnedRows = true;
                        if (this.projection != null && this.projection.length > 0) {
                            ArrayList newTuple = new ArrayList(this.projection.length);
                            for (Object object : this.projection) {
                                if (object instanceof Integer) {
                                    newTuple.add(tuple.get((Integer)object));
                                    continue;
                                }
                                newTuple.add(((Constant)object).getValue());
                            }
                            tuple = newTuple;
                        }
                        this.addBatchRow(tuple);
                        if (!this.isBatchFull()) continue;
                        return this.pullBatch();
                    }
                    tupleSource.closeSource();
                    this.tupleSources.remove(i--);
                    if (this.reserved > 0) {
                        this.reserved -= this.schemaSize;
                        this.getBufferManager().releaseBuffers(this.schemaSize);
                    }
                    if (this.processCommandsIndividually()) continue;
                    this.registerNext();
                    continue;
                }
                catch (BlockedException e) {
                    if (!this.processCommandsIndividually()) continue;
                    throw e;
                }
            }
            if (this.processCommandsIndividually()) {
                if (!this.hasPendingRows()) continue;
                return this.pullBatch();
            }
            if (this.tupleSources.isEmpty()) continue;
            throw BlockedException.block(this.getContext().getRequestId(), "Blocking on source request(s).");
        }
        if (this.isUpdate && !this.returnedRows) {
            ArrayList<Integer> tuple = new ArrayList<Integer>(1);
            tuple.add(0);
            this.addBatchRow(tuple);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    @Override
    protected void addBatchRow(List row) {
        if (this.getOutputElements().isEmpty()) {
            row = Collections.emptyList();
        }
        super.addBatchRow(row);
    }

    private void registerNext() throws TeiidComponentException, TeiidProcessingException {
        while (this.hasNextCommand()) {
            Command atomicCommand = this.nextCommand();
            if (this.prepareNextCommand(atomicCommand)) {
                this.nextCommand = null;
                this.registerRequest(atomicCommand);
                break;
            }
            this.nextCommand = null;
        }
    }

    private void registerRequest(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        LimitNode parent;
        if (this.shouldEvaluate) {
            this.projection = null;
            this.minimizeProject(atomicCommand);
        }
        int limit = -1;
        if (this.getParent() instanceof LimitNode && (parent = (LimitNode)this.getParent()).getLimit() > 0) {
            limit = parent.getLimit() + parent.getOffset();
        }
        this.tupleSources.add(this.getDataManager().registerRequest(this.getContext(), atomicCommand, this.modelName, this.connectorBindingId, this.getID(), limit));
        if (this.tupleSources.size() > 1) {
            this.reserved += this.getBufferManager().reserveBuffers(this.schemaSize, BufferManager.BufferReserveMode.FORCE);
        }
    }

    protected boolean processCommandsIndividually() {
        return false;
    }

    protected boolean hasNextCommand() {
        return false;
    }

    @Override
    public void closeDirect() {
        this.getBufferManager().releaseBuffers(this.reserved);
        this.reserved = 0;
        super.closeDirect();
        this.closeSources();
    }

    private void closeSources() {
        for (TupleSource ts : this.tupleSources) {
            ts.closeSource();
        }
        this.tupleSources.clear();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.command);
    }

    @Override
    public Object clone() {
        AccessNode clonedNode = new AccessNode();
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(AccessNode source, AccessNode target) {
        super.copy(source, target);
        target.modelName = source.modelName;
        target.modelId = source.modelId;
        target.connectorBindingId = source.connectorBindingId;
        target.shouldEvaluate = source.shouldEvaluate;
        if (!source.shouldEvaluate) {
            target.projection = source.projection;
            target.originalSelect = source.originalSelect;
        }
        target.command = source.command;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        props.addProperty("Query", this.command.toString());
        props.addProperty("Model Name", this.modelName);
        return props;
    }

    public String getConnectorBindingId() {
        return this.connectorBindingId;
    }

    public void setConnectorBindingId(String connectorBindingId) {
        this.connectorBindingId = connectorBindingId;
    }
}

