/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.xquery.saxon.SaxonXQueryExpression;
import org.teiid.query.xquery.saxon.XQueryEvaluator;

public class XMLTableNode
extends SubqueryAwareRelationalNode
implements SaxonXQueryExpression.RowProcessor {
    private static Map<Class<?>, BuiltInAtomicType> typeMapping = new HashMap();
    private static RuntimeException EARLY_TERMINATION;
    private XMLTable table;
    private List<XMLTable.XMLColumn> projectedColumns;
    private SaxonXQueryExpression.Result result;
    private int rowCount = 0;
    private Item item;
    private TupleBuffer buffer;
    private boolean batchAvailable = false;
    private TeiidRuntimeException asynchException;
    private int outputRow = 1;
    private boolean usingOutput;

    public XMLTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public synchronized void closeDirect() {
        super.closeDirect();
        if (this.buffer != null) {
            if (!this.usingOutput) {
                this.buffer.remove();
            }
            this.buffer = null;
        }
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
        this.item = null;
        this.rowCount = 0;
        this.outputRow = 1;
        this.usingOutput = false;
        this.buffer = null;
        this.batchAvailable = false;
        this.asynchException = null;
    }

    public void setTable(XMLTable table) {
        this.table = table;
    }

    public void setProjectedColumns(List<XMLTable.XMLColumn> projectedColumns) {
        this.projectedColumns = projectedColumns;
    }

    @Override
    public XMLTableNode clone() {
        XMLTableNode clone = new XMLTableNode(this.getID());
        this.copy(this, clone);
        clone.setTable(this.table);
        clone.setProjectedColumns(this.projectedColumns);
        return clone;
    }

    @Override
    protected synchronized TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.evaluate(false);
        if (this.table.getXQueryExpression().isStreaming()) {
            while (!this.batchAvailable) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
            this.unwrapException(this.asynchException);
            TupleBatch batch = this.buffer.getBatch(this.outputRow);
            this.outputRow = batch.getEndRow() + 1;
            this.batchAvailable = this.hasNextBatch();
            return batch;
        }
        while (!this.isBatchFull() && !this.isLastBatch()) {
            if (this.item == null) {
                try {
                    this.item = this.result.iter.next();
                }
                catch (XPathException e) {
                    throw new TeiidProcessingException((Throwable)e, QueryPlugin.Util.getString("XMLTableNode.error", new Object[]{e.getMessage()}));
                }
                ++this.rowCount;
                if (this.item == null) {
                    this.terminateBatches();
                    break;
                }
            }
            this.addBatchRow(this.processRow());
        }
        return this.pullBatch();
    }

    private void evaluate(final boolean useFinalBuffer) throws TeiidComponentException, ExpressionEvaluationException, BlockedException, TeiidProcessingException {
        if (this.result != null || this.buffer != null) {
            return;
        }
        this.setReferenceValues(this.table);
        final HashMap<String, Object> parameters = new HashMap<String, Object>();
        Evaluator eval = this.getEvaluator(Collections.emptyMap());
        final Object contextItem = eval.evaluateParameters(this.table.getPassing(), null, parameters);
        if (this.table.getXQueryExpression().isStreaming()) {
            if (this.buffer == null) {
                this.buffer = this.getBufferManager().createTupleBuffer(this.getOutputElements(), this.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (!useFinalBuffer) {
                            XMLTableNode.this.buffer.setForwardOnly(true);
                        }
                        XQueryEvaluator.evaluateXQuery(XMLTableNode.this.table.getXQueryExpression(), contextItem, parameters, XMLTableNode.this, XMLTableNode.this.getContext());
                        XMLTableNode.this.buffer.close();
                    }
                    catch (TeiidException e) {
                        XMLTableNode.this.asynchException = new TeiidRuntimeException((Throwable)e);
                    }
                    catch (TeiidRuntimeException e) {
                        XMLTableNode.this.asynchException = e;
                    }
                    catch (RuntimeException e) {
                        if (e != EARLY_TERMINATION) {
                            XMLTableNode.this.asynchException = new TeiidRuntimeException((Throwable)e);
                        }
                    }
                    finally {
                        XMLTableNode.this.batchAvailable = true;
                        XMLTableNode e = XMLTableNode.this;
                        synchronized (e) {
                            XMLTableNode.this.notifyAll();
                        }
                    }
                }
            };
            this.getContext().getExecutor().execute(r);
            return;
        }
        try {
            this.result = XQueryEvaluator.evaluateXQuery(this.table.getXQueryExpression(), contextItem, parameters, null, this.getContext());
        }
        catch (TeiidRuntimeException e) {
            this.unwrapException(e);
        }
    }

    private void unwrapException(TeiidRuntimeException e) throws TeiidComponentException, TeiidProcessingException {
        if (e == null) {
            return;
        }
        if (e.getCause() instanceof TeiidComponentException) {
            throw (TeiidComponentException)e.getCause();
        }
        if (e.getCause() instanceof TeiidProcessingException) {
            throw (TeiidProcessingException)e.getCause();
        }
        throw e;
    }

    private List<?> processRow() throws ExpressionEvaluationException, BlockedException, TeiidComponentException, TeiidProcessingException {
        ArrayList<Object> tuple = new ArrayList<Object>(this.projectedColumns.size());
        for (XMLTable.XMLColumn proColumn : this.projectedColumns) {
            if (proColumn.isOrdinal()) {
                tuple.add(this.rowCount);
                continue;
            }
            try {
                Object value;
                XPathExpression path = proColumn.getPathExpression();
                XPathDynamicContext dynamicContext = path.createDynamicContext(this.item);
                SequenceIterator pathIter = path.iterate(dynamicContext);
                Item colItem = pathIter.next();
                if (colItem == null) {
                    if (proColumn.getDefaultExpression() != null) {
                        tuple.add(this.getEvaluator(Collections.emptyMap()).evaluate(proColumn.getDefaultExpression(), null));
                        continue;
                    }
                    tuple.add(null);
                    continue;
                }
                if (proColumn.getSymbol().getType() == DataTypeManager.DefaultDataClasses.XML) {
                    value = this.table.getXQueryExpression().createXMLType(pathIter.getAnother(), this.getBufferManager(), false);
                    tuple.add(value);
                    continue;
                }
                if (pathIter.next() != null) {
                    throw new TeiidProcessingException(QueryPlugin.Util.getString("XMLTableName.multi_value", new Object[]{proColumn.getName()}));
                }
                value = colItem;
                if (value instanceof AtomicValue) {
                    value = Value.convertToJava((Item)colItem);
                } else if (value instanceof Item) {
                    Object i = value;
                    BuiltInAtomicType bat = typeMapping.get(proColumn.getSymbol().getType());
                    if (bat != null) {
                        ConversionResult cr = StringValue.convertStringToBuiltInType((CharSequence)i.getStringValueCS(), (BuiltInAtomicType)bat, null);
                        value = cr.asAtomic();
                        if ((value = Value.convertToJava((Item)((AtomicValue)value))) instanceof Item) {
                            value = value.getStringValue();
                        }
                    } else {
                        value = i.getStringValue();
                    }
                }
                value = FunctionDescriptor.importValue(value, proColumn.getSymbol().getType());
                tuple.add(value);
            }
            catch (XPathException e) {
                throw new TeiidProcessingException((Throwable)e, QueryPlugin.Util.getString("XMLTableNode.path_error", new Object[]{proColumn.getName()}));
            }
        }
        this.item = null;
        return tuple;
    }

    @Override
    public boolean hasFinalBuffer() {
        return this.table.getXQueryExpression().isStreaming();
    }

    @Override
    public TupleBuffer getFinalBuffer() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.evaluate(true);
        this.usingOutput = true;
        TupleBuffer finalBuffer = this.buffer;
        if (!this.table.getXQueryExpression().isStreaming()) {
            this.close();
        }
        return finalBuffer;
    }

    @Override
    public synchronized void processRow(NodeInfo row) {
        if (this.isClosed()) {
            throw EARLY_TERMINATION;
        }
        this.item = row;
        ++this.rowCount;
        try {
            this.buffer.addTuple(this.processRow());
            if (this.hasNextBatch()) {
                this.batchAvailable = true;
                this.notifyAll();
            }
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private boolean hasNextBatch() {
        return this.outputRow + this.buffer.getBatchSize() <= this.rowCount + 1;
    }

    static {
        typeMapping.put(DataTypeManager.DefaultDataClasses.TIMESTAMP, BuiltInAtomicType.DATE_TIME);
        typeMapping.put(DataTypeManager.DefaultDataClasses.TIME, BuiltInAtomicType.TIME);
        typeMapping.put(DataTypeManager.DefaultDataClasses.DATE, BuiltInAtomicType.DATE);
        typeMapping.put(DataTypeManager.DefaultDataClasses.FLOAT, BuiltInAtomicType.FLOAT);
        typeMapping.put(DataTypeManager.DefaultDataClasses.DOUBLE, BuiltInAtomicType.DOUBLE);
        EARLY_TERMINATION = new RuntimeException();
    }
}

