/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class UpdateResolver
extends ProcedureContainerResolver
implements VariableResolver {
    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Update update = (Update)command;
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(update.getGroup());
        for (SetClause clause : update.getChangeList().getClauses()) {
            ResolverVisitor.resolveLanguageObject(clause.getSymbol(), groups, null, metadata);
        }
        QueryResolver.resolveSubqueries(command, metadata, groups);
        ResolverVisitor.resolveLanguageObject(update, groups, update.getExternalGroupContexts(), metadata);
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException {
        return metadata.getUpdatePlan(group.getMetadataID());
    }

    @Override
    public Map<ElementSymbol, Expression> getVariableValues(Command command, boolean changingOnly, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        HashMap<ElementSymbol, Expression> result = new HashMap<ElementSymbol, Expression>();
        Update update = (Update)command;
        LinkedHashMap<ElementSymbol, Expression> changing = update.getChangeList().getClauseMap();
        for (Map.Entry entry : changing.entrySet()) {
            ElementSymbol leftSymbol = ((ElementSymbol)entry.getKey()).clone();
            leftSymbol.getGroupSymbol().setName("CHANGING");
            result.put(leftSymbol, new Constant(Boolean.TRUE));
            if (changingOnly) continue;
            leftSymbol = leftSymbol.clone();
            leftSymbol.getGroupSymbol().setName("INPUTS");
            result.put(leftSymbol, (Expression)entry.getValue());
        }
        List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(update.getGroup(), metadata);
        insertElmnts.removeAll(changing.keySet());
        Iterator defaultIter = insertElmnts.iterator();
        while (defaultIter.hasNext()) {
            ElementSymbol varSymbol = ((ElementSymbol)defaultIter.next()).clone();
            varSymbol.getGroupSymbol().setName("CHANGING");
            result.put(varSymbol, new Constant(Boolean.FALSE));
        }
        return result;
    }
}

