/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Function
implements Expression {
    private String name;
    private Expression[] args;
    private Class type;
    private FunctionDescriptor descriptor;
    private boolean implicit = false;

    public Function(String name, Expression[] args) {
        this.name = name;
        this.args = args;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public Expression getArg(int index) {
        return this.args[index];
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public void makeImplicit() {
        this.implicit = true;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void insertConversion(int index, FunctionDescriptor functionDescriptor) {
        Class<?> type = functionDescriptor.getReturnType();
        String typeName = DataTypeManager.getDataTypeName(type);
        Expression[] newArg = new Expression[]{this.args[index], new Constant(typeName)};
        Function func = new Function(functionDescriptor.getName(), newArg);
        this.args[index] = func;
        func.setFunctionDescriptor(functionDescriptor);
        func.setType(type);
        func.makeImplicit();
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.descriptor;
    }

    public void setFunctionDescriptor(FunctionDescriptor fd) {
        this.descriptor = fd;
    }

    @Override
    public boolean isResolved() {
        boolean resolved = true;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].isResolved()) continue;
            resolved = false;
        }
        return resolved;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (this.descriptor != null && other.descriptor != null ? !this.descriptor.getMethod().equals((Object)other.descriptor.getMethod()) : !other.getName().equalsIgnoreCase(this.getName())) {
            return false;
        }
        if (this.isImplicit() != other.isImplicit()) {
            return false;
        }
        Object[] otherArgs = other.getArgs();
        Object[] thisArgs = this.getArgs();
        return EquivalenceUtil.areEquivalent((Object[])thisArgs, (Object[])otherArgs);
    }

    public int hashCode() {
        int hashCode = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.getName().toUpperCase()});
        Expression[] thisArgs = this.getArgs();
        if (thisArgs != null && thisArgs.length > 0 && thisArgs[0] != null) {
            hashCode = HashCodeUtil.hashCode((int)hashCode, (int)thisArgs[0].hashCode());
        }
        return hashCode;
    }

    @Override
    public Object clone() {
        Expression[] args = this.getArgs();
        Expression[] copyArgs = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            copyArgs[i] = (Expression)args[i].clone();
        }
        Function copy = new Function(this.getName(), copyArgs);
        copy.setType(this.getType());
        copy.setFunctionDescriptor(this.getFunctionDescriptor());
        if (this.isImplicit()) {
            copy.makeImplicit();
        }
        return copy;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

