/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataRepository;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.navigator.PostOrderNavigator;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.tempdata.AlterTempTable;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTable;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class TempTableDataManager
implements ProcessorDataManager {
    private static final String REFRESHMATVIEWROW = ".refreshmatviewrow";
    private static final String REFRESHMATVIEW = ".refreshmatview";
    public static final String CODE_PREFIX = "#CODE_";
    private ProcessorDataManager processorDataManager;
    private BufferManager bufferManager;
    private SessionAwareCache<CachedResults> cache;
    private Executor executor;
    private EventDistributor eventDistributor;

    public TempTableDataManager(ProcessorDataManager processorDataManager, BufferManager bufferManager, Executor executor, SessionAwareCache<CachedResults> cache) {
        this.processorDataManager = processorDataManager;
        this.bufferManager = bufferManager;
        this.executor = executor;
        this.cache = cache;
    }

    public void setEventDistributor(EventDistributor eventDistributor) {
        this.eventDistributor = eventDistributor;
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException, TeiidProcessingException {
        TupleSource result;
        TempTableStore tempTableStore = context.getTempTableStore();
        if (tempTableStore != null && (result = this.registerRequest(context, modelName, command)) != null) {
            return result;
        }
        return this.processorDataManager.registerRequest(context, command, modelName, connectorBindingId, nodeID, limit);
    }

    TupleSource registerRequest(CommandContext context, String modelName, Command command) throws TeiidComponentException, TeiidProcessingException {
        TempTableStore contextStore = context.getTempTableStore();
        if (command instanceof Query) {
            Query query = (Query)command;
            if (modelName != null && !modelName.equals(TempMetadataAdapter.TEMP_MODEL.getID())) {
                return null;
            }
            return this.registerQuery(context, contextStore, query);
        }
        if (command instanceof ProcedureContainer) {
            if (command instanceof StoredProcedure) {
                StoredProcedure proc = (StoredProcedure)command;
                if ("SYSADMIN".equals(modelName)) {
                    TupleSource result = this.handleSystemProcedures(context, proc);
                    if (result != null) {
                        return result;
                    }
                } else if (proc.getGroup().isGlobalTable()) {
                    return this.handleCachedProcedure(context, proc);
                }
                return null;
            }
            GroupSymbol group = ((ProcedureContainer)command).getGroup();
            if (!group.isTempGroupSymbol()) {
                return null;
            }
            String groupKey = group.getNonCorrelationName().toUpperCase();
            TempTable table = contextStore.getOrCreateTempTable(groupKey, command, this.bufferManager, true, true, context);
            if (command instanceof Insert) {
                Insert insert = (Insert)command;
                TupleSource ts = insert.getTupleSource();
                if (ts == null) {
                    ArrayList<Object> values = new ArrayList<Object>(insert.getValues().size());
                    for (Expression expr : insert.getValues()) {
                        values.add(Evaluator.evaluate(expr));
                    }
                    ts = new CollectionTupleSource(Arrays.asList(values).iterator());
                }
                return table.insert(ts, insert.getVariables(), true);
            }
            if (command instanceof Update) {
                Update update = (Update)command;
                Criteria crit = update.getCriteria();
                return table.update(crit, update.getChangeList());
            }
            if (command instanceof Delete) {
                Delete delete = (Delete)command;
                Criteria crit = delete.getCriteria();
                if (crit == null) {
                    int rows = table.truncate(false);
                    return CollectionTupleSource.createUpdateCountTupleSource(rows);
                }
                return table.delete(crit);
            }
        }
        if (command instanceof Create) {
            Create create = (Create)command;
            String tempTableName = create.getTable().getCanonicalName();
            if (contextStore.hasTempTable(tempTableName)) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableStore.table_exist_error", new Object[]{tempTableName}));
            }
            contextStore.addTempTable(tempTableName, create, this.bufferManager, true, context);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        if (command instanceof Drop) {
            String tempTableName = ((Drop)command).getTable().getCanonicalName();
            contextStore.removeTempTableByName(tempTableName, context);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        if (command instanceof AlterTempTable) {
            AlterTempTable att = (AlterTempTable)command;
            TempTable tt = contextStore.getTempTable(att.getTempTable().toUpperCase());
            Assertion.isNotNull((Object)tt, (String)"Table doesn't exist");
            tt.setUpdatable(false);
            if (att.getIndexColumns() != null && tt.getRowCount() > 2 * tt.getTree().getPageSize(true)) {
                tt.addIndex(att.getIndexColumns(), false);
            }
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        return null;
    }

    private TupleSource handleCachedProcedure(CommandContext context, StoredProcedure proc) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        String fullName = context.getMetadata().getFullName(proc.getProcedureID());
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"processing cached procedure request for", fullName});
        LinkedList<Object> vals = new LinkedList<Object>();
        for (SPParameter param : proc.getInputParameters()) {
            vals.add(((Constant)param.getExpression()).getValue());
        }
        int hash = vals.hashCode();
        hash |= hash >>> 16;
        hash |= hash >>> 8;
        SessionAwareCache.CacheID cid = new SessionAwareCache.CacheID(new ParseInfo(), fullName + (hash &= 0xFF), context.getVdbName(), context.getVdbVersion(), context.getConnectionID(), context.getUserName());
        cid.setParameters(vals);
        CachedResults results = this.cache.get(cid);
        if (results != null) {
            TupleBuffer buffer = results.getResults();
            return buffer.createIndexedTupleSource();
        }
        CacheHint hint = proc.getCacheHint();
        proc.setCacheHint(null);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup(fullName);
        proc.setOption(option);
        FunctionMethod.Determinism determinismLevel = context.resetDeterminismLevel();
        QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(proc.toString(), fullName.toUpperCase(), context, new Object[0]);
        qp.setNonBlocking(true);
        qp.getContext().setDataObjects(null);
        BatchCollector bc = qp.createBatchCollector();
        TupleBuffer tb = bc.collectTuples();
        CachedResults cr = new CachedResults();
        cr.setResults(tb, qp.getProcessorPlan());
        cr.setHint(hint);
        if (hint != null && hint.getDeterminism() != null) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Cache hint modified the query determinism from ", determinismLevel, " to ", hint.getDeterminism()});
            determinismLevel = hint.getDeterminism();
        }
        this.cache.put(cid, determinismLevel, cr, hint != null ? hint.getTtl() : null);
        context.setDeterminismLevel(determinismLevel);
        return tb.createIndexedTupleSource();
    }

    private TupleSource handleSystemProcedures(CommandContext context, StoredProcedure proc) throws TeiidComponentException, QueryMetadataException, QueryProcessingException, QueryResolverException, QueryValidatorException, TeiidProcessingException, ExpressionEvaluationException {
        QueryMetadataInterface metadata = context.getMetadata();
        GlobalTableStore globalStore = context.getGlobalTableStore();
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEW)) {
            Object groupID = this.validateMatView(metadata, (String)((Constant)proc.getParameter(1).getExpression()).getValue());
            TempMetadataID matTableId = globalStore.getGlobalTempTableMetadataId(groupID);
            String matViewName = metadata.getFullName(groupID);
            String matTableName = metadata.getFullName(matTableId);
            LogManager.logDetail((String)"org.teiid.PROCESSOR.MATVIEWS", (Object[])new Object[]{"processing refreshmatview for", matViewName});
            boolean invalidate = Boolean.TRUE.equals(((Constant)proc.getParameter(2).getExpression()).getValue());
            boolean needsLoading = globalStore.needsLoading(matTableName, globalStore.getLocalAddress(), true, true, invalidate);
            if (!needsLoading) {
                return CollectionTupleSource.createUpdateCountTupleSource(-1);
            }
            GroupSymbol matTable = new GroupSymbol(matTableName);
            matTable.setMetadataID(matTableId);
            int rowCount = this.loadGlobalTable(context, matTable, matTableName, globalStore);
            return CollectionTupleSource.createUpdateCountTupleSource(rowCount);
        }
        if (StringUtil.endsWithIgnoreCase((String)proc.getProcedureCallableName(), (String)REFRESHMATVIEWROW)) {
            Object groupID = this.validateMatView(metadata, (String)((Constant)proc.getParameter(1).getExpression()).getValue());
            Object pk = metadata.getPrimaryKey(groupID);
            String matViewName = metadata.getFullName(groupID);
            if (pk == null) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.row_refresh_pk", new Object[]{matViewName}));
            }
            List ids = metadata.getElementIDsInKey(pk);
            if (ids.size() > 1) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.row_refresh_composite", new Object[]{matViewName}));
            }
            String matTableName = "#MAT_" + matViewName.toUpperCase();
            GlobalTableStoreImpl.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
            if (!info.isValid()) {
                return CollectionTupleSource.createUpdateCountTupleSource(-1);
            }
            TempTable tempTable = globalStore.getTempTableStore().getTempTable(matTableName);
            if (!tempTable.isUpdatable()) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.row_refresh_updatable", new Object[]{matViewName}));
            }
            Constant key = (Constant)proc.getParameter(2).getExpression();
            LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.row_refresh", new Object[]{matViewName, key}));
            String queryString = "SELECT * FROM " + matViewName + ' ' + "WHERE" + ' ' + metadata.getFullName(ids.iterator().next()) + " = ?" + ' ' + "OPTION" + ' ' + "NOCACHE";
            QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(queryString, matViewName.toUpperCase(), context, key.getValue());
            qp.setNonBlocking(true);
            qp.getContext().setDataObjects(null);
            BatchCollector.BatchProducerTupleSource ts = new BatchCollector.BatchProducerTupleSource(qp);
            List<Object> tuple = ts.nextTuple();
            boolean delete = false;
            if (tuple == null) {
                delete = true;
                tuple = Arrays.asList(key.getValue());
            } else {
                tuple = new ArrayList(tuple);
            }
            List<?> result = globalStore.updateMatViewRow(matTableName, tuple, delete);
            if (this.eventDistributor != null) {
                this.eventDistributor.updateMatViewRow(context.getVdbName(), context.getVdbVersion(), metadata.getName(metadata.getModelID(groupID)), metadata.getName(groupID), tuple, delete);
            }
            return CollectionTupleSource.createUpdateCountTupleSource(result != null ? 1 : 0);
        }
        return null;
    }

    private Object validateMatView(QueryMetadataInterface metadata, String viewName) throws TeiidComponentException, TeiidProcessingException {
        try {
            Object groupID = metadata.getGroupID(viewName);
            if (!metadata.hasMaterialization(groupID) || metadata.getMaterialization(groupID) != null) {
                throw new QueryProcessingException(QueryPlugin.Util.getString("TempTableDataManager.not_implicit_matview", new Object[]{viewName}));
            }
            return groupID;
        }
        catch (QueryMetadataException e) {
            throw new TeiidProcessingException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TupleSource registerQuery(CommandContext context, TempTableStore contextStore, Query query) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException, ExpressionEvaluationException, QueryProcessingException {
        GroupSymbol group = query.getFrom().getGroups().get(0);
        if (!group.isTempGroupSymbol()) {
            return null;
        }
        final String tableName = group.getNonCorrelationName().toUpperCase();
        boolean remapColumns = !tableName.equalsIgnoreCase(group.getName());
        TempTable table = null;
        if (group.isGlobalTable()) {
            GlobalTableStore globalStore = context.getGlobalTableStore();
            GlobalTableStoreImpl.MatTableInfo info = globalStore.getMatTableInfo(tableName);
            boolean load = false;
            while (!(info.isUpToDate() || (load = globalStore.needsLoading(tableName, globalStore.getLocalAddress(), true, false, false)) && (load = globalStore.needsLoading(tableName, globalStore.getLocalAddress(), false, false, false)))) {
                GlobalTableStoreImpl.MatTableInfo matTableInfo = info;
                synchronized (matTableInfo) {
                    try {
                        info.wait(30000L);
                    }
                    catch (InterruptedException e) {
                        throw new TeiidComponentException((Throwable)e);
                    }
                }
            }
            if (load) {
                if (!info.isValid()) {
                    this.loadGlobalTable(context, group, tableName, globalStore);
                } else {
                    this.loadAsynch(context, group, tableName, globalStore);
                }
            }
            table = globalStore.getTempTableStore().getOrCreateTempTable(tableName, query, this.bufferManager, false, false, context);
            context.accessedDataObject(group.getMetadataID());
        } else {
            Object id;
            table = contextStore.getOrCreateTempTable(tableName, query, this.bufferManager, true, false, context);
            if (context.getDataObjects() != null && (id = RelationalPlanner.getTrackableGroup(group, context.getMetadata())) != null) {
                context.accessedDataObject(group.getMetadataID());
            }
        }
        if (remapColumns) {
            ExpressionMappingVisitor emv = new ExpressionMappingVisitor(null){

                @Override
                public Expression replaceExpression(Expression element) {
                    if (element instanceof ElementSymbol) {
                        ElementSymbol es = (ElementSymbol)element;
                        es.getGroupSymbol().setName(tableName);
                        es.getGroupSymbol().setDefinition(null);
                    }
                    return element;
                }
            };
            PostOrderNavigator.doVisit(query, emv);
        }
        return table.createTupleSource(query.getProjectedSymbols(), query.getCriteria(), query.getOrderBy());
    }

    private void loadAsynch(final CommandContext context, final GroupSymbol group, final String tableName, final GlobalTableStore globalStore) {
        Callable<Integer> toCall = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return TempTableDataManager.this.loadGlobalTable(context, group, tableName, globalStore);
            }
        };
        FutureTask<Integer> task = new FutureTask<Integer>(toCall);
        this.executor.execute(task);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadGlobalTable(CommandContext context, GroupSymbol group, String tableName, GlobalTableStore globalStore) throws TeiidComponentException, TeiidProcessingException {
        LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.loading", new Object[]{tableName}));
        QueryMetadataInterface metadata = context.getMetadata();
        List<ElementSymbol> allColumns = ResolverUtil.resolveElementsInGroup(group, metadata);
        TempTable table = globalStore.createMatTable(tableName, group);
        table.setUpdatable(false);
        int rowCount = -1;
        try {
            List<ElementSymbol> columns;
            String fullName = metadata.getFullName(group.getMetadataID());
            String transformation = metadata.getVirtualPlan(group.getMetadataID()).getQuery();
            QueryProcessor qp = context.getQueryProcessorFactory().createQueryProcessor(transformation, fullName, context, new Object[0]);
            qp.setNonBlocking(true);
            qp.getContext().setDataObjects(null);
            BatchCollector.BatchProducerTupleSource ts = new BatchCollector.BatchProducerTupleSource(qp);
            table.insert(ts, allColumns, false);
            table.getTree().compact();
            rowCount = table.getRowCount();
            for (Object index : metadata.getIndexesInGroup(group.getMetadataID())) {
                columns = GlobalTableStoreImpl.resolveIndex(metadata, allColumns, index);
                table.addIndex(columns, false);
            }
            for (Object key : metadata.getUniqueKeysInGroup(group.getMetadataID())) {
                columns = GlobalTableStoreImpl.resolveIndex(metadata, allColumns, key);
                table.addIndex(columns, true);
            }
            CacheHint hint = table.getCacheHint();
            if (hint != null && table.getPkLength() > 0) {
                table.setUpdatable(hint.isUpdatable());
            }
            if (rowCount == -1) {
                globalStore.failedLoad(tableName);
                return rowCount;
            }
            globalStore.loaded(tableName, table);
        }
        catch (TeiidComponentException e) {
            try {
                LogManager.logError((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (String)QueryPlugin.Util.getString("TempTableDataManager.failed_load", new Object[]{tableName}));
                throw e;
                catch (TeiidProcessingException e2) {
                    LogManager.logError((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e2, (String)QueryPlugin.Util.getString("TempTableDataManager.failed_load", new Object[]{tableName}));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (rowCount == -1) {
                    globalStore.failedLoad(tableName);
                    throw throwable;
                }
                globalStore.loaded(tableName, table);
                LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.loaded", new Object[]{tableName, rowCount}));
                throw throwable;
            }
        }
        LogManager.logInfo((String)"org.teiid.PROCESSOR.MATVIEWS", (String)QueryPlugin.Util.getString("TempTableDataManager.loaded", new Object[]{tableName, rowCount}));
        return rowCount;
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        String matTableName = CODE_PREFIX + (codeTableName + "." + keyElementName + "." + returnElementName).toUpperCase();
        QueryMetadataInterface metadata = context.getMetadata();
        TempMetadataID id = context.getGlobalTableStore().getCodeTableMetadataId(codeTableName, returnElementName, keyElementName, matTableName);
        ElementSymbol keyElement = new ElementSymbol(matTableName + "." + keyElementName);
        ElementSymbol returnElement = new ElementSymbol(matTableName + "." + returnElementName);
        keyElement.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(metadata.getElementID(codeTableName + "." + keyElementName))));
        returnElement.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(metadata.getElementID(codeTableName + "." + returnElementName))));
        Query query = RelationalPlanner.createMatViewQuery(id, matTableName, Arrays.asList(returnElement), true);
        query.setCriteria(new CompareCriteria(keyElement, 1, new Constant(keyValue)));
        TupleSource ts = this.registerQuery(context, context.getTempTableStore(), query);
        List<?> row = ts.nextTuple();
        Object result = null;
        if (row != null) {
            result = row.get(0);
        }
        ts.closeSource();
        return result;
    }

    @Override
    public EventDistributor getEventDistributor() {
        return this.eventDistributor;
    }

    @Override
    public MetadataRepository getMetadataRepository() {
        return this.processorDataManager.getMetadataRepository();
    }
}

