/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jgroups.ChannelFactory;
import org.jgroups.JChannelFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.query.ObjectReplicator;
import org.teiid.replication.jboss.JGroupsObjectReplicator;
import org.teiid.systemmodel.TestMatViews;

public class TestMatViewReplication {
    private static final String MATVIEWS = "matviews";
    private static final boolean DEBUG = false;

    @BeforeClass
    public static void oneTimeSetup() {
        System.setProperty("jgroups.bind_addr", "127.0.0.1");
    }

    @Test
    public void testReplication() throws Exception {
        FakeServer server1 = this.createServer();
        ConnectionImpl c1 = server1.createConnection("jdbc:teiid:matviews");
        Statement stmt = c1.createStatement();
        stmt.execute("select * from TEST.RANDOMVIEW");
        ResultSet rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        double d1 = rs.getDouble(1);
        double d2 = rs.getDouble(2);
        FakeServer server2 = this.createServer();
        ConnectionImpl c2 = server2.createConnection("jdbc:teiid:matviews");
        Statement stmt2 = c2.createStatement();
        ResultSet rs2 = stmt2.executeQuery("select * from matviews where name = 'RandomView'");
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((Object)"LOADED", (Object)rs2.getString("loadstate"));
        Assert.assertEquals((Object)true, (Object)rs2.getBoolean("valid"));
        stmt2.execute("select * from TEST.RANDOMVIEW");
        rs2 = stmt2.getResultSet();
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((double)d1, (double)rs2.getDouble(1), (double)0.0);
        Assert.assertEquals((double)d2, (double)rs2.getDouble(2), (double)0.0);
        rs2 = stmt2.executeQuery("select * from (call refreshMatView('TEST.RANDOMVIEW', false)) p");
        Thread.sleep(1000L);
        stmt.execute("select * from TEST.RANDOMVIEW");
        rs = stmt.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        d1 = rs.getDouble(1);
        d2 = rs.getDouble(2);
        stmt2.execute("select * from TEST.RANDOMVIEW");
        rs2 = stmt2.getResultSet();
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((double)d1, (double)rs2.getDouble(1), (double)0.0);
        Assert.assertEquals((double)d2, (double)rs2.getDouble(2), (double)0.0);
        rs2 = stmt2.executeQuery("select lookup('sys.schemas', 'VDBName', 'name', 'SYS')");
        Thread.sleep(1000L);
        rs = stmt.executeQuery("select lookup('sys.schemas', 'VDBName', 'name', 'SYS')");
        rs.next();
        Assert.assertEquals((Object)MATVIEWS, (Object)rs.getString(1));
        server1.stop();
        server2.stop();
    }

    private FakeServer createServer() throws Exception {
        FakeServer server = new FakeServer();
        JGroupsObjectReplicator jor = new JGroupsObjectReplicator();
        jor.setClusterName("demo");
        jor.setMultiplexerStack("tcp");
        JChannelFactory jcf = new JChannelFactory();
        jcf.setMultiplexerConfig(this.getClass().getClassLoader().getResource("stacks.xml"));
        jor.setChannelFactory((ChannelFactory)jcf);
        server.setReplicator((ObjectReplicator)jor);
        HashMap<String, Collection<FunctionMethod>> udfs = new HashMap<String, Collection<FunctionMethod>>();
        udfs.put("funcs", Arrays.asList(new FunctionMethod("pause", null, null, FunctionMethod.PushDown.CANNOT_PUSHDOWN, TestMatViews.class.getName(), "pause", null, new FunctionParameter("return", "integer"), false, FunctionMethod.Determinism.NONDETERMINISTIC)));
        server.deployVDB(MATVIEWS, UnitTestUtil.getTestDataPath() + "/matviews.vdb", udfs);
        return server;
    }
}

