/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;

public class TestDataPolicyMetaData {
    @Test
    public void testAllowed() {
        DataPolicyMetadata policy = new DataPolicyMetadata();
        policy.setName("readOnly");
        policy.setDescription("Only has read only permissions");
        policy.setMappedRoleNames(Arrays.asList("jack", "susan"));
        DataPolicyMetadata.PermissionMetaData perm1 = new DataPolicyMetadata.PermissionMetaData();
        perm1.setResourceName("catalog.schema.Table1");
        perm1.setAllowRead(Boolean.valueOf(true));
        DataPolicyMetadata.PermissionMetaData perm2 = new DataPolicyMetadata.PermissionMetaData();
        perm2.setResourceName("catalog.schema.Table2");
        perm2.setAllowRead(Boolean.valueOf(false));
        DataPolicyMetadata.PermissionMetaData perm3 = new DataPolicyMetadata.PermissionMetaData();
        perm3.setResourceName("catalog.schema.Table3");
        perm3.setAllowRead(Boolean.valueOf(true));
        DataPolicyMetadata.PermissionMetaData perm4 = new DataPolicyMetadata.PermissionMetaData();
        perm4.setResourceName("catalog.schema.Table4");
        perm4.setAllowRead(Boolean.valueOf(true));
        DataPolicyMetadata.PermissionMetaData perm5 = new DataPolicyMetadata.PermissionMetaData();
        perm5.setResourceName("catalog.schema.Table5.column1");
        perm5.setAllowRead(Boolean.valueOf(true));
        policy.addPermission(new DataPolicyMetadata.PermissionMetaData[]{perm1, perm2, perm3, perm4, perm5});
        Assert.assertTrue((boolean)policy.allows("catalog.schema.Table1", DataPolicy.PermissionType.READ));
        Assert.assertFalse((boolean)policy.allows("catalog.schema.Table1", DataPolicy.PermissionType.CREATE));
        Assert.assertFalse((boolean)policy.allows("catalog.schema", DataPolicy.PermissionType.READ));
        Assert.assertFalse((boolean)policy.allows("catalog.schema.Table2.column", DataPolicy.PermissionType.READ));
        Assert.assertFalse((boolean)policy.allows("catalog.schema.Table2", DataPolicy.PermissionType.READ));
        Assert.assertTrue((boolean)policy.allows("catalog.schema.Table3.column", DataPolicy.PermissionType.READ));
        Assert.assertTrue((boolean)policy.allows("catalog.schema.Table3", DataPolicy.PermissionType.READ));
        Assert.assertTrue((boolean)policy.allows("catalog.schema.Table4.column", DataPolicy.PermissionType.READ));
        Assert.assertTrue((boolean)policy.allows("catalog.schema.Table4", DataPolicy.PermissionType.READ));
        Assert.assertFalse((boolean)policy.allows("catalog.schema.Table4", DataPolicy.PermissionType.DELETE));
        Assert.assertTrue((boolean)policy.allows("catalog.schema.Table5.column1", DataPolicy.PermissionType.READ));
        Assert.assertFalse((boolean)policy.allows("catalog.schema.Table5.column2", DataPolicy.PermissionType.READ));
        Assert.assertFalse((boolean)policy.allows("catalog.schema.Table5", DataPolicy.PermissionType.READ));
    }
}

