/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.security.LogonResult;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.net.ServerConnection;

public class TestCallableStatement
extends TestCase {
    public void testWasNull() throws Exception {
        ResultSetImpl rs;
        HashMap<Integer, Integer> params;
        CallableStatementImpl mmcs = this.getCallableStatement();
        mmcs.outParamIndexMap = params = new HashMap<Integer, Integer>();
        params.put(1, 1);
        params.put(2, 2);
        mmcs.resultSet = rs = (ResultSetImpl)Mockito.mock(ResultSetImpl.class);
        Mockito.stub((Object)rs.getOutputParamValue(1)).toReturn(null);
        Mockito.stub((Object)rs.getOutputParamValue(2)).toReturn((Object)Boolean.TRUE);
        mmcs.getBoolean(1);
        TestCallableStatement.assertTrue((boolean)mmcs.wasNull());
        TestCallableStatement.assertTrue((boolean)mmcs.getBoolean(2));
        TestCallableStatement.assertFalse((boolean)mmcs.wasNull());
    }

    public void testGetOutputParameter() throws Exception {
        CallableStatementImpl mmcs = this.getCallableStatement();
        RequestMessage request = new RequestMessage();
        request.setExecutionId(1L);
        ResultsMessage resultsMsg = new ResultsMessage();
        List[] results = new List[]{Arrays.asList(null, null, null), Arrays.asList(null, 1, 2)};
        resultsMsg.setResults(results);
        resultsMsg.setColumnNames(new String[]{"IntNum", "Out1", "Out2"});
        resultsMsg.setDataTypes(new String[]{"integer", "integer", "integer"});
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        resultsMsg.setParameters(Arrays.asList(new ParameterInfo(5, 1), new ParameterInfo(2, 1), new ParameterInfo(2, 1)));
        mmcs.createResultSet(resultsMsg);
        TestCallableStatement.assertEquals((int)1, (int)mmcs.getInt(1));
        TestCallableStatement.assertEquals((int)2, (int)mmcs.getInt(2));
    }

    public void testUnknownIndex() throws Exception {
        CallableStatementImpl mmcs = this.getCallableStatement();
        mmcs.outParamIndexMap = new HashMap();
        try {
            mmcs.getBoolean(0);
            TestCallableStatement.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            TestCallableStatement.assertEquals((String)"Parameter is not found at index 0.", (String)e.getMessage());
        }
    }

    private CallableStatementImpl getCallableStatement() throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ServerConnection sc = (ServerConnection)Mockito.mock(ServerConnection.class);
        Mockito.stub((Object)sc.getLogonResult()).toReturn((Object)new LogonResult());
        Mockito.stub((Object)conn.getServerConnection()).toReturn((Object)sc);
        CallableStatementImpl mmcs = new CallableStatementImpl(conn, "{?=call x(?)}", 1003, 1007);
        return mmcs;
    }
}

