/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TestConnection;
import org.teiid.jdbc.XAConnectionImpl;

public class TestXAConnection {
    @Test
    public void testConnectionClose() throws Exception {
        final ConnectionImpl mmConn = TestConnection.getMMConnection();
        XAConnectionImpl xaConn = new XAConnectionImpl(new XAConnectionImpl.ConnectionSource(){

            public ConnectionImpl createConnection() throws SQLException {
                return mmConn;
            }
        });
        Connection conn = xaConn.getConnection();
        StatementImpl stmt = (StatementImpl)conn.createStatement();
        conn.setAutoCommit(false);
        conn.close();
        Assert.assertTrue((boolean)stmt.isClosed());
        Assert.assertTrue((boolean)conn.getAutoCommit());
        conn = xaConn.getConnection();
        stmt = (StatementImpl)conn.createStatement();
        XAResource resource = xaConn.getXAResource();
        resource.start((Xid)new XidImpl(1, new byte[0], new byte[0]), 0);
        conn.close();
        Assert.assertTrue((boolean)stmt.isClosed());
        Assert.assertTrue((boolean)conn.getAutoCommit());
    }

    @Test
    public void testNotification() throws Exception {
        XAConnectionImpl xaConn = new XAConnectionImpl(new XAConnectionImpl.ConnectionSource(){

            public ConnectionImpl createConnection() throws SQLException {
                ConnectionImpl c = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
                ((ConnectionImpl)Mockito.doThrow((Throwable)new SQLException((Throwable)new InvalidSessionException())).when((Object)c)).commit();
                return c;
            }
        });
        ConnectionEventListener cel = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        xaConn.addConnectionEventListener(cel);
        Connection c = xaConn.getConnection();
        try {
            c.commit();
        }
        catch (SQLException e) {
            // empty catch block
        }
        ((ConnectionEventListener)Mockito.verify((Object)cel)).connectionErrorOccurred((ConnectionEvent)Mockito.anyObject());
    }
}

