/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestSourceHints {
    @Test
    public void testUserQueryHint() {
        String sql = "SELECT /*+ sh:'foo' bar:'leading' */ e1 from pm1.g1 order by e1 limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, this.manager("foo", "leading"), expected);
    }

    @Test
    public void testHintInView() {
        MetadataStore metadataStore = new MetadataStore();
        Schema p1 = RealMetadataFactory.createPhysicalModel("p1", metadataStore);
        Table t1 = RealMetadataFactory.createPhysicalGroup("t", p1);
        RealMetadataFactory.createElements(t1, new String[]{"a", "b"}, new String[]{"string", "string"});
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        QueryNode n1 = new QueryNode("SELECT /*+ sh:'x' */ a as c, b FROM p1.t");
        Table vt1 = RealMetadataFactory.createVirtualGroup("t1", v1, n1);
        RealMetadataFactory.createElements(vt1, new String[]{"c", "b"}, new String[]{"string", "string"});
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "metadata", new FunctionTree[0]);
        HardcodedDataManager manager = this.manager("foo", "leading");
        String sql = "SELECT /*+ sh:'foo' bar:'leading' */ c from t1 order by c limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, manager, expected);
        manager = this.manager("x", null);
        sql = "SELECT c from t1 order by c limit 1";
        plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, manager, expected);
        manager = this.manager(null, null);
        sql = "SELECT c from t1 union all select c from t1";
        plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    private HardcodedDataManager manager(final String general, final String hint) {
        HardcodedDataManager manager = new HardcodedDataManager(){

            @Override
            public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException {
                if (general == null && hint == null) {
                    Assert.assertNull((Object)context.getSourceHint());
                } else {
                    Assert.assertEquals((Object)general, (Object)context.getSourceHint().getGeneralHint());
                    Assert.assertEquals((Object)hint, (Object)context.getSourceHint().getSourceHint("bar"));
                }
                return CollectionTupleSource.createNullTupleSource();
            }
        };
        return manager;
    }
}

