/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.teiid.query.util.Permutation;

public class TestPermutation
extends TestCase {
    public TestPermutation(String arg0) {
        super(arg0);
    }

    public Object[] exampleItems(int num) {
        Object[] items = new Object[num];
        for (int i = 0; i < items.length; ++i) {
            items[i] = "" + i;
        }
        return items;
    }

    public void compareArrays(Object[] a1, Object[] a2) {
        TestPermutation.assertEquals((String)"Arrays are of differing lengths", (int)a1.length, (int)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            TestPermutation.assertEquals((String)("Arrays have differing object at index " + i), (Object)a1[i], (Object)a2[i]);
        }
    }

    public void compareOrders(List expected, List actual) {
        TestPermutation.assertEquals((String)"Number of orders differs", (int)expected.size(), (int)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            this.compareArrays((Object[])expected.get(i), (Object[])actual.get(i));
        }
    }

    public void testNull() {
        try {
            new Permutation(null);
            TestPermutation.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test1() {
        Permutation perm = new Permutation(this.exampleItems(0));
        Iterator iter = perm.generate();
        TestPermutation.assertTrue((String)"Should get no permutations for no items", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
            TestPermutation.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void test2() {
        Permutation perm = new Permutation(this.exampleItems(2));
        Iterator iter = perm.generate(0);
        TestPermutation.assertTrue((String)"Should get no permutations for no items", (!iter.hasNext() ? 1 : 0) != 0);
    }

    public void test3() {
        Permutation perm = new Permutation(this.exampleItems(1));
        Iterator iter = perm.generate();
        ArrayList orders = new ArrayList();
        while (iter.hasNext()) {
            orders.add(iter.next());
        }
        TestPermutation.assertEquals((String)"Should get one permutations for one item", (int)1, (int)orders.size());
        this.compareArrays(this.exampleItems(1), (Object[])orders.get(0));
    }

    public void test4() {
        Permutation perm = new Permutation(this.exampleItems(2));
        Iterator iter = perm.generate();
        ArrayList orders = new ArrayList();
        while (iter.hasNext()) {
            orders.add(iter.next());
        }
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(new Object[]{"0", "1"});
        expected.add(new Object[]{"1", "0"});
        this.compareOrders(expected, orders);
    }

    public void test5() {
        Permutation perm = new Permutation(this.exampleItems(3));
        Iterator iter = perm.generate();
        ArrayList orders = new ArrayList();
        while (iter.hasNext()) {
            orders.add(iter.next());
        }
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(new Object[]{"0", "1", "2"});
        expected.add(new Object[]{"0", "2", "1"});
        expected.add(new Object[]{"1", "0", "2"});
        expected.add(new Object[]{"1", "2", "0"});
        expected.add(new Object[]{"2", "0", "1"});
        expected.add(new Object[]{"2", "1", "0"});
        this.compareOrders(expected, orders);
    }

    public void test6() {
        Permutation perm = new Permutation(this.exampleItems(3));
        Iterator iter = perm.generate(1);
        ArrayList orders = new ArrayList();
        while (iter.hasNext()) {
            orders.add(iter.next());
        }
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(new Object[]{"0"});
        expected.add(new Object[]{"1"});
        expected.add(new Object[]{"2"});
        this.compareOrders(expected, orders);
    }
}

