/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class FileStorageManager
implements StorageManager {
    public static final int DEFAULT_MAX_OPEN_FILES = 64;
    public static final long DEFAULT_MAX_BUFFERSPACE = 0xC80000000L;
    private static final String FILE_PREFIX = "b_";
    private long maxBufferSpace = 0xC80000000L;
    private AtomicLong usedBufferSpace = new AtomicLong();
    private AtomicInteger fileCounter = new AtomicInteger();
    private int maxOpenFiles = 64;
    private String directory;
    private File dirFile;
    private File[] subDirectories = new File[256];
    private Map<File, RandomAccessFile> fileCache = Collections.synchronizedMap(new LinkedHashMap<File, RandomAccessFile>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, RandomAccessFile> eldest) {
            if (this.size() > FileStorageManager.this.maxOpenFiles) {
                try {
                    eldest.getValue().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    });

    @Override
    public void initialize() throws TeiidComponentException {
        if (this.directory == null) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.no_directory"));
        }
        this.dirFile = new File(this.directory);
        FileStorageManager.makeDir(this.dirFile);
        for (int i = 0; i < this.subDirectories.length; ++i) {
            this.subDirectories[i] = new File(this.directory, "b" + i);
            FileStorageManager.makeDir(this.subDirectories[i]);
        }
    }

    private static void makeDir(File file) throws TeiidComponentException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.not_a_directory", new Object[]{file.getAbsoluteFile()}));
            }
        } else if (!file.mkdirs()) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.error_creating", new Object[]{file.getAbsoluteFile()}));
        }
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public void setStorageDirectory(String directory) {
        this.directory = directory;
    }

    File createFile(String name) throws IOException {
        File storageFile = File.createTempFile(FILE_PREFIX + name + "_", null, this.subDirectories[this.fileCounter.getAndIncrement() & this.subDirectories.length - 1]);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Created temporary storage area file " + storageFile.getAbsoluteFile()});
        }
        return storageFile;
    }

    @Override
    public FileStore createFileStore(String name) {
        return new DiskStore(name);
    }

    public String getDirectory() {
        return this.directory;
    }

    Map<File, RandomAccessFile> getFileCache() {
        return this.fileCache;
    }

    public int getOpenFiles() {
        return this.fileCache.size();
    }

    public long getUsedBufferSpace() {
        return this.usedBufferSpace.get();
    }

    public void setMaxBufferSpace(long maxBufferSpace) {
        this.maxBufferSpace = maxBufferSpace;
    }

    public class DiskStore
    extends FileStore {
        private String name;
        private FileInfo fileInfo;

        public DiskStore(String name) {
            this.name = name;
        }

        @Override
        public synchronized long getLength() {
            if (this.fileInfo == null) {
                return 0L;
            }
            return this.fileInfo.file.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized int readWrite(long fileOffset, byte[] b, int offSet, int length, boolean write) throws IOException {
            if (!write) {
                if (this.fileInfo == null) {
                    return -1;
                }
                try {
                    RandomAccessFile fileAccess = this.fileInfo.open();
                    fileAccess.seek(fileOffset);
                    int n = fileAccess.read(b, offSet, length);
                    return n;
                }
                finally {
                    this.fileInfo.close();
                }
            }
            if (this.fileInfo == null) {
                this.fileInfo = new FileInfo(FileStorageManager.this.createFile(this.name));
            }
            long bytesUsed = 0L;
            try {
                RandomAccessFile fileAccess = this.fileInfo.open();
                long newLength = fileOffset + (long)length;
                bytesUsed = newLength - fileAccess.length();
                if (bytesUsed > 0L) {
                    long used = FileStorageManager.this.usedBufferSpace.addAndGet(bytesUsed);
                    if (used > FileStorageManager.this.maxBufferSpace) {
                        throw new IOException(QueryPlugin.Util.getString("FileStoreageManager.space_exhausted", new Object[]{FileStorageManager.this.maxBufferSpace}));
                    }
                    fileAccess.setLength(newLength);
                    bytesUsed = 0L;
                }
                fileAccess.seek(fileOffset);
                fileAccess.write(b, offSet, length);
            }
            finally {
                if (bytesUsed > 0L) {
                    FileStorageManager.this.usedBufferSpace.addAndGet(-bytesUsed);
                }
                this.fileInfo.close();
            }
            return length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void setLength(long length) throws IOException {
            if (this.fileInfo == null) {
                this.fileInfo = new FileInfo(FileStorageManager.this.createFile(this.name));
            }
            try {
                this.fileInfo.open().setLength(length);
            }
            finally {
                this.fileInfo.close();
            }
        }

        @Override
        public synchronized void removeDirect() {
            FileStorageManager.this.usedBufferSpace.addAndGet(-this.getLength());
            if (this.fileInfo != null) {
                this.fileInfo.delete();
            }
        }
    }

    private class FileInfo {
        private File file;
        private RandomAccessFile fileData;

        public FileInfo(File file) {
            this.file = file;
        }

        public RandomAccessFile open() throws FileNotFoundException {
            if (this.fileData == null) {
                this.fileData = (RandomAccessFile)FileStorageManager.this.fileCache.remove(this.file);
                if (this.fileData == null) {
                    this.fileData = new RandomAccessFile(this.file, "rw");
                }
            }
            return this.fileData;
        }

        public void close() {
            FileStorageManager.this.fileCache.put(this.file, this.fileData);
            this.fileData = null;
        }

        public void delete() {
            if (this.fileData == null) {
                this.fileData = (RandomAccessFile)FileStorageManager.this.fileCache.remove(this.file);
            }
            if (this.fileData != null) {
                try {
                    this.fileData.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.file.delete();
        }

        public String toString() {
            return "FileInfo<" + this.file.getName() + ", has fileData = " + (this.fileData != null) + ">";
        }
    }
}

