/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import org.teiid.common.buffer.BaseCacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.core.TeiidRuntimeException;

final class PhysicalInfo
extends BaseCacheEntry {
    static final Exception sizeChanged = new Exception();
    final Long gid;
    int inode = -1;
    int memoryBlockCount;
    int block = -1;
    byte sizeIndex = 0;
    boolean pinned;
    boolean evicting;
    boolean loading;
    boolean adding;

    PhysicalInfo(Long gid, Long id, int inode, int lastAccess) {
        super(new CacheKey(id, lastAccess, 0L));
        this.inode = inode;
        this.gid = gid;
    }

    void setSize(int size) throws Exception {
        int newMemoryBlockCount = (size >> 13) + ((size & 0x1FFF) > 0 ? 1 : 0);
        if (this.memoryBlockCount != 0) {
            if (newMemoryBlockCount != this.memoryBlockCount) {
                throw sizeChanged;
            }
            return;
        }
        this.memoryBlockCount = newMemoryBlockCount;
        while (newMemoryBlockCount > 1) {
            this.sizeIndex = (byte)(this.sizeIndex + 1);
            newMemoryBlockCount = (newMemoryBlockCount >> 1) + ((newMemoryBlockCount & 1) == 0 ? 0 : 1);
        }
    }

    void await(boolean donePinning, boolean doneEvicting) {
        while (donePinning && this.pinned || doneEvicting && this.evicting) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
    }

    synchronized void lockForLoad() {
        while (this.loading) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        this.loading = true;
    }

    synchronized void unlockForLoad() {
        assert (this.loading);
        this.loading = false;
        this.notifyAll();
    }
}

